/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.features.mapProvider;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;
import locus.api.android.features.mapProvider.IMapTileService;
import locus.api.android.features.mapProvider.MapDataContainer;
import locus.api.android.features.mapProvider.data.MapConfigLayer;
import locus.api.android.features.mapProvider.data.MapTileRequest;
import locus.api.android.features.mapProvider.data.MapTileResponse;
import locus.api.utils.Logger;

public abstract class MapTileService
extends Service {
    private static final String TAG = MapTileService.class.getSimpleName();
    private final IMapTileService.Stub mBinder = new IMapTileService.Stub(){

        @Override
        public MapDataContainer getMapConfigs() throws RemoteException {
            List<MapConfigLayer> configs = MapTileService.this.getMapConfigs();
            if (configs == null || configs.size() == 0) {
                Logger.logW((String)TAG, (String)"getMapConfigs(), invalid configs");
                return new MapDataContainer(new ArrayList<MapConfigLayer>());
            }
            return new MapDataContainer(configs);
        }

        @Override
        public MapDataContainer getMapTile(MapDataContainer request) throws RemoteException {
            if (request == null || !request.isValid(2)) {
                Logger.logW((String)TAG, (String)("getMapTile(" + request + "), invalid request"));
                MapTileResponse resp = new MapTileResponse();
                resp.setResultCode(2);
                return new MapDataContainer(resp);
            }
            MapTileResponse response = MapTileService.this.getMapTile(request.getTileRequest());
            if (response == null) {
                Logger.logW((String)TAG, (String)("getMapTile(" + request + "), invalid response"));
                MapTileResponse resp = new MapTileResponse();
                resp.setResultCode(4);
                return new MapDataContainer(resp);
            }
            return new MapDataContainer(response);
        }
    };

    public void onCreate() {
        super.onCreate();
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public abstract List<MapConfigLayer> getMapConfigs();

    public abstract MapTileResponse getMapTile(MapTileRequest var1);
}

