/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.features.mapProvider.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;

public class MapConfigLayer
extends Storable {
    private String mName;
    private String mDescription;
    private int mTileSizeX;
    private int mTileSizeY;
    private long mXmax;
    private long mYmax;
    private int mZoom;
    private int mProjEpsg;
    private List<CalibrationPoint> mCalPoints;

    public MapConfigLayer() {
    }

    public MapConfigLayer(byte[] data) throws IOException {
        super(data);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public int getTileSizeX() {
        return this.mTileSizeX;
    }

    public void setTileSizeX(int tileSizeX) {
        this.mTileSizeX = tileSizeX;
    }

    public int getTileSizeY() {
        return this.mTileSizeY;
    }

    public void setTileSizeY(int tileSizeY) {
        this.mTileSizeY = tileSizeY;
    }

    public long getXmax() {
        return this.mXmax;
    }

    public void setXmax(long xmax) {
        this.mXmax = xmax;
    }

    public long getYmax() {
        return this.mYmax;
    }

    public void setYmax(long ymax) {
        this.mYmax = ymax;
    }

    public int getZoom() {
        return this.mZoom;
    }

    public void setZoom(int zoom) {
        this.mZoom = zoom;
    }

    public int getProjEpsg() {
        return this.mProjEpsg;
    }

    public void setProjEpsg(int projEpsg) {
        this.mProjEpsg = projEpsg;
    }

    public void addCalibrationPoint(double x, double y, double lat, double lon) {
        this.addCalibrationPoint(new CalibrationPoint(x, y, lat, lon));
    }

    public void addCalibrationPoint(CalibrationPoint cp) {
        this.mCalPoints.add(cp);
    }

    public List<CalibrationPoint> getCalibrationPoints() {
        return this.mCalPoints;
    }

    protected int getVersion() {
        return 0;
    }

    public void reset() {
        this.mName = "";
        this.mDescription = "";
        this.mTileSizeX = 0;
        this.mTileSizeY = 0;
        this.mXmax = 0L;
        this.mYmax = 0L;
        this.mZoom = -1;
        this.mProjEpsg = 0;
        this.mCalPoints = new ArrayList<CalibrationPoint>();
    }

    protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
        this.mName = dr.readString();
        this.mDescription = dr.readString();
        this.mTileSizeX = dr.readInt();
        this.mTileSizeY = dr.readInt();
        this.mXmax = dr.readLong();
        this.mYmax = dr.readLong();
        this.mZoom = dr.readInt();
        this.mProjEpsg = dr.readInt();
        int count = dr.readInt();
        for (int i = 0; i < count; ++i) {
            this.addCalibrationPoint(dr.readDouble(), dr.readDouble(), dr.readDouble(), dr.readDouble());
        }
    }

    protected void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeString(this.mName);
        dw.writeString(this.mDescription);
        dw.writeInt(this.mTileSizeX);
        dw.writeInt(this.mTileSizeY);
        dw.writeLong(this.mXmax);
        dw.writeLong(this.mYmax);
        dw.writeInt(this.mZoom);
        dw.writeInt(this.mProjEpsg);
        dw.writeInt(this.mCalPoints.size());
        for (int i = 0; i < this.mCalPoints.size(); ++i) {
            CalibrationPoint cal = this.mCalPoints.get(i);
            dw.writeDouble(cal.x);
            dw.writeDouble(cal.y);
            dw.writeDouble(cal.lat);
            dw.writeDouble(cal.lon);
        }
    }

    public static class CalibrationPoint {
        public double x = 0.0;
        public double y = 0.0;
        public double lat = 0.0;
        public double lon = 0.0;

        public CalibrationPoint() {
        }

        public CalibrationPoint(double x, double y, double lat, double lon) {
            this();
            this.x = x;
            this.y = y;
            this.lat = lat;
            this.lon = lon;
        }
    }
}

