/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.features.periodicUpdates;

import android.content.Context;
import android.content.Intent;
import locus.api.android.features.periodicUpdates.PeriodicUpdatesFiller;
import locus.api.android.features.periodicUpdates.UpdateContainer;
import locus.api.android.utils.LocusUtils;
import locus.api.objects.extra.Location;

public class PeriodicUpdatesHandler {
    private static final String TAG = "PeriodicUpdatesHandler";
    protected Location mLastMapCenter;
    protected Location mLastGps;
    protected int mLastZoomLevel = -1;
    protected double mLocMinDistance = 1.0;
    private static PeriodicUpdatesHandler mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PeriodicUpdatesHandler getInstance() {
        if (mInstance != null) return mInstance;
        String string = TAG;
        synchronized (TAG) {
            mInstance = new PeriodicUpdatesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private PeriodicUpdatesHandler() {
    }

    public void setLocNotificationLimit(double locMinDistance) {
        this.mLocMinDistance = locMinDistance;
    }

    public void onReceive(Context ctx, Intent intent, OnUpdate handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Incorrect arguments");
        }
        if (ctx == null || intent == null) {
            handler.onIncorrectData();
            return;
        }
        UpdateContainer update = PeriodicUpdatesFiller.intentToUpdate(intent, this);
        handler.onUpdate(LocusUtils.createLocusVersion(ctx, intent), update);
    }

    public static interface OnUpdate {
        public void onUpdate(LocusUtils.LocusVersion var1, UpdateContainer var2);

        public void onIncorrectData();
    }
}

