/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.utils;

import android.database.Cursor;
import android.database.MatrixCursor;
import java.io.IOException;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Utils;

public class LocusInfo
extends Storable {
    private String mPackageName;
    private boolean mIsRunning;
    private String mRootDir;
    private String mRootDirBackup;
    private String mRootDirExport;
    private String mRootDirGeocaching;
    private String mRootDirMapItems;
    private String mRootDirMapsOnline;
    private String mRootDirMapsPersonal;
    private String mRootDirMapsVector;
    private String mRootDirSrtm;
    private boolean mPeriodicUpdatesEnabled;
    private String mGcOwnerName;
    private int mUnitsFormatAltitude;
    private int mUnitsFormatAngle;
    private int mUnitsFormatArea;
    private int mUnitsFormatEnergy;
    private int mUnitsFormatLength;
    private int mUnitsFormatSlope;
    private int mUnitsFormatSpeed;
    private int mUnitsFormatTemperature;
    private int mUnitsFormatWeight;
    private static final String VALUE_PACKAGE_NAME = "packageName";
    private static final String VALUE_IS_RUNNING = "isRunning";
    private static final String VALUE_ROOT_DIR = "rootDir";
    private static final String VALUE_ROOT_DIR_BACKUP = "rootDirBackup";
    private static final String VALUE_ROOT_DIR_EXPORT = "rootDirExport";
    private static final String VALUE_ROOT_DIR_GEOCACHING = "rootDirGeocaching";
    private static final String VALUE_ROOT_DIR_MAP_ITEMS = "rootDirMapItems";
    private static final String VALUE_ROOT_DIR_MAPS_ONLINE = "rootDirMapsOnline";
    private static final String VALUE_ROOT_DIR_MAPS_PERSONAL = "rootDirMapsPersonal";
    private static final String VALUE_ROOT_DIR_MAPS_VECTOR = "rootDirMapsVector";
    private static final String VALUE_ROOT_DIR_SRTM = "rootDirSrtm";
    private static final String VALUE_PERIODIC_UPDATES = "periodicUpdates";
    private static final String VALUE_GEOCACHING_OWNER_NAME = "gcOwnerName";
    private static final String VALUE_UNITS_FORMAT_ALTITUDE = "unitsFormatAltitude";
    private static final String VALUE_UNITS_FORMAT_ANGLE = "unitsFormatAngle";
    private static final String VALUE_UNITS_FORMAT_AREA = "unitsFormatArea";
    private static final String VALUE_UNITS_FORMAT_ENERGY = "unitsFormatEnergy";
    private static final String VALUE_UNITS_FORMAT_LENGTH = "unitsFormatLength";
    private static final String VALUE_UNITS_FORMAT_SLOPE = "unitsFormatSlope";
    private static final String VALUE_UNITS_FORMAT_SPEED = "unitsFormatSpeed";
    private static final String VALUE_UNITS_FORMAT_TEMPERATURE = "unitsFormatTemperature";
    private static final String VALUE_UNITS_FORMAT_WEIGHT = "unitsFormatWeight";

    protected LocusInfo() {
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    protected void setPackageName(String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        this.mPackageName = packageName;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    protected void setRunning(boolean isRunning) {
        this.mIsRunning = isRunning;
    }

    public String getRootDirectory() {
        return this.mRootDir;
    }

    protected void setRootDirectory(String rootDirectory) {
        if (rootDirectory == null) {
            rootDirectory = "";
        }
        this.mRootDir = rootDirectory;
    }

    public String getRootDirBackup() {
        return this.mRootDirBackup;
    }

    protected void setRootDirBackup(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirBackup = dir;
    }

    public String getRootDirExport() {
        return this.mRootDirExport;
    }

    protected void setRootDirExport(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirExport = dir;
    }

    public String getRootDirGeocaching() {
        return this.mRootDirGeocaching;
    }

    protected void setRootDirGeocaching(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirGeocaching = dir;
    }

    public String getRootDirMapItems() {
        return this.mRootDirMapItems;
    }

    protected void setRootDirMapItems(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirMapItems = dir;
    }

    public String getRootDirMapsOnline() {
        return this.mRootDirMapsOnline;
    }

    protected void setRootDirMapsOnline(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirMapsOnline = dir;
    }

    public String getRootDirMapsPersonal() {
        return this.mRootDirMapsPersonal;
    }

    protected void setRootDirMapsPersonal(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirMapsPersonal = dir;
    }

    public String getRootDirMapsVector() {
        return this.mRootDirMapsVector;
    }

    protected void setRootDirMapsVector(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirMapsVector = dir;
    }

    public String getRootDirSrtm() {
        return this.mRootDirSrtm;
    }

    protected void setRootDirSrtm(String dir) {
        if (dir == null) {
            dir = "";
        }
        this.mRootDirSrtm = dir;
    }

    public boolean isPeriodicUpdatesEnabled() {
        return this.mPeriodicUpdatesEnabled;
    }

    protected void setPeriodicUpdatesEnabled(boolean enabled) {
        this.mPeriodicUpdatesEnabled = enabled;
    }

    public String getGcOwnerName() {
        return this.mGcOwnerName;
    }

    protected void setGcOwnerName(String gcOwnerName) {
        if (gcOwnerName == null) {
            gcOwnerName = "";
        }
        this.mGcOwnerName = gcOwnerName;
    }

    public int getUnitsFormatAltitude() {
        return this.mUnitsFormatAltitude;
    }

    protected void setUnitsFormatAltitude(int format) {
        this.mUnitsFormatAltitude = format;
    }

    public int getUnitsFormatAngle() {
        return this.mUnitsFormatAngle;
    }

    protected void setUnitsFormatAngle(int format) {
        this.mUnitsFormatAngle = format;
    }

    public int getUnitsFormatArea() {
        return this.mUnitsFormatArea;
    }

    protected void setUnitsFormatArea(int format) {
        this.mUnitsFormatArea = format;
    }

    public int getUnitsFormatEnergy() {
        return this.mUnitsFormatEnergy;
    }

    protected void setUnitsFormatEnergy(int format) {
        this.mUnitsFormatEnergy = format;
    }

    public int getUnitsFormatLength() {
        return this.mUnitsFormatLength;
    }

    protected void setUnitsFormatLength(int format) {
        this.mUnitsFormatLength = format;
    }

    public int getUnitsFormatSlope() {
        return this.mUnitsFormatSlope;
    }

    protected void setUnitsFormatSlope(int format) {
        this.mUnitsFormatSlope = format;
    }

    public int getUnitsFormatSpeed() {
        return this.mUnitsFormatSpeed;
    }

    protected void setUnitsFormatSpeed(int format) {
        this.mUnitsFormatSpeed = format;
    }

    public int getUnitsFormatTemperature() {
        return this.mUnitsFormatTemperature;
    }

    protected void setUnitsFormatTemperature(int format) {
        this.mUnitsFormatTemperature = format;
    }

    public int getUnitsFormatWeight() {
        return this.mUnitsFormatWeight;
    }

    protected void setUnitsFormatWeight(int format) {
        this.mUnitsFormatWeight = format;
    }

    public String toString() {
        return Utils.toString((Object)((Object)this));
    }

    public static LocusInfo create(Cursor cursor) {
        if (cursor == null || cursor.getCount() == 0) {
            return null;
        }
        LocusInfo info = new LocusInfo();
        block48: for (int i = 0; i < cursor.getCount(); ++i) {
            String key;
            cursor.moveToPosition(i);
            switch (key = cursor.getString(0)) {
                case "packageName": {
                    info.mPackageName = cursor.getString(1);
                    continue block48;
                }
                case "isRunning": {
                    info.mIsRunning = cursor.getInt(1) == 1;
                    continue block48;
                }
                case "rootDir": {
                    info.mRootDir = cursor.getString(1);
                    continue block48;
                }
                case "rootDirBackup": {
                    info.mRootDirBackup = cursor.getString(1);
                    continue block48;
                }
                case "rootDirExport": {
                    info.mRootDirExport = cursor.getString(1);
                    continue block48;
                }
                case "rootDirGeocaching": {
                    info.mRootDirGeocaching = cursor.getString(1);
                    continue block48;
                }
                case "rootDirMapItems": {
                    info.mRootDirMapItems = cursor.getString(1);
                    continue block48;
                }
                case "rootDirMapsOnline": {
                    info.mRootDirMapsOnline = cursor.getString(1);
                    continue block48;
                }
                case "rootDirMapsPersonal": {
                    info.mRootDirMapsPersonal = cursor.getString(1);
                    continue block48;
                }
                case "rootDirMapsVector": {
                    info.mRootDirMapsVector = cursor.getString(1);
                    continue block48;
                }
                case "rootDirSrtm": {
                    info.mRootDirSrtm = cursor.getString(1);
                    continue block48;
                }
                case "periodicUpdates": {
                    info.mPeriodicUpdatesEnabled = cursor.getInt(1) == 1;
                    continue block48;
                }
                case "gcOwnerName": {
                    info.mGcOwnerName = cursor.getString(1);
                    continue block48;
                }
                case "unitsFormatAltitude": {
                    info.mUnitsFormatAltitude = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatAngle": {
                    info.mUnitsFormatAngle = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatArea": {
                    info.mUnitsFormatArea = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatEnergy": {
                    info.mUnitsFormatEnergy = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatLength": {
                    info.mUnitsFormatLength = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatSlope": {
                    info.mUnitsFormatSlope = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatSpeed": {
                    info.mUnitsFormatSpeed = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatTemperature": {
                    info.mUnitsFormatTemperature = cursor.getInt(1);
                    continue block48;
                }
                case "unitsFormatWeight": {
                    info.mUnitsFormatWeight = cursor.getInt(1);
                }
            }
        }
        return info;
    }

    protected Cursor create() {
        MatrixCursor c = new MatrixCursor(new String[]{"key", "value"});
        c.addRow(new Object[]{VALUE_PACKAGE_NAME, this.mPackageName});
        c.addRow(new Object[]{VALUE_IS_RUNNING, this.mIsRunning ? "1" : "0"});
        c.addRow(new Object[]{VALUE_ROOT_DIR, this.mRootDir});
        c.addRow(new Object[]{VALUE_ROOT_DIR_BACKUP, this.mRootDirBackup});
        c.addRow(new Object[]{VALUE_ROOT_DIR_EXPORT, this.mRootDirExport});
        c.addRow(new Object[]{VALUE_ROOT_DIR_GEOCACHING, this.mRootDirGeocaching});
        c.addRow(new Object[]{VALUE_ROOT_DIR_MAP_ITEMS, this.mRootDirMapItems});
        c.addRow(new Object[]{VALUE_ROOT_DIR_MAPS_ONLINE, this.mRootDirMapsOnline});
        c.addRow(new Object[]{VALUE_ROOT_DIR_MAPS_PERSONAL, this.mRootDirMapsPersonal});
        c.addRow(new Object[]{VALUE_ROOT_DIR_MAPS_VECTOR, this.mRootDirMapsVector});
        c.addRow(new Object[]{VALUE_ROOT_DIR_SRTM, this.mRootDirSrtm});
        c.addRow(new Object[]{VALUE_PERIODIC_UPDATES, this.mPeriodicUpdatesEnabled ? "1" : "0"});
        c.addRow(new Object[]{VALUE_GEOCACHING_OWNER_NAME, this.mGcOwnerName});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_ALTITUDE, this.mUnitsFormatAltitude});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_ANGLE, this.mUnitsFormatAngle});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_AREA, this.mUnitsFormatArea});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_ENERGY, this.mUnitsFormatEnergy});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_LENGTH, this.mUnitsFormatLength});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_SLOPE, this.mUnitsFormatSlope});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_SPEED, this.mUnitsFormatSpeed});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_TEMPERATURE, this.mUnitsFormatTemperature});
        c.addRow(new Object[]{VALUE_UNITS_FORMAT_WEIGHT, this.mUnitsFormatWeight});
        return c;
    }

    protected int getVersion() {
        return 1;
    }

    public void reset() {
        this.mPackageName = "";
        this.mIsRunning = false;
        this.mRootDir = "";
        this.mRootDirBackup = "";
        this.mRootDirExport = "";
        this.mRootDirGeocaching = "";
        this.mRootDirMapItems = "";
        this.mRootDirMapsOnline = "";
        this.mRootDirMapsPersonal = "";
        this.mRootDirMapsVector = "";
        this.mRootDirSrtm = "";
        this.mPeriodicUpdatesEnabled = false;
        this.mGcOwnerName = "";
        this.mUnitsFormatAltitude = -1;
        this.mUnitsFormatAngle = -1;
        this.mUnitsFormatArea = -1;
        this.mUnitsFormatLength = -1;
        this.mUnitsFormatSpeed = -1;
        this.mUnitsFormatTemperature = -1;
        this.mUnitsFormatEnergy = -1;
        this.mUnitsFormatSlope = -1;
        this.mUnitsFormatWeight = -1;
    }

    protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
        this.mPackageName = dr.readString();
        this.mIsRunning = dr.readBoolean();
        this.mRootDir = dr.readString();
        this.mRootDirBackup = dr.readString();
        this.mRootDirExport = dr.readString();
        this.mRootDirGeocaching = dr.readString();
        this.mRootDirMapItems = dr.readString();
        this.mRootDirMapsOnline = dr.readString();
        this.mRootDirMapsPersonal = dr.readString();
        this.mRootDirMapsVector = dr.readString();
        this.mRootDirSrtm = dr.readString();
        this.mPeriodicUpdatesEnabled = dr.readBoolean();
        this.mGcOwnerName = dr.readString();
        this.mUnitsFormatAltitude = dr.readInt();
        this.mUnitsFormatAngle = dr.readInt();
        this.mUnitsFormatArea = dr.readInt();
        this.mUnitsFormatLength = dr.readInt();
        this.mUnitsFormatSpeed = dr.readInt();
        this.mUnitsFormatTemperature = dr.readInt();
        if (version >= 1) {
            this.mUnitsFormatEnergy = dr.readInt();
            this.mUnitsFormatSlope = dr.readInt();
            this.mUnitsFormatWeight = dr.readInt();
        }
    }

    protected void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeString(this.mPackageName);
        dw.writeBoolean(this.mIsRunning);
        dw.writeString(this.mRootDir);
        dw.writeString(this.mRootDirBackup);
        dw.writeString(this.mRootDirExport);
        dw.writeString(this.mRootDirGeocaching);
        dw.writeString(this.mRootDirMapItems);
        dw.writeString(this.mRootDirMapsOnline);
        dw.writeString(this.mRootDirMapsPersonal);
        dw.writeString(this.mRootDirMapsVector);
        dw.writeString(this.mRootDirSrtm);
        dw.writeBoolean(this.mPeriodicUpdatesEnabled);
        dw.writeString(this.mGcOwnerName);
        dw.writeInt(this.mUnitsFormatAltitude);
        dw.writeInt(this.mUnitsFormatAngle);
        dw.writeInt(this.mUnitsFormatArea);
        dw.writeInt(this.mUnitsFormatLength);
        dw.writeInt(this.mUnitsFormatSpeed);
        dw.writeInt(this.mUnitsFormatTemperature);
        dw.writeInt(this.mUnitsFormatEnergy);
        dw.writeInt(this.mUnitsFormatSlope);
        dw.writeInt(this.mUnitsFormatWeight);
    }
}

