/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.net.Uri;
import android.text.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import locus.api.android.ActionTools;
import locus.api.android.utils.LocusInfo;
import locus.api.android.utils.exceptions.RequiredVersionMissingException;
import locus.api.objects.Storable;
import locus.api.objects.extra.Track;
import locus.api.objects.extra.Waypoint;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import locus.api.utils.Utils;

public class LocusUtils {
    private static final String TAG = "LocusUtils";

    public static LocusVersion getActiveVersion(Context ctx) {
        return LocusUtils.getActiveVersion(ctx, 0);
    }

    public static LocusVersion getActiveVersion(Context ctx, int minVersionCode) {
        List<LocusVersion> versions = LocusUtils.getAvailableVersions(ctx);
        if (versions.size() == 0) {
            return null;
        }
        LocusVersion backupVersion = null;
        int m = versions.size();
        for (int i = 0; i < m; ++i) {
            try {
                LocusInfo li;
                LocusVersion lv = versions.get(i);
                if (lv.getVersionCode() < minVersionCode || (li = ActionTools.getLocusInfo(ctx, lv)) == null) continue;
                backupVersion = lv;
                if (!li.isRunning()) continue;
                return lv;
            }
            catch (RequiredVersionMissingException e) {
                Logger.logE((String)TAG, (String)"prepareActiveLocus()", (Exception)e);
            }
        }
        if (backupVersion != null) {
            return backupVersion;
        }
        return versions.get(0);
    }

    public static List<LocusVersion> getAvailableVersions(Context ctx) {
        ArrayList<LocusVersion> versions = new ArrayList<LocusVersion>();
        PackageManager pm = ctx.getPackageManager();
        List appInfos = pm.getInstalledApplications(0);
        int m = appInfos.size();
        for (int i = 0; i < m; ++i) {
            LocusVersion lv;
            ApplicationInfo appInfo = (ApplicationInfo)appInfos.get(i);
            if (!LocusUtils.isPackageNameLocus(appInfo.packageName) || (lv = LocusUtils.createLocusVersion(ctx, appInfo.packageName)) == null) continue;
            versions.add(lv);
        }
        return versions;
    }

    private static boolean isPackageNameLocus(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return false;
        }
        if (!packageName.startsWith("menion")) {
            return false;
        }
        return packageName.equals("menion.android.locus") || packageName.startsWith("menion.android.locus.free") || packageName.startsWith("menion.android.locus.pro");
    }

    public static LocusVersion createLocusVersion(Context ctx, String packageName) {
        try {
            if (packageName == null || packageName.length() == 0 || !packageName.startsWith("menion.android.locus")) {
                return null;
            }
            PackageManager pm = ctx.getPackageManager();
            PackageInfo info = pm.getPackageInfo(packageName, 0);
            if (info == null) {
                return null;
            }
            return new LocusVersion(packageName, info.versionName, info.versionCode);
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getLocusVersion(" + ctx + ", " + packageName + ")"), (Exception)e);
            return null;
        }
    }

    public static LocusVersion createLocusVersion(Context ctx, Intent intent) {
        if (ctx == null || intent == null) {
            return null;
        }
        String packageName = intent.getStringExtra("INTENT_EXTRA_PACKAGE_NAME");
        if (packageName != null && packageName.length() > 0) {
            return LocusUtils.createLocusVersion(ctx, packageName);
        }
        return LocusUtils.createLocusVersion(ctx);
    }

    @Deprecated
    public static LocusVersion createLocusVersion(Context ctx) {
        if (ctx == null) {
            return null;
        }
        Logger.logW((String)TAG, (String)("getLocusVersion(" + ctx + "), " + "Warning: old version of Locus: Correct package name is not known!"));
        List<LocusVersion> versions = LocusUtils.getAvailableVersions(ctx);
        int m = versions.size();
        for (int i = 0; i < m; ++i) {
            LocusVersion lv = versions.get(i);
            if (!lv.isVersionFree() && !lv.isVersionPro()) continue;
            return lv;
        }
        return null;
    }

    public static boolean isLocusAvailable(Context ctx) {
        return LocusUtils.isLocusAvailable(ctx, VersionCode.UPDATE_01);
    }

    public static boolean isLocusAvailable(Context ctx, VersionCode vc) {
        return LocusUtils.isLocusAvailable(ctx, vc.vcFree, vc.vcPro, vc.vcGis);
    }

    public static boolean isLocusAvailable(Context ctx, int versionFree, int versionPro, int versionGis) {
        List<LocusVersion> versions = LocusUtils.getAvailableVersions(ctx);
        int m = versions.size();
        for (int i = 0; i < m; ++i) {
            LocusVersion lv = versions.get(i);
            if (lv.isVersionFree() && versionFree > 0 && lv.getVersionCode() >= versionFree) {
                return true;
            }
            if (lv.isVersionPro() && versionPro > 0 && lv.getVersionCode() >= versionPro) {
                return true;
            }
            if (!lv.isVersionGis() || versionGis <= 0 || lv.getVersionCode() < versionGis) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocusFreePro(LocusVersion lv, int minVersion) {
        if (lv == null) {
            return false;
        }
        if (lv.isVersionFree() && lv.getVersionCode() >= minVersion) {
            return true;
        }
        if (lv.isVersionPro() && lv.getVersionCode() >= minVersion) {
            return true;
        }
        return true;
    }

    public static void callInstallLocus(Context ctx) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://market.android.com/details?id=menion.android.locus"));
        intent.addFlags(0x10000000);
        ctx.startActivity(intent);
    }

    public static void callStartLocusMap(Context ctx) {
        Intent intent = new Intent("com.asamm.locus.map.START_APP");
        intent.addFlags(0x10000000);
        ctx.startActivity(intent);
    }

    public static boolean isIntentGetLocation(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_GET_LOCATION");
    }

    public static void handleIntentGetLocation(Context context, Intent intent, OnIntentGetLocation handler) throws NullPointerException {
        if (intent == null) {
            throw new NullPointerException("Intent cannot be null");
        }
        if (!LocusUtils.isIntentGetLocation(intent)) {
            handler.onFailed();
            return;
        }
        handler.onReceived(LocusUtils.getLocationFromIntent(intent, "INTENT_EXTRA_LOCATION_GPS"), LocusUtils.getLocationFromIntent(intent, "INTENT_EXTRA_LOCATION_MAP_CENTER"));
    }

    public static boolean sendGetLocationData(Activity activity, String name, locus.api.objects.extra.Location loc) {
        if (loc == null) {
            return false;
        }
        Intent intent = new Intent();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            intent.putExtra("INTENT_EXTRA_NAME", name);
        }
        intent.putExtra("INTENT_EXTRA_LOCATION", loc.getAsBytes());
        activity.setResult(-1, intent);
        activity.finish();
        return true;
    }

    public static boolean isIntentPointTools(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_POINT_TOOLS");
    }

    public static Waypoint handleIntentPointTools(Context ctx, Intent intent) throws RequiredVersionMissingException {
        long wptId = intent.getLongExtra("INTENT_EXTRA_ITEM_ID", -1L);
        if (wptId < 0L) {
            return null;
        }
        return ActionTools.getLocusWaypoint(ctx, LocusUtils.createLocusVersion(ctx, intent), wptId);
    }

    public static boolean isIntentTrackTools(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_TRACK_TOOLS");
    }

    public static Track handleIntentTrackTools(Context ctx, Intent intent) throws RequiredVersionMissingException {
        long trackId = intent.getLongExtra("INTENT_EXTRA_ITEM_ID", -1L);
        if (trackId < 0L) {
            return null;
        }
        return ActionTools.getLocusTrack(ctx, LocusUtils.createLocusVersion(ctx, intent), trackId);
    }

    public static boolean isIntentMainFunction(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_MAIN_FUNCTION");
    }

    public static void handleIntentMainFunction(Context ctx, Intent intent, OnIntentMainFunction handler) throws NullPointerException {
        LocusUtils.handleIntentMenuItem(ctx, intent, handler, "locus.api.android.INTENT_ITEM_MAIN_FUNCTION");
    }

    public static boolean isIntentMainFunctionGc(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_MAIN_FUNCTION_GC");
    }

    public static void handleIntentMainFunctionGc(Context ctx, Intent intent, OnIntentMainFunction handler) throws NullPointerException {
        LocusUtils.handleIntentMenuItem(ctx, intent, handler, "locus.api.android.INTENT_ITEM_MAIN_FUNCTION_GC");
    }

    public static boolean isIntentSearchList(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_SEARCH_LIST");
    }

    public static void handleIntentSearchList(Context ctx, Intent intent, OnIntentMainFunction handler) throws NullPointerException {
        LocusUtils.handleIntentMenuItem(ctx, intent, handler, "locus.api.android.INTENT_ITEM_SEARCH_LIST");
    }

    private static void handleIntentMenuItem(Context ctx, Intent intent, OnIntentMainFunction handler, String item) throws NullPointerException {
        if (intent == null) {
            throw new NullPointerException("Intent cannot be null");
        }
        if (handler == null) {
            throw new NullPointerException("Handler cannot be null");
        }
        if (!LocusUtils.isRequiredAction(intent, item)) {
            handler.onFailed();
            return;
        }
        handler.onReceived(LocusUtils.createLocusVersion(ctx, intent), LocusUtils.getLocationFromIntent(intent, "INTENT_EXTRA_LOCATION_GPS"), LocusUtils.getLocationFromIntent(intent, "INTENT_EXTRA_LOCATION_MAP_CENTER"));
    }

    public static boolean isIntentPointsScreenTools(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.INTENT_ITEM_POINTS_SCREEN_TOOLS");
    }

    public static long[] handleIntentPointsScreenTools(Intent intent) {
        long[] waypointIds = null;
        if (intent.hasExtra("INTENT_EXTRA_ITEMS_ID")) {
            waypointIds = intent.getLongArrayExtra("INTENT_EXTRA_ITEMS_ID");
        }
        return waypointIds;
    }

    public static boolean isIntentReceiveLocation(Intent intent) {
        return LocusUtils.isRequiredAction(intent, "locus.api.android.ACTION_RECEIVE_LOCATION");
    }

    private static boolean isRequiredAction(Intent intent, String action) {
        return intent != null && intent.getAction() != null && intent.getAction().equals(action);
    }

    public static Intent prepareResultExtraOnDisplayIntent(Waypoint wpt, boolean overridePoint) {
        Intent intent = new Intent();
        LocusUtils.addWaypointToIntent(intent, wpt);
        intent.putExtra("INTENT_EXTRA_POINT_OVERWRITE", overridePoint);
        return intent;
    }

    public static void addWaypointToIntent(Intent intent, Waypoint wpt) {
        intent.putExtra("INTENT_EXTRA_POINT", wpt.getAsBytes());
    }

    public static Waypoint getWaypointFromIntent(Intent intent) {
        try {
            return new Waypoint(intent.getByteArrayExtra("INTENT_EXTRA_POINT"));
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getWaypointFromIntent(" + intent + ")"), (Exception)e);
            return null;
        }
    }

    public static locus.api.objects.extra.Location getLocationFromIntent(Intent intent, String extraName) {
        try {
            if (!intent.hasExtra(extraName)) {
                return null;
            }
            return new locus.api.objects.extra.Location(intent.getByteArrayExtra(extraName));
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getLocationFromIntent(" + intent + ")"), (Exception)e);
            return null;
        }
    }

    public static locus.api.objects.extra.Location convertToL(Location oldLoc) {
        locus.api.objects.extra.Location loc = new locus.api.objects.extra.Location(oldLoc.getProvider());
        loc.setLongitude(oldLoc.getLongitude());
        loc.setLatitude(oldLoc.getLatitude());
        loc.setTime(oldLoc.getTime());
        if (oldLoc.hasAccuracy()) {
            loc.setAccuracy(oldLoc.getAccuracy());
        }
        if (oldLoc.hasAltitude()) {
            loc.setAltitude(oldLoc.getAltitude());
        }
        if (oldLoc.hasBearing()) {
            loc.setBearing(oldLoc.getBearing());
        }
        if (oldLoc.hasSpeed()) {
            loc.setSpeed(oldLoc.getSpeed());
        }
        return loc;
    }

    public static Location convertToA(locus.api.objects.extra.Location oldLoc) {
        Location loc = new Location(oldLoc.getProvider());
        loc.setLongitude(oldLoc.getLongitude());
        loc.setLatitude(oldLoc.getLatitude());
        loc.setTime(oldLoc.getTime());
        if (oldLoc.hasAccuracy()) {
            loc.setAccuracy(oldLoc.getAccuracy());
        }
        if (oldLoc.hasAltitude()) {
            loc.setAltitude(oldLoc.getAltitude());
        }
        if (oldLoc.hasBearing()) {
            loc.setBearing(oldLoc.getBearing());
        }
        if (oldLoc.hasSpeed()) {
            loc.setSpeed(oldLoc.getSpeed());
        }
        return loc;
    }

    public static boolean isAppAvailable(Context ctx, String packageName, int version) {
        try {
            PackageInfo info = ctx.getPackageManager().getPackageInfo(packageName, 0);
            return info != null && info.versionCode >= version;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static interface OnIntentMainFunction {
        public void onReceived(LocusVersion var1, locus.api.objects.extra.Location var2, locus.api.objects.extra.Location var3);

        public void onFailed();
    }

    public static interface OnIntentGetLocation {
        public void onReceived(locus.api.objects.extra.Location var1, locus.api.objects.extra.Location var2);

        public void onFailed();
    }

    public static class LocusVersion
    extends Storable {
        private String mPackageName;
        private String mVersionName;
        private int mVersionCode;

        public LocusVersion() {
        }

        private LocusVersion(String packageName, String versionName, int versionCode) {
            if (packageName == null) {
                packageName = "";
            }
            this.mPackageName = packageName;
            if (versionName == null) {
                versionName = "";
            }
            this.mVersionName = versionName;
            if (versionCode < 0) {
                versionCode = 0;
            }
            this.mVersionCode = versionCode;
        }

        public boolean isVersionFree() {
            return !this.isVersionPro() && !this.isVersionGis();
        }

        public boolean isVersionPro() {
            return this.mPackageName.contains(".pro");
        }

        public boolean isVersionGis() {
            return this.mPackageName.contains(".gis");
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public String getVersionName() {
            return this.mVersionName;
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public boolean isVersionValid(VersionCode code) {
            if (this.isVersionFree()) {
                return code.vcFree != 0 && this.mVersionCode >= code.vcFree;
            }
            if (this.isVersionPro()) {
                return code.vcPro != 0 && this.mVersionCode >= code.vcPro;
            }
            if (this.isVersionGis()) {
                return code.vcGis != 0 && this.mVersionCode >= code.vcGis;
            }
            return false;
        }

        public String toString() {
            return Utils.toString((Object)((Object)this));
        }

        protected int getVersion() {
            return 0;
        }

        public void reset() {
            this.mPackageName = "";
            this.mVersionName = "";
            this.mVersionCode = 0;
        }

        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            this.mPackageName = dr.readString();
            this.mVersionName = dr.readString();
            this.mVersionCode = dr.readInt();
        }

        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            dw.writeString(this.mPackageName);
            dw.writeString(this.mVersionName);
            dw.writeInt(this.mVersionCode);
        }
    }

    public static enum VersionCode {
        UPDATE_01(235, 235, 0),
        UPDATE_02(242, 242, 0),
        UPDATE_03(269, 269, 0),
        UPDATE_04(278, 278, 0),
        UPDATE_05(296, 296, 0),
        UPDATE_06(311, 311, 5),
        UPDATE_07(317, 317, 0),
        UPDATE_08(343, 343, 0),
        UPDATE_09(357, 357, 0),
        UPDATE_10(370, 370, 0),
        UPDATE_11(380, 380, 0),
        UPDATE_12(421, 421, 0);

        public final int vcFree;
        public final int vcPro;
        public final int vcGis;

        private VersionCode(int vcFree, int vcPro, int vcGis) {
            this.vcFree = vcFree;
            this.vcPro = vcPro;
            this.vcGis = vcGis;
        }
    }
}

