/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import locus.api.utils.Utils;

public class UtilsBitmap {
    private static final String TAG = "UtilsBitmap";

    public static Bitmap readBitmap(DataReaderBigEndian dr) {
        int size = 0;
        size = dr.readInt();
        if (size > 0) {
            byte[] data = dr.readBytes(size);
            return UtilsBitmap.getBitmap(data);
        }
        return null;
    }

    public static void writeBitmap(DataWriterBigEndian dw, Bitmap bitmap, Bitmap.CompressFormat format) throws IOException {
        if (bitmap == null) {
            dw.writeInt(0);
        } else {
            byte[] data = UtilsBitmap.getBitmap(bitmap, format);
            if (data == null || data.length == 0) {
                Logger.logW((String)TAG, (String)"writeBitmap(), unknown problem");
                dw.writeInt(0);
            } else {
                dw.writeInt(data.length);
                dw.write(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBitmap(Bitmap bitmap, Bitmap.CompressFormat format) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            if (bitmap.compress(format, 80, (OutputStream)baos)) {
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            Logger.logW((String)TAG, (String)"Problem with converting image to byte[]");
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getBitmap(" + bitmap + ")"), (Exception)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Utils.closeStream((Closeable)baos);
        }
    }

    public static Bitmap getBitmap(byte[] data) {
        try {
            return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getBitmap(" + data + ")"), (Exception)e);
            return null;
        }
    }
}

