/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.utils;

import android.text.Html;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class UtilsFormat {
    public static final int VALUE_UNITS_ALTITUDE_METRES = 0;
    public static final int VALUE_UNITS_ALTITUDE_FEET = 1;
    public static final int VALUE_UNITS_ANGLE_DEGREE = 0;
    public static final int VALUE_UNITS_ANGLE_ANGULAR_MIL = 1;
    public static final int VALUE_UNITS_ANGLE_RUSSIAN_MIL = 2;
    public static final int VALUE_UNITS_ANGLE_US_ARTILLERY_MIL = 3;
    public static final int VALUE_UNITS_AREA_M_SQ = 0;
    public static final int VALUE_UNITS_AREA_HA = 1;
    public static final int VALUE_UNITS_AREA_KM_SQ = 2;
    public static final int VALUE_UNITS_AREA_FT_SQ = 3;
    public static final int VALUE_UNITS_AREA_YA_SQ = 4;
    public static final int VALUE_UNITS_AREA_ACRE = 5;
    public static final int VALUE_UNITS_AREA_MI_SQ = 6;
    public static final int VALUE_UNITS_AREA_NM_SQ = 7;
    public static final int VALUE_UNITS_DISTANCE_ME_M = 0;
    public static final int VALUE_UNITS_DISTANCE_ME_MKM = 1;
    public static final int VALUE_UNITS_DISTANCE_IM_F = 2;
    public static final int VALUE_UNITS_DISTANCE_IM_FM = 3;
    public static final int VALUE_UNITS_DISTANCE_IM_Y = 4;
    public static final int VALUE_UNITS_DISTANCE_IM_YM = 5;
    public static final int VALUE_UNITS_DISTANCE_NA_MNMI = 6;
    public static final int VALUE_UNITS_ENERGY_KJ = 0;
    public static final int VALUE_UNITS_ENERGY_KCAL = 1;
    public static final int VALUE_UNITS_SLOPE_PERCENT = 0;
    public static final int VALUE_UNITS_SLOPE_DEGREE = 1;
    public static final int VALUE_UNITS_SPEED_KMH = 0;
    public static final int VALUE_UNITS_SPEED_MILH = 1;
    public static final int VALUE_UNITS_SPEED_NMIH = 2;
    public static final int VALUE_UNITS_SPEED_KNOT = 3;
    public static final int VALUE_UNITS_TEMPERATURE_CELSIUS = 0;
    public static final int VALUE_UNITS_TEMPERATURE_FAHRENHEIT = 1;
    public static final int VALUE_UNITS_WEIGHT_KG = 0;
    public static final int VALUE_UNITS_WEIGHT_LB = 1;
    public static double angleInAngularMi = 17.453292519943293;
    public static double angleInRussianMil = 16.666666666666668;
    public static double angleInUsArttileryMil = 17.77777777777778;
    public static final double UNIT_KILOMETER_TO_METER = 1000.0;
    public static final double UNIT_MILE_TO_METER = 1609.344;
    public static final double UNIT_NMILE_TO_METER = 1852.0;
    public static final double UNIT_METER_TO_FEET = 3.2808;
    public static final float ENERGY_CAL_TO_J = 4.185f;
    public static final float WEIGHT_KG_TO_LB = 2.204622f;
    private static DecimalFormat[][] formats;

    public static String formatAltitude(int format, double altitude, boolean addUnits) {
        double value = UtilsFormat.formatAltitudeValue(format, altitude);
        String res = UtilsFormat.formatDouble(value, 0);
        if (addUnits) {
            return res + " " + UtilsFormat.formatAltitudeUnits(format);
        }
        return res;
    }

    public static double formatAltitudeValue(int format, double altitude) {
        if (format == 1) {
            return altitude * 3.2808;
        }
        return altitude;
    }

    public static String formatAltitudeUnits(int format) {
        if (format == 1) {
            return "ft";
        }
        return "m";
    }

    public static String formatAngle(int format, float angle, boolean optimize, int minAccuracy) {
        double resValue = UtilsFormat.formatAngleValue(format, angle, optimize, minAccuracy);
        String units = UtilsFormat.formatAngleUnits(format);
        return UtilsFormat.formatDouble(resValue, minAccuracy) + units;
    }

    public static double formatAngleValue(int format, double angle, boolean optimize, int minAccuracy) {
        if (optimize) {
            angle = UtilsFormat.optimizeAngleValue(angle, minAccuracy);
        }
        if (format == 1) {
            return angle * angleInAngularMi;
        }
        if (format == 2) {
            return angle * angleInRussianMil;
        }
        if (format == 3) {
            return angle * angleInUsArttileryMil;
        }
        return angle;
    }

    public static String formatAngleUnits(int format) {
        if (format == 0) {
            return "\u00b0";
        }
        return "";
    }

    private static double optimizeAngleValue(double angle, int minAccuracy) {
        int divider = (int)Math.pow(10.0, minAccuracy);
        angle = Math.round(angle * (double)divider);
        if (minAccuracy == 0) {
            if (angle < -0.5) {
                angle += 360.0;
            }
            if (angle >= 359.5) {
                angle -= 360.0;
            }
        } else {
            if (angle < 0.0) {
                angle += 360.0 * (double)divider;
            }
            if (angle >= 360.0 * (double)divider) {
                angle -= (double)(360.0f * (float)divider);
            }
        }
        return angle / (double)divider;
    }

    public static CharSequence formatArea(int format, double area, boolean addUnits) {
        StringBuilder sb = new StringBuilder();
        if (!addUnits) {
            sb.append(UtilsFormat.formatAreaValue(format, area));
        } else {
            sb.append(UtilsFormat.formatAreaValue(format, area)).append(" ").append(UtilsFormat.formatAreaUnit(format, area));
        }
        return Html.fromHtml((String)sb.toString());
    }

    public static String formatAreaValue(int format, double area) {
        switch (format) {
            case 0: {
                return UtilsFormat.formatDouble(area, 0);
            }
            case 1: {
                area /= 10000.0;
                break;
            }
            case 2: {
                area /= 1000000.0;
                break;
            }
            case 3: {
                return UtilsFormat.formatDouble(area / 0.09290304, 0);
            }
            case 4: {
                return UtilsFormat.formatDouble(area / 0.83612736, 0);
            }
            case 5: {
                area /= 4046.8564224;
                break;
            }
            case 6: {
                area /= 2589988.110336;
                break;
            }
            case 7: {
                area /= 3429904.0;
                break;
            }
            default: {
                return "";
            }
        }
        if (area < 100.0) {
            return UtilsFormat.formatDouble(area, 2);
        }
        if (area < 1000.0) {
            return UtilsFormat.formatDouble(area, 1);
        }
        return UtilsFormat.formatDouble(area, 0);
    }

    public static CharSequence formatAreaUnit(int unitType, double area) {
        String text = "";
        switch (unitType) {
            case 0: {
                text = "m&sup2;";
                break;
            }
            case 1: {
                text = "ha";
                break;
            }
            case 2: {
                text = "km&sup2;";
                break;
            }
            case 3: {
                text = "ft&sup2;";
                break;
            }
            case 4: {
                text = "yd&sup2;";
                break;
            }
            case 5: {
                text = "acre";
                break;
            }
            case 6: {
                text = "mi&sup2;";
                break;
            }
            case 7: {
                text = "nm&sup2;";
            }
        }
        return Html.fromHtml((String)text);
    }

    public static String formatDistance(int unitType, double dist, boolean withoutUnits) {
        return UtilsFormat.formatDistance(unitType, dist, UnitsPrecision.MEDIUM, !withoutUnits);
    }

    public static String formatDistance(int unitType, double dist, UnitsPrecision precision, boolean addUnits) {
        String value = null;
        block0 : switch (unitType) {
            case 0: {
                switch (precision) {
                    case LOW: 
                    case MEDIUM: {
                        value = UtilsFormat.formatDouble(dist, 0);
                        break;
                    }
                    case HIGH: {
                        value = UtilsFormat.formatDouble(dist, 1);
                    }
                }
                break;
            }
            case 1: {
                switch (precision) {
                    case LOW: 
                    case MEDIUM: {
                        if (dist >= 1000.0) {
                            double km = dist / 1000.0;
                            if (km >= 100.0) {
                                value = UtilsFormat.formatDouble(km, 0);
                                break;
                            }
                            value = UtilsFormat.formatDouble(km, 1);
                            break;
                        }
                        value = UtilsFormat.formatDistance(dist, 0);
                        break;
                    }
                    case HIGH: {
                        if (dist >= 1000.0) {
                            double km = dist / 1000.0;
                            if (km >= 100.0) {
                                value = UtilsFormat.formatDouble(km, 1);
                                break;
                            }
                            value = UtilsFormat.formatDouble(km, 2);
                            break;
                        }
                        value = UtilsFormat.formatDouble(dist, 1);
                    }
                }
                break;
            }
            case 2: {
                switch (precision) {
                    case LOW: 
                    case MEDIUM: {
                        value = UtilsFormat.formatDistance(dist * 3.2808, 0);
                        break;
                    }
                    case HIGH: {
                        value = UtilsFormat.formatDistance(dist * 3.2808, 1);
                    }
                }
                break;
            }
            case 3: {
                value = UtilsFormat.formatDistanceImperial(dist, dist * 3.2808, precision);
                break;
            }
            case 4: {
                switch (precision) {
                    case LOW: 
                    case MEDIUM: {
                        value = UtilsFormat.formatDistance(dist * 1.0936, 0);
                        break;
                    }
                    case HIGH: {
                        value = UtilsFormat.formatDistance(dist * 1.0936, 1);
                    }
                }
                break;
            }
            case 5: {
                value = UtilsFormat.formatDistanceImperial(dist, dist * 1.0936, precision);
                break;
            }
            case 6: {
                switch (precision) {
                    case LOW: 
                    case MEDIUM: {
                        if (dist > 1852.0) {
                            double nmi = dist / 1852.0;
                            if (nmi >= 100.0) {
                                value = UtilsFormat.formatDouble(nmi, 0);
                                break block0;
                            }
                            value = UtilsFormat.formatDouble(nmi, 1);
                            break block0;
                        }
                        value = UtilsFormat.formatDistance(dist, 0);
                        break block0;
                    }
                    case HIGH: {
                        if (dist > 1852.0) {
                            double nmi = dist / 1852.0;
                            if (nmi >= 100.0) {
                                value = UtilsFormat.formatDouble(nmi, 1);
                                break block0;
                            }
                            value = UtilsFormat.formatDouble(nmi, 2);
                            break block0;
                        }
                        value = UtilsFormat.formatDistance(dist, 1);
                    }
                }
            }
        }
        if (addUnits) {
            return value + " " + UtilsFormat.formatDistanceUnits(unitType, dist);
        }
        return value;
    }

    private static String formatDistance(double dist, int basePrecision) {
        if (dist < 10.0) {
            return UtilsFormat.formatDouble(dist, basePrecision);
        }
        return UtilsFormat.formatDouble(dist, basePrecision > 0 ? basePrecision - 1 : 0);
    }

    private static String formatDistanceImperial(double dist, double distInUnit, UnitsPrecision precision) {
        switch (precision) {
            case LOW: 
            case MEDIUM: {
                if (distInUnit >= 1000.0) {
                    double mi = dist / 1609.344;
                    if (mi >= 100.0) {
                        return UtilsFormat.formatDouble(mi, 0);
                    }
                    if (mi >= 1.0) {
                        return UtilsFormat.formatDouble(mi, 1);
                    }
                    return UtilsFormat.formatDouble(mi, 2);
                }
                return UtilsFormat.formatDistance(distInUnit, 0);
            }
            case HIGH: {
                if (distInUnit >= 1000.0) {
                    double mi = dist / 1609.344;
                    if (mi >= 100.0) {
                        return UtilsFormat.formatDouble(mi, 1);
                    }
                    if (mi >= 1.0) {
                        return UtilsFormat.formatDouble(mi, 2);
                    }
                    return UtilsFormat.formatDouble(mi, 3);
                }
                return UtilsFormat.formatDistance(distInUnit, 1);
            }
        }
        return "";
    }

    public static double formatDistanceValue(int unitType, double dist) {
        switch (unitType) {
            case 0: {
                return dist;
            }
            case 1: {
                if (dist >= 1000.0) {
                    return dist / 1000.0;
                }
                return dist;
            }
            case 2: {
                return dist * 3.2808;
            }
            case 3: {
                double feet = dist * 3.2808;
                if (feet >= 1000.0) {
                    return dist / 1609.344;
                }
                return feet;
            }
            case 4: {
                return dist * 1.0936;
            }
            case 5: {
                double yards = dist * 1.0936;
                if (yards >= 1000.0) {
                    return dist / 1609.344;
                }
                return yards;
            }
            case 6: {
                if (dist >= 1852.0) {
                    return dist / 1852.0;
                }
                return dist;
            }
        }
        return dist;
    }

    public static String formatDistanceUnits(int unitType, double dist) {
        switch (unitType) {
            case 0: {
                return "m";
            }
            case 1: {
                if (dist >= 1000.0) {
                    return "km";
                }
                return "m";
            }
            case 2: {
                return " ft";
            }
            case 3: {
                double feet = dist * 3.2808;
                if (feet >= 1000.0) {
                    return "mi";
                }
                return "ft";
            }
            case 4: {
                return "yd";
            }
            case 5: {
                double yards = dist * 1.0936;
                if (yards >= 1000.0) {
                    return "mi";
                }
                return "yd";
            }
            case 6: {
                if (dist >= 1852.0) {
                    return "nmi";
                }
                return "m";
            }
        }
        return "";
    }

    public static String formatEnergy(int unitType, int energy, boolean addUnits) {
        String res = UtilsFormat.formatEnergyValue(unitType, energy);
        if (addUnits) {
            return res + " " + UtilsFormat.formatEnergyUnit(unitType);
        }
        return res;
    }

    public static String formatEnergyValue(int format, int energy) {
        if (format == 0) {
            return UtilsFormat.formatDouble((double)energy * 1.0 / 1000.0, 0);
        }
        return UtilsFormat.formatDouble((double)energy * 1.0 / 4184.999942779541, 0);
    }

    public static String formatEnergyUnit(int format) {
        if (format == 0) {
            return "KJ";
        }
        return "kcal";
    }

    public static String formatSlope(int unitType, double slope, boolean addUnits) {
        String res = UtilsFormat.formatSlopeValue(unitType, slope);
        if (addUnits) {
            return res + " " + UtilsFormat.formatSlopeUnit(unitType);
        }
        return res;
    }

    public static String formatSlopeValue(int format, double slope) {
        if (format == 0) {
            return UtilsFormat.formatDouble(slope * 100.0, 0);
        }
        double slopeAngle = Math.atan(slope) * 57.29577951308232;
        return UtilsFormat.formatDouble(slopeAngle, 0);
    }

    public static String formatSlopeUnit(int format) {
        if (format == 0) {
            return "%";
        }
        return "\u00b0";
    }

    public static String formatSpeed(int unitType, double speed, boolean withoutUnits) {
        String result = speed < 0.0 ? "--" : UtilsFormat.formatDouble(speed, (speed = UtilsFormat.formatSpeedValue(unitType, speed)) > 100.0 ? 0 : 1);
        if (withoutUnits) {
            return result;
        }
        return result + " " + UtilsFormat.formatSpeedUnits(unitType);
    }

    public static double formatSpeedValue(int format, double speed) {
        speed = format == 1 ? (speed *= 2.237) : (format == 2 || format == 3 ? (speed *= 1.9438444924406046) : (speed *= 3.6));
        return speed;
    }

    public static String formatSpeedUnits(int format) {
        if (format == 1) {
            return "mi/h";
        }
        if (format == 2) {
            return "nmi/h";
        }
        if (format == 3) {
            return "kn";
        }
        return "km/h";
    }

    public static String formatTemperature(int unitType, float tempC, boolean addUnits) {
        String res = UtilsFormat.formatTemperatureValue(unitType, tempC);
        if (addUnits) {
            return res + " " + UtilsFormat.formatTemperatureUnit(unitType);
        }
        return res;
    }

    public static String formatTemperatureValue(int format, float tempC) {
        if (format == 0) {
            return UtilsFormat.formatDouble(tempC, 1);
        }
        return UtilsFormat.formatDouble(tempC * 9.0f / 5.0f + 32.0f, 1);
    }

    public static String formatTemperatureUnit(int format) {
        if (format == 0) {
            return "\u00b0C";
        }
        return "F";
    }

    public static String formatWeight(int unitType, double weight, boolean addUnits) {
        String res = UtilsFormat.formatWeightValue(unitType, weight);
        if (addUnits) {
            return res + " " + UtilsFormat.formatWeightUnit(unitType);
        }
        return res;
    }

    public static String formatWeightValue(int format, double weight) {
        if (format == 0) {
            return UtilsFormat.formatDouble(weight * 1.0 / 1000.0, 1);
        }
        return UtilsFormat.formatDouble(weight * (double)2.204622f / 1000.0, 1);
    }

    public static String formatWeightUnit(int format) {
        if (format == 0) {
            return "kg";
        }
        if (format == 1) {
            return "lb";
        }
        return "???";
    }

    public static String formatDouble(double value, int precision) {
        return UtilsFormat.formatDouble(value, precision, 1);
    }

    public static String formatDouble(double value, int precision, int minlen) {
        if (minlen < 0) {
            minlen = 0;
        } else if (minlen > formats.length - 1) {
            minlen = formats.length - 1;
        }
        if (precision < 0) {
            precision = 0;
        } else if (precision > formats[0].length - 1) {
            precision = formats[0].length - 1;
        }
        return formats[minlen][precision].format(value);
    }

    static {
        DecimalFormat[][] decimalFormatArray = formats = new DecimalFormat[][]{{new DecimalFormat("#"), new DecimalFormat("#.0"), new DecimalFormat("#.00"), new DecimalFormat("#.000"), new DecimalFormat("#.0000"), new DecimalFormat("#.00000"), new DecimalFormat("#.000000")}, {new DecimalFormat("#0"), new DecimalFormat("#0.0"), new DecimalFormat("#0.00"), new DecimalFormat("#0.000"), new DecimalFormat("#0.0000"), new DecimalFormat("#0.00000"), new DecimalFormat("#0.000000")}, {new DecimalFormat("#00"), new DecimalFormat("#00.0"), new DecimalFormat("#00.00"), new DecimalFormat("#00.000"), new DecimalFormat("#00.0000"), new DecimalFormat("#00.00000"), new DecimalFormat("#00.000000")}, {new DecimalFormat("#000"), new DecimalFormat("#000.0"), new DecimalFormat("#000.00"), new DecimalFormat("#000.000"), new DecimalFormat("#000.0000"), new DecimalFormat("#000.00000"), new DecimalFormat("#000.000000")}, {new DecimalFormat("#0000"), new DecimalFormat("#0000.0"), new DecimalFormat("#0000.00"), new DecimalFormat("#0000.000"), new DecimalFormat("#0000.0000"), new DecimalFormat("#0000.00000"), new DecimalFormat("#0000.000000")}, {new DecimalFormat("#00000"), new DecimalFormat("#00000.0"), new DecimalFormat("#00000.00"), new DecimalFormat("#00000.000"), new DecimalFormat("#00000.0000"), new DecimalFormat("#00000.00000"), new DecimalFormat("#00000.000000")}, {new DecimalFormat("#000000"), new DecimalFormat("#000000.0"), new DecimalFormat("#000000.00"), new DecimalFormat("#000000.000"), new DecimalFormat("#000000.0000"), new DecimalFormat("#000000.00000"), new DecimalFormat("#000000.000000")}, {new DecimalFormat("#0000000"), new DecimalFormat("#0000000.0"), new DecimalFormat("#0000000.00"), new DecimalFormat("#0000000.000"), new DecimalFormat("#0000000.0000"), new DecimalFormat("#0000000.00000"), new DecimalFormat("#0000000.000000")}};
        int n = decimalFormatArray.length;
        for (int i = 0; i < n; ++i) {
            DecimalFormat[] format;
            for (DecimalFormat aFormat : format = decimalFormatArray[i]) {
                aFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
            }
        }
    }

    public static enum UnitsPrecision {
        LOW,
        MEDIUM,
        HIGH;

    }
}

