/*
 * Decompiled with CFR 0.152.
 */
package com.yqritc.recyclerviewflexibledivider;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public abstract class FlexibleDividerDecoration
extends RecyclerView.ItemDecoration {
    private static final int DEFAULT_SIZE = 2;
    private static final int[] ATTRS = new int[]{16843284};
    protected DividerType mDividerType = DividerType.DRAWABLE;
    protected VisibilityProvider mVisibilityProvider;
    protected PaintProvider mPaintProvider;
    protected ColorProvider mColorProvider;
    protected DrawableProvider mDrawableProvider;
    protected SizeProvider mSizeProvider;
    protected boolean mShowLastDivider;
    protected boolean mPositionInsideItem;
    private Paint mPaint;

    protected FlexibleDividerDecoration(Builder builder) {
        if (builder.mPaintProvider != null) {
            this.mDividerType = DividerType.PAINT;
            this.mPaintProvider = builder.mPaintProvider;
        } else if (builder.mColorProvider != null) {
            this.mDividerType = DividerType.COLOR;
            this.mColorProvider = builder.mColorProvider;
            this.mPaint = new Paint();
            this.setSizeProvider(builder);
        } else {
            this.mDividerType = DividerType.DRAWABLE;
            if (builder.mDrawableProvider == null) {
                TypedArray a = builder.mContext.obtainStyledAttributes(ATTRS);
                final Drawable divider = a.getDrawable(0);
                a.recycle();
                this.mDrawableProvider = new DrawableProvider(){

                    @Override
                    public Drawable drawableProvider(int position, RecyclerView parent) {
                        return divider;
                    }
                };
            } else {
                this.mDrawableProvider = builder.mDrawableProvider;
            }
            this.mSizeProvider = builder.mSizeProvider;
        }
        this.mVisibilityProvider = builder.mVisibilityProvider;
        this.mShowLastDivider = builder.mShowLastDivider;
        this.mPositionInsideItem = builder.mPositionInsideItem;
    }

    private void setSizeProvider(Builder builder) {
        this.mSizeProvider = builder.mSizeProvider;
        if (this.mSizeProvider == null) {
            this.mSizeProvider = new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return 2;
                }
            };
        }
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter == null) {
            return;
        }
        int itemCount = adapter.getItemCount();
        int lastDividerOffset = this.getLastDividerOffset(parent);
        int validChildCount = parent.getChildCount();
        int lastChildPosition = -1;
        block5: for (int i = 0; i < validChildCount; ++i) {
            int groupIndex;
            View child = parent.getChildAt(i);
            int childPosition = parent.getChildAdapterPosition(child);
            if (childPosition < lastChildPosition) continue;
            lastChildPosition = childPosition;
            if (!this.mShowLastDivider && childPosition >= itemCount - lastDividerOffset || this.wasDividerAlreadyDrawn(childPosition, parent) || this.mVisibilityProvider.shouldHideDivider(groupIndex = this.getGroupIndex(childPosition, parent), parent)) continue;
            Rect bounds = this.getDividerBound(groupIndex, parent, child);
            switch (this.mDividerType) {
                case DRAWABLE: {
                    Drawable drawable = this.mDrawableProvider.drawableProvider(groupIndex, parent);
                    drawable.setBounds(bounds);
                    drawable.draw(c);
                    continue block5;
                }
                case PAINT: {
                    this.mPaint = this.mPaintProvider.dividerPaint(groupIndex, parent);
                    c.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                    continue block5;
                }
                case COLOR: {
                    this.mPaint.setColor(this.mColorProvider.dividerColor(groupIndex, parent));
                    this.mPaint.setStrokeWidth((float)this.mSizeProvider.dividerSize(groupIndex, parent));
                    c.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                }
            }
        }
    }

    public void getItemOffsets(Rect rect, View v, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(v);
        int itemCount = parent.getAdapter().getItemCount();
        int lastDividerOffset = this.getLastDividerOffset(parent);
        if (!this.mShowLastDivider && position >= itemCount - lastDividerOffset) {
            return;
        }
        int groupIndex = this.getGroupIndex(position, parent);
        if (this.mVisibilityProvider.shouldHideDivider(groupIndex, parent)) {
            return;
        }
        this.setItemOffsets(rect, groupIndex, parent);
    }

    protected boolean isReverseLayout(RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getReverseLayout();
        }
        return false;
    }

    private int getLastDividerOffset(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            int spanCount = layoutManager.getSpanCount();
            int itemCount = parent.getAdapter().getItemCount();
            for (int i = itemCount - 1; i >= 0; --i) {
                if (spanSizeLookup.getSpanIndex(i, spanCount) != 0) continue;
                return itemCount - i;
            }
        }
        return 1;
    }

    private boolean wasDividerAlreadyDrawn(int position, RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            int spanCount;
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            return spanSizeLookup.getSpanIndex(position, spanCount = layoutManager.getSpanCount()) > 0;
        }
        return false;
    }

    private int getGroupIndex(int position, RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            int spanCount = layoutManager.getSpanCount();
            return spanSizeLookup.getSpanGroupIndex(position, spanCount);
        }
        return position;
    }

    protected abstract Rect getDividerBound(int var1, RecyclerView var2, View var3);

    protected abstract void setItemOffsets(Rect var1, int var2, RecyclerView var3);

    public static class Builder<T extends Builder> {
        private Context mContext;
        protected Resources mResources;
        private PaintProvider mPaintProvider;
        private ColorProvider mColorProvider;
        private DrawableProvider mDrawableProvider;
        private SizeProvider mSizeProvider;
        private VisibilityProvider mVisibilityProvider = new VisibilityProvider(){

            @Override
            public boolean shouldHideDivider(int position, RecyclerView parent) {
                return false;
            }
        };
        private boolean mShowLastDivider = false;
        private boolean mPositionInsideItem = false;

        public Builder(Context context) {
            this.mContext = context;
            this.mResources = context.getResources();
        }

        public T paint(final Paint paint) {
            return this.paintProvider(new PaintProvider(){

                @Override
                public Paint dividerPaint(int position, RecyclerView parent) {
                    return paint;
                }
            });
        }

        public T paintProvider(PaintProvider provider) {
            this.mPaintProvider = provider;
            return (T)this;
        }

        public T color(final int color) {
            return this.colorProvider(new ColorProvider(){

                @Override
                public int dividerColor(int position, RecyclerView parent) {
                    return color;
                }
            });
        }

        public T colorResId(@ColorRes int colorId) {
            return this.color(ContextCompat.getColor((Context)this.mContext, (int)colorId));
        }

        public T colorProvider(ColorProvider provider) {
            this.mColorProvider = provider;
            return (T)this;
        }

        public T drawable(@DrawableRes int id) {
            return this.drawable(ContextCompat.getDrawable((Context)this.mContext, (int)id));
        }

        public T drawable(final Drawable drawable) {
            return this.drawableProvider(new DrawableProvider(){

                @Override
                public Drawable drawableProvider(int position, RecyclerView parent) {
                    return drawable;
                }
            });
        }

        public T drawableProvider(DrawableProvider provider) {
            this.mDrawableProvider = provider;
            return (T)this;
        }

        public T size(final int size) {
            return this.sizeProvider(new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return size;
                }
            });
        }

        public T sizeResId(@DimenRes int sizeId) {
            return this.size(this.mResources.getDimensionPixelSize(sizeId));
        }

        public T sizeProvider(SizeProvider provider) {
            this.mSizeProvider = provider;
            return (T)this;
        }

        public T visibilityProvider(VisibilityProvider provider) {
            this.mVisibilityProvider = provider;
            return (T)this;
        }

        public T showLastDivider() {
            this.mShowLastDivider = true;
            return (T)this;
        }

        public T positionInsideItem(boolean positionInsideItem) {
            this.mPositionInsideItem = positionInsideItem;
            return (T)this;
        }

        protected void checkBuilderParams() {
            if (this.mPaintProvider != null) {
                if (this.mColorProvider != null) {
                    throw new IllegalArgumentException("Use setColor method of Paint class to specify line color. Do not provider ColorProvider if you set PaintProvider.");
                }
                if (this.mSizeProvider != null) {
                    throw new IllegalArgumentException("Use setStrokeWidth method of Paint class to specify line size. Do not provider SizeProvider if you set PaintProvider.");
                }
            }
        }
    }

    public static interface SizeProvider {
        public int dividerSize(int var1, RecyclerView var2);
    }

    public static interface DrawableProvider {
        public Drawable drawableProvider(int var1, RecyclerView var2);
    }

    public static interface ColorProvider {
        public int dividerColor(int var1, RecyclerView var2);
    }

    public static interface PaintProvider {
        public Paint dividerPaint(int var1, RecyclerView var2);
    }

    public static interface VisibilityProvider {
        public boolean shouldHideDivider(int var1, RecyclerView var2);
    }

    protected static enum DividerType {
        DRAWABLE,
        PAINT,
        COLOR;

    }
}

