/*
 * Decompiled with CFR 0.152.
 */
package com.yqritc.recyclerviewflexibledivider;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DimenRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.yqritc.recyclerviewflexibledivider.FlexibleDividerDecoration;

public class HorizontalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    protected HorizontalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent, View child) {
        Rect bounds = new Rect(0, 0, 0, 0);
        int transitionX = (int)ViewCompat.getTranslationX((View)child);
        int transitionY = (int)ViewCompat.getTranslationY((View)child);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        bounds.left = parent.getPaddingLeft() + this.mMarginProvider.dividerLeftMargin(position, parent) + transitionX;
        bounds.right = parent.getWidth() - parent.getPaddingRight() - this.mMarginProvider.dividerRightMargin(position, parent) + transitionX;
        int dividerSize = this.getDividerSize(position, parent);
        boolean isReverseLayout = this.isReverseLayout(parent);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE) {
            if (isReverseLayout) {
                bounds.bottom = child.getTop() - params.topMargin + transitionY;
                bounds.top = bounds.bottom - dividerSize;
            } else {
                bounds.top = child.getBottom() + params.bottomMargin + transitionY;
                bounds.bottom = bounds.top + dividerSize;
            }
        } else {
            int halfSize = dividerSize / 2;
            bounds.top = isReverseLayout ? child.getTop() - params.topMargin - halfSize + transitionY : child.getBottom() + params.bottomMargin + halfSize + transitionY;
            bounds.bottom = bounds.top;
        }
        if (this.mPositionInsideItem) {
            if (isReverseLayout) {
                bounds.top += dividerSize;
                bounds.bottom += dividerSize;
            } else {
                bounds.top -= dividerSize;
                bounds.bottom -= dividerSize;
            }
        }
        return bounds;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent) {
        if (this.mPositionInsideItem) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        if (this.isReverseLayout(parent)) {
            outRect.set(0, this.getDividerSize(position, parent), 0, 0);
        } else {
            outRect.set(0, 0, 0, this.getDividerSize(position, parent));
        }
    }

    private int getDividerSize(int position, RecyclerView parent) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable.getIntrinsicHeight();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerLeftMargin(int position, RecyclerView parent) {
                return 0;
            }

            @Override
            public int dividerRightMargin(int position, RecyclerView parent) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int leftMargin, final int rightMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerLeftMargin(int position, RecyclerView parent) {
                    return leftMargin;
                }

                @Override
                public int dividerRightMargin(int position, RecyclerView parent) {
                    return rightMargin;
                }
            });
        }

        public Builder margin(int horizontalMargin) {
            return this.margin(horizontalMargin, horizontalMargin);
        }

        public Builder marginResId(@DimenRes int leftMarginId, @DimenRes int rightMarginId) {
            return this.margin(this.mResources.getDimensionPixelSize(leftMarginId), this.mResources.getDimensionPixelSize(rightMarginId));
        }

        public Builder marginResId(@DimenRes int horizontalMarginId) {
            return this.marginResId(horizontalMarginId, horizontalMarginId);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public HorizontalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new HorizontalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerLeftMargin(int var1, RecyclerView var2);

        public int dividerRightMargin(int var1, RecyclerView var2);
    }
}

