/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import java.io.OutputStream;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MapPosition;
import org.mapsforge.v3.core.MercatorProjection;
import org.mapsforge.v3.core.Tile;

public class FrameBuffer {
    static final int MAP_VIEW_BACKGROUND = Color.rgb((int)238, (int)238, (int)238);
    private int height;
    private final MapView mapView;
    private Bitmap mapViewBitmap1;
    private Bitmap mapViewBitmap2;
    private final Canvas mapViewCanvas;
    private final Matrix matrix;
    private int width;

    FrameBuffer(MapView mapView) {
        this.mapView = mapView;
        this.mapViewCanvas = new Canvas();
        this.matrix = new Matrix();
    }

    public synchronized boolean drawBitmap(Tile tile, Bitmap bitmap) {
        MapPosition mapPosition = this.mapView.getMapPosition().getMapPosition();
        if (tile.zoomLevel != mapPosition.zoomLevel) {
            return false;
        }
        if (this.mapView.isZoomAnimatorRunning()) {
            return false;
        }
        GeoPoint geoPoint = mapPosition.geoPoint;
        double pixelLeft = MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), mapPosition.zoomLevel);
        double pixelTop = MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), mapPosition.zoomLevel);
        pixelTop -= (double)(this.height >> 1);
        if ((pixelLeft -= (double)(this.width >> 1)) - (double)tile.getPixelX() > 256.0 || pixelLeft + (double)this.width < (double)tile.getPixelX()) {
            return false;
        }
        if (pixelTop - (double)tile.getPixelY() > 256.0 || pixelTop + (double)this.height < (double)tile.getPixelY()) {
            return false;
        }
        if (!this.matrix.isIdentity()) {
            this.mapViewBitmap2.eraseColor(MAP_VIEW_BACKGROUND);
            this.mapViewCanvas.setBitmap(this.mapViewBitmap2);
            this.mapViewCanvas.drawBitmap(this.mapViewBitmap1, this.matrix, null);
            this.matrix.reset();
            Bitmap mapViewBitmapSwap = this.mapViewBitmap1;
            this.mapViewBitmap1 = this.mapViewBitmap2;
            this.mapViewBitmap2 = mapViewBitmapSwap;
        }
        float left = (float)((double)tile.getPixelX() - pixelLeft);
        float top = (float)((double)tile.getPixelY() - pixelTop);
        this.mapViewCanvas.drawBitmap(bitmap, left, top, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matrixPostScale(float scaleX, float scaleY, float pivotX, float pivotY) {
        FrameBuffer frameBuffer = this;
        synchronized (frameBuffer) {
            this.matrix.postScale(scaleX, scaleY, pivotX, pivotY);
            List<Overlay> list = this.mapView.getOverlays();
            synchronized (list) {
                int n = this.mapView.getOverlays().size();
                for (int i = 0; i < n; ++i) {
                    this.mapView.getOverlays().get(i).matrixPostScale(scaleX, scaleY, pivotX, pivotY);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matrixPostTranslate(float translateX, float translateY) {
        FrameBuffer frameBuffer = this;
        synchronized (frameBuffer) {
            this.matrix.postTranslate(translateX, translateY);
            List<Overlay> list = this.mapView.getOverlays();
            synchronized (list) {
                int n = this.mapView.getOverlays().size();
                for (int i = 0; i < n; ++i) {
                    this.mapView.getOverlays().get(i).matrixPostTranslate(translateX, translateY);
                }
            }
        }
    }

    synchronized void clear() {
        if (this.mapViewBitmap1 != null) {
            this.mapViewBitmap1.eraseColor(MAP_VIEW_BACKGROUND);
        }
        if (this.mapViewBitmap2 != null) {
            this.mapViewBitmap2.eraseColor(MAP_VIEW_BACKGROUND);
        }
    }

    synchronized boolean compress(Bitmap.CompressFormat compressFormat, int quality, OutputStream outputStream) {
        if (this.mapViewBitmap1 == null) {
            return false;
        }
        return this.mapViewBitmap1.compress(compressFormat, quality, outputStream);
    }

    synchronized void destroy() {
        if (this.mapViewBitmap1 != null) {
            this.mapViewBitmap1.recycle();
        }
        if (this.mapViewBitmap2 != null) {
            this.mapViewBitmap2.recycle();
        }
    }

    synchronized void draw(Canvas canvas) {
        if (this.mapViewBitmap1 != null) {
            canvas.drawBitmap(this.mapViewBitmap1, this.matrix, null);
        }
    }

    synchronized void onSizeChanged() {
        this.width = this.mapView.getWidth();
        this.height = this.mapView.getHeight();
        this.mapViewBitmap1 = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.mapViewBitmap2 = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.clear();
        this.mapViewCanvas.setBitmap(this.mapViewBitmap1);
    }
}

