/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.app.Activity;
import android.content.SharedPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.mapgenerator.MapGenerator;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MapPosition;

public abstract class MapActivity
extends Activity {
    private static final String KEY_LATITUDE = "latitude";
    private static final String KEY_LONGITUDE = "longitude";
    private static final String KEY_MAP_FILE = "mapFile";
    private static final String KEY_ZOOM_LEVEL = "zoomLevel";
    private static final String PREFERENCES_FILE = "MapActivity";
    private int lastMapViewId;
    private final List<MapView> mapViews = new ArrayList<MapView>(2);

    private static boolean containsMapViewPosition(SharedPreferences sharedPreferences) {
        return sharedPreferences.contains(KEY_LATITUDE) && sharedPreferences.contains(KEY_LONGITUDE) && sharedPreferences.contains(KEY_ZOOM_LEVEL);
    }

    private void destroyMapViews() {
        while (!this.mapViews.isEmpty()) {
            MapView mapView = this.mapViews.remove(0);
            mapView.destroy();
        }
    }

    private void restoreMapView(MapView mapView) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCES_FILE, 0);
        if (MapActivity.containsMapViewPosition(sharedPreferences)) {
            MapGenerator mapGenerator = mapView.getMapGenerator();
            if (!mapGenerator.requiresInternetConnection() && sharedPreferences.contains(KEY_MAP_FILE)) {
                mapView.setMapFile(new File(sharedPreferences.getString(KEY_MAP_FILE, null)));
            }
            int latitudeE6 = sharedPreferences.getInt(KEY_LATITUDE, 0);
            int longitudeE6 = sharedPreferences.getInt(KEY_LONGITUDE, 0);
            int zoomLevel = sharedPreferences.getInt(KEY_ZOOM_LEVEL, -1);
            GeoPoint geoPoint = new GeoPoint(latitudeE6, longitudeE6);
            MapPosition mapPosition = new MapPosition(geoPoint, (byte)zoomLevel);
            mapView.setCenterAndZoom(mapPosition);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.destroyMapViews();
    }

    protected void onPause() {
        super.onPause();
        int n = this.mapViews.size();
        for (int i = 0; i < n; ++i) {
            this.mapViews.get(i).onPause();
        }
        SharedPreferences.Editor editor = this.getSharedPreferences(PREFERENCES_FILE, 0).edit();
        editor.clear();
        MapView mapView = this.mapViews.get(0);
        MapPosition mapPosition = mapView.getMapPosition().getMapPosition();
        if (mapPosition != null) {
            GeoPoint geoPoint = mapPosition.geoPoint;
            editor.putInt(KEY_LATITUDE, geoPoint.latitudeE6);
            editor.putInt(KEY_LONGITUDE, geoPoint.longitudeE6);
            editor.putInt(KEY_ZOOM_LEVEL, (int)mapPosition.zoomLevel);
        }
        if (!mapView.getMapGenerator().requiresInternetConnection() && mapView.getMapFile() != null) {
            editor.putString(KEY_MAP_FILE, mapView.getMapFile().getAbsolutePath());
        }
        editor.commit();
    }

    protected void onResume() {
        super.onResume();
        int n = this.mapViews.size();
        for (int i = 0; i < n; ++i) {
            this.mapViews.get(i).onResume();
        }
    }

    final int getMapViewId() {
        return ++this.lastMapViewId;
    }

    final void registerMapView(MapView mapView) {
        this.mapViews.add(mapView);
        this.restoreMapView(mapView);
    }
}

