/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.view.KeyEvent;
import android.view.View;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.core.GeoPoint;

public final class MapController
implements View.OnKeyListener {
    private final MapView mapView;

    MapController(MapView mapView) {
        this.mapView = mapView;
    }

    public boolean onKey(View view, int keyCode, KeyEvent keyEvent) {
        if (keyEvent.getAction() == 0) {
            return this.mapView.onKeyDown(keyCode, keyEvent);
        }
        if (keyEvent.getAction() == 1) {
            return this.mapView.onKeyUp(keyCode, keyEvent);
        }
        return false;
    }

    public void setCenter(GeoPoint geoPoint) {
        this.mapView.setCenter(geoPoint);
    }

    public int setZoom(int zoomLevel) {
        this.mapView.zoom((byte)(zoomLevel - this.mapView.getMapPosition().getZoomLevel()), 1.0f);
        return this.mapView.getMapPosition().getZoomLevel();
    }

    public boolean zoomIn() {
        return this.mapView.zoom((byte)1, 1.0f);
    }

    public boolean zoomOut() {
        return this.mapView.zoom((byte)-1, 1.0f);
    }
}

