/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import java.util.HashMap;
import java.util.Map;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.core.MapPosition;
import org.mapsforge.v3.core.MercatorProjection;

public class MapScaleBar {
    private static final int BITMAP_HEIGHT = 50;
    private static final int BITMAP_WIDTH = 150;
    private static final double LATITUDE_REDRAW_THRESHOLD = 0.2;
    private static final int MARGIN_BOTTOM = 5;
    private static final int MARGIN_LEFT = 5;
    private static final double METER_FOOT_RATIO = 0.3048;
    private static final int ONE_KILOMETER = 1000;
    private static final int ONE_MILE = 5280;
    private static final Paint SCALE_BAR = new Paint(1);
    private static final Paint SCALE_BAR_STROKE = new Paint(1);
    private static final int[] SCALE_BAR_VALUES_IMPERIAL = new int[]{26400000, 10560000, 5280000, 2640000, 0x101D00, 528000, 264000, 105600, 52800, 26400, 10560, 5280, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 1};
    private static final int[] SCALE_BAR_VALUES_METRIC = new int[]{10000000, 5000000, 2000000, 1000000, 500000, 200000, 100000, 50000, 20000, 10000, 5000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 1};
    private static final Paint SCALE_TEXT = new Paint(1);
    private static final Paint SCALE_TEXT_STROKE = new Paint(1);
    private boolean imperialUnits;
    private MapPosition mapPosition;
    private final Bitmap mapScaleBitmap;
    private final Canvas mapScaleCanvas;
    private final MapView mapView;
    private boolean redrawNeeded;
    private boolean showMapScaleBar;
    private final Map<TextField, String> textFields;

    private static void configurePaints() {
        SCALE_BAR.setStrokeWidth(2.0f);
        SCALE_BAR.setStrokeCap(Paint.Cap.SQUARE);
        SCALE_BAR.setColor(-16777216);
        SCALE_BAR_STROKE.setStrokeWidth(5.0f);
        SCALE_BAR_STROKE.setStrokeCap(Paint.Cap.SQUARE);
        SCALE_BAR_STROKE.setColor(-1);
        SCALE_TEXT.setTypeface(Typeface.defaultFromStyle((int)1));
        SCALE_TEXT.setTextSize(17.0f);
        SCALE_TEXT.setColor(-16777216);
        SCALE_TEXT_STROKE.setTypeface(Typeface.defaultFromStyle((int)1));
        SCALE_TEXT_STROKE.setStyle(Paint.Style.STROKE);
        SCALE_TEXT_STROKE.setColor(-1);
        SCALE_TEXT_STROKE.setStrokeWidth(2.0f);
        SCALE_TEXT_STROKE.setTextSize(17.0f);
    }

    MapScaleBar(MapView mapView) {
        this.mapView = mapView;
        this.mapScaleBitmap = Bitmap.createBitmap((int)150, (int)50, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        this.mapScaleCanvas = new Canvas(this.mapScaleBitmap);
        this.textFields = new HashMap<TextField, String>();
        this.setDefaultTexts();
        MapScaleBar.configurePaints();
    }

    public boolean isImperialUnits() {
        return this.imperialUnits;
    }

    public boolean isShowMapScaleBar() {
        return this.showMapScaleBar;
    }

    public void setImperialUnits(boolean imperialUnits) {
        this.imperialUnits = imperialUnits;
        this.redrawNeeded = true;
    }

    public void setShowMapScaleBar(boolean showMapScaleBar) {
        this.showMapScaleBar = showMapScaleBar;
    }

    public void setText(TextField textField, String value) {
        this.textFields.put(textField, value);
        this.redrawNeeded = true;
    }

    private void drawScaleBar(float scaleBarLength, Paint paint) {
        this.mapScaleCanvas.drawLine(7.0f, 25.0f, scaleBarLength + 3.0f, 25.0f, paint);
        this.mapScaleCanvas.drawLine(5.0f, 10.0f, 5.0f, 40.0f, paint);
        this.mapScaleCanvas.drawLine(scaleBarLength + 5.0f, 10.0f, scaleBarLength + 5.0f, 40.0f, paint);
    }

    private void drawScaleText(int scaleValue, String unitSymbol, Paint paint) {
        this.mapScaleCanvas.drawText(scaleValue + unitSymbol, 12.0f, 18.0f, paint);
    }

    private boolean isRedrawNecessary() {
        if (this.redrawNeeded || this.mapPosition == null) {
            return true;
        }
        MapPosition currentMapPosition = this.mapView.getMapPosition().getMapPosition();
        if (currentMapPosition.zoomLevel != this.mapPosition.zoomLevel) {
            return true;
        }
        double latitudeDiff = Math.abs(currentMapPosition.geoPoint.getLatitude() - this.mapPosition.geoPoint.getLatitude());
        return latitudeDiff > 0.2;
    }

    private void redrawMapScaleBitmap(float scaleBarLength, int mapScaleValue) {
        String unitSymbol;
        int scaleValue;
        this.mapScaleBitmap.eraseColor(0);
        this.drawScaleBar(scaleBarLength, SCALE_BAR_STROKE);
        this.drawScaleBar(scaleBarLength, SCALE_BAR);
        if (this.imperialUnits) {
            if (mapScaleValue < 5280) {
                scaleValue = mapScaleValue;
                unitSymbol = this.textFields.get((Object)TextField.FOOT);
            } else {
                scaleValue = mapScaleValue / 5280;
                unitSymbol = this.textFields.get((Object)TextField.MILE);
            }
        } else if (mapScaleValue < 1000) {
            scaleValue = mapScaleValue;
            unitSymbol = this.textFields.get((Object)TextField.METER);
        } else {
            scaleValue = mapScaleValue / 1000;
            unitSymbol = this.textFields.get((Object)TextField.KILOMETER);
        }
        this.drawScaleText(scaleValue, unitSymbol, SCALE_TEXT_STROKE);
        this.drawScaleText(scaleValue, unitSymbol, SCALE_TEXT);
    }

    private void setDefaultTexts() {
        this.textFields.put(TextField.FOOT, " ft");
        this.textFields.put(TextField.MILE, " mi");
        this.textFields.put(TextField.METER, " m");
        this.textFields.put(TextField.KILOMETER, " km");
    }

    void destroy() {
        this.mapScaleBitmap.recycle();
    }

    void draw(Canvas canvas) {
        int top = this.mapView.getHeight() - 50 - 5;
        canvas.drawBitmap(this.mapScaleBitmap, 5.0f, (float)top, null);
    }

    void redrawScaleBar() {
        int[] scaleBarValues;
        if (!this.isRedrawNecessary()) {
            return;
        }
        this.mapPosition = this.mapView.getMapPosition().getMapPosition();
        double groundResolution = MercatorProjection.calculateGroundResolution(this.mapPosition.geoPoint.getLatitude(), this.mapPosition.zoomLevel);
        if (this.imperialUnits) {
            groundResolution /= 0.3048;
            scaleBarValues = SCALE_BAR_VALUES_IMPERIAL;
        } else {
            scaleBarValues = SCALE_BAR_VALUES_METRIC;
        }
        float scaleBarLength = 0.0f;
        int mapScaleValue = 0;
        for (int i = 0; i < scaleBarValues.length && !((scaleBarLength = (float)(mapScaleValue = scaleBarValues[i]) / (float)groundResolution) < 140.0f); ++i) {
        }
        this.redrawMapScaleBitmap(scaleBarLength, mapScaleValue);
        this.redrawNeeded = false;
    }

    public static enum TextField {
        FOOT,
        KILOMETER,
        METER,
        MILE;

    }
}

