/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.mapsforge.v3.android.AndroidUtils;
import org.mapsforge.v3.android.maps.DebugSettings;
import org.mapsforge.v3.android.maps.FpsCounter;
import org.mapsforge.v3.android.maps.FrameBuffer;
import org.mapsforge.v3.android.maps.MapActivity;
import org.mapsforge.v3.android.maps.MapController;
import org.mapsforge.v3.android.maps.MapScaleBar;
import org.mapsforge.v3.android.maps.MapViewPosition;
import org.mapsforge.v3.android.maps.MapViewProjection;
import org.mapsforge.v3.android.maps.MapZoomControls;
import org.mapsforge.v3.android.maps.Projection;
import org.mapsforge.v3.android.maps.inputhandling.MapMover;
import org.mapsforge.v3.android.maps.inputhandling.TouchEventHandler;
import org.mapsforge.v3.android.maps.inputhandling.ZoomAnimator;
import org.mapsforge.v3.android.maps.mapgenerator.FileSystemTileCache;
import org.mapsforge.v3.android.maps.mapgenerator.InMemoryTileCache;
import org.mapsforge.v3.android.maps.mapgenerator.JobParameters;
import org.mapsforge.v3.android.maps.mapgenerator.JobQueue;
import org.mapsforge.v3.android.maps.mapgenerator.MapGenerator;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorFactory;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.android.maps.mapgenerator.MapWorker;
import org.mapsforge.v3.android.maps.mapgenerator.TileCache;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.DatabaseRenderer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.ExternalRenderTheme;
import org.mapsforge.v3.android.maps.mapgenerator.tiledownloader.TileDownloader;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.android.maps.overlay.OverlayList;
import org.mapsforge.v3.android.maps.rendertheme.InternalRenderTheme;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MapPosition;
import org.mapsforge.v3.core.MercatorProjection;
import org.mapsforge.v3.core.Tile;
import org.mapsforge.v3.map.reader.MapDatabase;
import org.mapsforge.v3.map.reader.header.FileOpenResult;

public class MapView
extends ViewGroup {
    public static final InternalRenderTheme DEFAULT_RENDER_THEME = InternalRenderTheme.OSMARENDER;
    private static final float DEFAULT_TEXT_SCALE = 1.0f;
    private static final int DEFAULT_TILE_CACHE_SIZE_FILE_SYSTEM = 100;
    private static final int DEFAULT_TILE_CACHE_SIZE_IN_MEMORY = 20;
    private DebugSettings debugSettings;
    private final TileCache fileSystemTileCache;
    private final FpsCounter fpsCounter;
    private final FrameBuffer frameBuffer;
    private final TileCache inMemoryTileCache;
    private JobParameters jobParameters;
    private final JobQueue jobQueue;
    private final MapController mapController;
    private final MapDatabase mapDatabase;
    private File mapFile;
    private MapGenerator mapGenerator;
    private final MapMover mapMover;
    private final MapScaleBar mapScaleBar;
    private final MapViewPosition mapViewPosition;
    private final MapWorker mapWorker;
    private final MapZoomControls mapZoomControls;
    private final List<Overlay> overlays;
    private final Projection projection;
    private final TouchEventHandler touchEventHandler;
    private final ZoomAnimator zoomAnimator;

    public MapView(Context context) {
        this(context, null, new DatabaseRenderer());
    }

    public MapView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, MapGeneratorFactory.createMapGenerator(attributeSet));
    }

    public MapView(Context context, MapGenerator mapGenerator) {
        this(context, null, mapGenerator);
    }

    private MapView(Context context, AttributeSet attributeSet, MapGenerator mapGenerator) {
        super(context, attributeSet);
        Byte startZoomLevel;
        if (!(context instanceof MapActivity)) {
            throw new IllegalArgumentException("context is not an instance of MapActivity");
        }
        MapActivity mapActivity = (MapActivity)context;
        this.setBackgroundColor(FrameBuffer.MAP_VIEW_BACKGROUND);
        this.setDescendantFocusability(393216);
        this.setWillNotDraw(false);
        this.debugSettings = new DebugSettings(false, false, false);
        this.fileSystemTileCache = new FileSystemTileCache(100, mapActivity.getMapViewId());
        this.fpsCounter = new FpsCounter();
        this.frameBuffer = new FrameBuffer(this);
        this.inMemoryTileCache = new InMemoryTileCache(20);
        this.jobParameters = new JobParameters(DEFAULT_RENDER_THEME, 1.0f);
        this.jobQueue = new JobQueue(this);
        this.mapController = new MapController(this);
        this.mapDatabase = new MapDatabase();
        this.mapViewPosition = new MapViewPosition(this);
        this.mapScaleBar = new MapScaleBar(this);
        this.mapZoomControls = new MapZoomControls((Context)mapActivity, this);
        this.overlays = new OverlayList(this);
        this.projection = new MapViewProjection(this);
        this.touchEventHandler = TouchEventHandler.getInstance((Context)mapActivity, this);
        this.mapWorker = new MapWorker(this);
        this.mapWorker.start();
        this.mapMover = new MapMover(this);
        this.mapMover.start();
        this.zoomAnimator = new ZoomAnimator(this);
        this.zoomAnimator.start();
        this.setMapGeneratorInternal(mapGenerator);
        GeoPoint startPoint = this.mapGenerator.getStartPoint();
        if (startPoint != null) {
            this.mapViewPosition.setMapCenter(startPoint);
        }
        if ((startZoomLevel = this.mapGenerator.getStartZoomLevel()) != null) {
            this.mapViewPosition.setZoomLevel(startZoomLevel);
        }
        mapActivity.registerMapView(this);
    }

    public MapController getController() {
        return this.mapController;
    }

    public DebugSettings getDebugSettings() {
        return this.debugSettings;
    }

    public TileCache getFileSystemTileCache() {
        return this.fileSystemTileCache;
    }

    public FpsCounter getFpsCounter() {
        return this.fpsCounter;
    }

    public FrameBuffer getFrameBuffer() {
        return this.frameBuffer;
    }

    public TileCache getInMemoryTileCache() {
        return this.inMemoryTileCache;
    }

    public JobQueue getJobQueue() {
        return this.jobQueue;
    }

    public MapDatabase getMapDatabase() {
        if (this.mapGenerator.requiresInternetConnection()) {
            throw new UnsupportedOperationException();
        }
        return this.mapDatabase;
    }

    public File getMapFile() {
        if (this.mapGenerator.requiresInternetConnection()) {
            throw new UnsupportedOperationException();
        }
        return this.mapFile;
    }

    public MapGenerator getMapGenerator() {
        return this.mapGenerator;
    }

    public MapMover getMapMover() {
        return this.mapMover;
    }

    public MapViewPosition getMapPosition() {
        return this.mapViewPosition;
    }

    public MapScaleBar getMapScaleBar() {
        return this.mapScaleBar;
    }

    public MapZoomControls getMapZoomControls() {
        return this.mapZoomControls;
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void invalidateOnUiThread() {
        if (AndroidUtils.currentThreadIsUiThread()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    public boolean isZoomAnimatorRunning() {
        return this.zoomAnimator.isExecuting();
    }

    public boolean onKeyDown(int keyCode, KeyEvent keyEvent) {
        return this.mapMover.onKeyDown(keyCode, keyEvent);
    }

    public boolean onKeyUp(int keyCode, KeyEvent keyEvent) {
        return this.mapMover.onKeyUp(keyCode, keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int action = this.touchEventHandler.getAction(motionEvent);
        this.mapZoomControls.onMapViewTouchEvent(action);
        return this.touchEventHandler.handleTouchEvent(motionEvent);
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return this.mapMover.onTrackballEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawTiles() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        List<Overlay> list = this.overlays;
        synchronized (list) {
            int n = this.overlays.size();
            for (int i = 0; i < n; ++i) {
                this.overlays.get(i).requestRedraw();
            }
        }
        MapPosition mapPosition = this.mapViewPosition.getMapPosition();
        if (mapPosition == null) {
            return;
        }
        GeoPoint geoPoint = mapPosition.geoPoint;
        double pixelLeft = MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), mapPosition.zoomLevel);
        double pixelTop = MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), mapPosition.zoomLevel);
        long tileLeft = MercatorProjection.pixelXToTileX(pixelLeft -= (double)(this.getWidth() >> 1), mapPosition.zoomLevel);
        long tileTop = MercatorProjection.pixelYToTileY(pixelTop -= (double)(this.getHeight() >> 1), mapPosition.zoomLevel);
        long tileRight = MercatorProjection.pixelXToTileX(pixelLeft + (double)this.getWidth(), mapPosition.zoomLevel);
        long tileBottom = MercatorProjection.pixelYToTileY(pixelTop + (double)this.getHeight(), mapPosition.zoomLevel);
        Object cacheId = this.mapGenerator.requiresInternetConnection() ? ((TileDownloader)this.mapGenerator).getHostName() : this.mapFile;
        for (long tileY = tileTop; tileY <= tileBottom; ++tileY) {
            for (long tileX = tileLeft; tileX <= tileRight; ++tileX) {
                Bitmap bitmap;
                Tile tile = new Tile(tileX, tileY, mapPosition.zoomLevel);
                MapGeneratorJob mapGeneratorJob = new MapGeneratorJob(tile, cacheId, this.jobParameters, this.debugSettings);
                if (this.inMemoryTileCache.containsKey(mapGeneratorJob)) {
                    bitmap = this.inMemoryTileCache.get(mapGeneratorJob);
                    this.frameBuffer.drawBitmap(mapGeneratorJob.tile, bitmap);
                    continue;
                }
                if (this.fileSystemTileCache.containsKey(mapGeneratorJob)) {
                    bitmap = this.fileSystemTileCache.get(mapGeneratorJob);
                    if (bitmap != null) {
                        this.frameBuffer.drawBitmap(mapGeneratorJob.tile, bitmap);
                        this.inMemoryTileCache.put(mapGeneratorJob, bitmap);
                        continue;
                    }
                    this.jobQueue.addJob(mapGeneratorJob);
                    continue;
                }
                this.jobQueue.addJob(mapGeneratorJob);
            }
        }
        if (this.mapScaleBar.isShowMapScaleBar()) {
            this.mapScaleBar.redrawScaleBar();
        }
        this.invalidateOnUiThread();
        this.jobQueue.requestSchedule();
        MapWorker mapWorker = this.mapWorker;
        synchronized (mapWorker) {
            this.mapWorker.notify();
        }
    }

    public void setBuiltInZoomControls(boolean showZoomControls) {
        this.mapZoomControls.setShowMapZoomControls(showZoomControls);
    }

    public void setCenter(GeoPoint geoPoint) {
        MapPosition mapPosition = new MapPosition(geoPoint, this.mapViewPosition.getZoomLevel());
        this.setCenterAndZoom(mapPosition);
    }

    public void setDebugSettings(DebugSettings debugSettings) {
        this.debugSettings = debugSettings;
        this.clearAndRedrawMapView();
    }

    public FileOpenResult setMapFile(File mapFile) {
        if (this.mapGenerator.requiresInternetConnection()) {
            throw new UnsupportedOperationException();
        }
        if (mapFile == null) {
            throw new IllegalArgumentException("mapFile must not be null");
        }
        if (mapFile.equals(this.mapFile)) {
            return FileOpenResult.SUCCESS;
        }
        this.zoomAnimator.pause();
        this.mapWorker.pause();
        this.mapMover.pause();
        this.zoomAnimator.awaitPausing();
        this.mapMover.awaitPausing();
        this.mapWorker.awaitPausing();
        this.mapMover.stopMove();
        this.jobQueue.clear();
        this.zoomAnimator.proceed();
        this.mapWorker.proceed();
        this.mapMover.proceed();
        this.mapDatabase.closeFile();
        FileOpenResult fileOpenResult = this.mapDatabase.openFile(mapFile);
        if (fileOpenResult.isSuccess()) {
            Byte startZoomLevel;
            this.mapFile = mapFile;
            GeoPoint startPoint = this.mapGenerator.getStartPoint();
            if (startPoint != null) {
                this.mapViewPosition.setMapCenter(startPoint);
            }
            if ((startZoomLevel = this.mapGenerator.getStartZoomLevel()) != null) {
                this.mapViewPosition.setZoomLevel(startZoomLevel);
            }
            this.clearAndRedrawMapView();
            return FileOpenResult.SUCCESS;
        }
        this.mapFile = null;
        this.clearAndRedrawMapView();
        return fileOpenResult;
    }

    public void setMapGenerator(MapGenerator mapGenerator) {
        if (this.mapGenerator != mapGenerator) {
            this.setMapGeneratorInternal(mapGenerator);
            this.clearAndRedrawMapView();
        }
    }

    public void setRenderTheme(File renderThemeFile) throws FileNotFoundException {
        if (renderThemeFile == null) {
            throw new IllegalArgumentException("render theme file must not be null");
        }
        if (this.mapGenerator.requiresInternetConnection()) {
            throw new UnsupportedOperationException();
        }
        ExternalRenderTheme jobTheme = new ExternalRenderTheme(renderThemeFile);
        this.jobParameters = new JobParameters(jobTheme, this.jobParameters.textScale);
        this.clearAndRedrawMapView();
    }

    public void setRenderTheme(InternalRenderTheme internalRenderTheme) {
        if (internalRenderTheme == null) {
            throw new IllegalArgumentException("render theme must not be null");
        }
        if (this.mapGenerator.requiresInternetConnection()) {
            throw new UnsupportedOperationException();
        }
        this.jobParameters = new JobParameters(internalRenderTheme, this.jobParameters.textScale);
        this.clearAndRedrawMapView();
    }

    public void setTextScale(float textScale) {
        this.jobParameters = new JobParameters(this.jobParameters.jobTheme, textScale);
        this.clearAndRedrawMapView();
    }

    public boolean takeScreenshot(Bitmap.CompressFormat compressFormat, int quality, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        boolean success = this.frameBuffer.compress(compressFormat, quality, outputStream);
        outputStream.close();
        return success;
    }

    public boolean zoom(byte zoomLevelDiff, float zoomStart) {
        float matrixScaleFactor;
        if (zoomLevelDiff > 0) {
            if (this.mapViewPosition.getZoomLevel() + zoomLevelDiff > this.getMaximumPossibleZoomLevel()) {
                return false;
            }
            matrixScaleFactor = 1 << zoomLevelDiff;
        } else if (zoomLevelDiff < 0) {
            if (this.mapViewPosition.getZoomLevel() + zoomLevelDiff < this.mapZoomControls.getZoomLevelMin()) {
                return false;
            }
            matrixScaleFactor = 1.0f / (float)(1 << -zoomLevelDiff);
        } else {
            matrixScaleFactor = 1.0f;
        }
        this.mapViewPosition.setZoomLevel((byte)(this.mapViewPosition.getZoomLevel() + zoomLevelDiff));
        this.mapZoomControls.onZoomLevelChange(this.mapViewPosition.getZoomLevel());
        this.zoomAnimator.setParameters(zoomStart, matrixScaleFactor, this.getWidth() >> 1, this.getHeight() >> 1);
        this.zoomAnimator.startAnimation();
        return true;
    }

    private void setMapGeneratorInternal(MapGenerator mapGenerator) {
        if (mapGenerator == null) {
            throw new IllegalArgumentException("mapGenerator must not be null");
        }
        if (mapGenerator instanceof DatabaseRenderer) {
            ((DatabaseRenderer)mapGenerator).setMapDatabase(this.mapDatabase);
        }
        this.mapGenerator = mapGenerator;
        this.mapWorker.setMapGenerator(this.mapGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        this.frameBuffer.draw(canvas);
        List<Overlay> list = this.overlays;
        synchronized (list) {
            int n = this.overlays.size();
            for (int i = 0; i < n; ++i) {
                this.overlays.get(i).draw(canvas);
            }
        }
        if (this.mapScaleBar.isShowMapScaleBar()) {
            this.mapScaleBar.draw(canvas);
        }
        if (this.fpsCounter.isShowFpsCounter()) {
            this.fpsCounter.draw(canvas);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mapZoomControls.onLayout(changed, left, top, right, bottom);
    }

    protected final void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mapZoomControls.measure(View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)Integer.MIN_VALUE));
        this.setMeasuredDimension(Math.max(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mapZoomControls.getMeasuredWidth()), Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec), this.mapZoomControls.getMeasuredHeight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.frameBuffer.destroy();
        if (width > 0 && height > 0) {
            this.frameBuffer.onSizeChanged();
            this.redrawTiles();
            List<Overlay> list = this.overlays;
            synchronized (list) {
                int n = this.overlays.size();
                for (int i = 0; i < n; ++i) {
                    this.overlays.get(i).onSizeChanged();
                }
            }
        }
    }

    void clearAndRedrawMapView() {
        this.jobQueue.clear();
        this.frameBuffer.clear();
        this.redrawTiles();
    }

    void destroy() {
        this.overlays.clear();
        this.mapMover.interrupt();
        this.mapWorker.interrupt();
        this.zoomAnimator.interrupt();
        try {
            this.mapWorker.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.frameBuffer.destroy();
        this.touchEventHandler.destroy();
        this.mapScaleBar.destroy();
        this.inMemoryTileCache.destroy();
        this.fileSystemTileCache.destroy();
        this.mapDatabase.closeFile();
    }

    byte getMaximumPossibleZoomLevel() {
        return (byte)Math.min(this.mapZoomControls.getZoomLevelMax(), this.mapGenerator.getZoomLevelMax());
    }

    boolean hasValidCenter() {
        if (!this.mapViewPosition.isValid()) {
            return false;
        }
        return this.mapGenerator.requiresInternetConnection() || this.mapDatabase.hasOpenFile() && this.mapDatabase.getMapFileInfo().boundingBox.contains(this.getMapPosition().getMapCenter());
    }

    byte limitZoomLevel(byte zoom) {
        return (byte)Math.max(Math.min(zoom, this.getMaximumPossibleZoomLevel()), this.mapZoomControls.getZoomLevelMin());
    }

    void onPause() {
        this.mapWorker.pause();
        this.mapMover.pause();
        this.zoomAnimator.pause();
    }

    void onResume() {
        this.mapWorker.proceed();
        this.mapMover.proceed();
        this.zoomAnimator.proceed();
    }

    void setCenterAndZoom(MapPosition mapPosition) {
        if (this.hasValidCenter()) {
            MapPosition mapPositionOld = this.mapViewPosition.getMapPosition();
            GeoPoint geoPointOld = mapPositionOld.geoPoint;
            GeoPoint geoPointNew = mapPosition.geoPoint;
            double oldPixelX = MercatorProjection.longitudeToPixelX(geoPointOld.getLongitude(), mapPositionOld.zoomLevel);
            double newPixelX = MercatorProjection.longitudeToPixelX(geoPointNew.getLongitude(), mapPosition.zoomLevel);
            double oldPixelY = MercatorProjection.latitudeToPixelY(geoPointOld.getLatitude(), mapPositionOld.zoomLevel);
            double newPixelY = MercatorProjection.latitudeToPixelY(geoPointNew.getLatitude(), mapPosition.zoomLevel);
            float matrixTranslateX = (float)(oldPixelX - newPixelX);
            float matrixTranslateY = (float)(oldPixelY - newPixelY);
            this.frameBuffer.matrixPostTranslate(matrixTranslateX, matrixTranslateY);
        }
        this.mapViewPosition.setMapCenterAndZoomLevel(mapPosition);
        this.mapZoomControls.onZoomLevelChange(this.mapViewPosition.getZoomLevel());
        this.redrawTiles();
    }
}

