/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MapPosition;
import org.mapsforge.v3.core.MercatorProjection;

public class MapViewPosition {
    private double latitude;
    private double longitude;
    private final MapView mapView;
    private byte zoomLevel;

    MapViewPosition(MapView mapView) {
        this.mapView = mapView;
        this.latitude = Double.NaN;
        this.longitude = Double.NaN;
        this.zoomLevel = (byte)-1;
    }

    public synchronized GeoPoint getMapCenter() {
        return new GeoPoint(this.latitude, this.longitude);
    }

    public synchronized MapPosition getMapPosition() {
        if (!this.isValid()) {
            return null;
        }
        GeoPoint geoPoint = new GeoPoint(this.latitude, this.longitude);
        return new MapPosition(geoPoint, this.zoomLevel);
    }

    public synchronized byte getZoomLevel() {
        return this.zoomLevel;
    }

    public synchronized boolean isValid() {
        if (Double.isNaN(this.latitude)) {
            return false;
        }
        if (this.latitude < -85.05112877980659) {
            return false;
        }
        if (this.latitude > 85.05112877980659) {
            return false;
        }
        if (Double.isNaN(this.longitude)) {
            return false;
        }
        if (this.longitude < -180.0) {
            return false;
        }
        return !(this.longitude > 180.0);
    }

    public synchronized void moveMap(float moveHorizontal, float moveVertical) {
        double pixelX = MercatorProjection.longitudeToPixelX(this.longitude, this.zoomLevel);
        double pixelY = MercatorProjection.latitudeToPixelY(this.latitude, this.zoomLevel);
        this.latitude = MercatorProjection.pixelYToLatitude(pixelY - (double)moveVertical, this.zoomLevel);
        this.latitude = MercatorProjection.limitLatitude(this.latitude);
        this.longitude = MercatorProjection.pixelXToLongitude(pixelX - (double)moveHorizontal, this.zoomLevel);
        this.longitude = MercatorProjection.limitLongitude(this.longitude);
    }

    synchronized void setMapCenter(GeoPoint geoPoint) {
        this.latitude = MercatorProjection.limitLatitude(geoPoint.getLatitude());
        this.longitude = MercatorProjection.limitLongitude(geoPoint.getLongitude());
    }

    synchronized void setMapCenterAndZoomLevel(MapPosition mapPosition) {
        GeoPoint geoPoint = mapPosition.geoPoint;
        this.latitude = MercatorProjection.limitLatitude(geoPoint.getLatitude());
        this.longitude = MercatorProjection.limitLongitude(geoPoint.getLongitude());
        this.zoomLevel = this.mapView.limitZoomLevel(mapPosition.zoomLevel);
    }

    synchronized void setZoomLevel(byte zoomLevel) {
        this.zoomLevel = this.mapView.limitZoomLevel(zoomLevel);
    }
}

