/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.graphics.Point;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.Projection;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MapPosition;
import org.mapsforge.v3.core.MercatorProjection;

class MapViewProjection
implements Projection {
    private static final String INVALID_MAP_VIEW_DIMENSIONS = "invalid MapView dimensions";
    private final MapView mapView;

    MapViewProjection(MapView mapView) {
        this.mapView = mapView;
    }

    @Override
    public GeoPoint fromPixels(int x, int y) {
        if (this.mapView.getWidth() <= 0 || this.mapView.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.mapView.getMapPosition().getMapPosition();
        GeoPoint geoPoint = mapPosition.geoPoint;
        double pixelX = MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), mapPosition.zoomLevel);
        double pixelY = MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), mapPosition.zoomLevel);
        return new GeoPoint(MercatorProjection.pixelYToLatitude((pixelY -= (double)(this.mapView.getHeight() >> 1)) + (double)y, mapPosition.zoomLevel), MercatorProjection.pixelXToLongitude((pixelX -= (double)(this.mapView.getWidth() >> 1)) + (double)x, mapPosition.zoomLevel));
    }

    @Override
    public int getLatitudeSpan() {
        if (this.mapView.getWidth() > 0 && this.mapView.getWidth() > 0) {
            GeoPoint top = this.fromPixels(0, 0);
            GeoPoint bottom = this.fromPixels(0, this.mapView.getHeight());
            return Math.abs(top.latitudeE6 - bottom.latitudeE6);
        }
        throw new IllegalStateException(INVALID_MAP_VIEW_DIMENSIONS);
    }

    @Override
    public int getLongitudeSpan() {
        if (this.mapView.getWidth() > 0 && this.mapView.getWidth() > 0) {
            GeoPoint left = this.fromPixels(0, 0);
            GeoPoint right = this.fromPixels(this.mapView.getWidth(), 0);
            return Math.abs(left.longitudeE6 - right.longitudeE6);
        }
        throw new IllegalStateException(INVALID_MAP_VIEW_DIMENSIONS);
    }

    @Override
    public float metersToPixels(float meters, byte zoom) {
        double latitude = this.mapView.getMapPosition().getMapCenter().getLatitude();
        double groundResolution = MercatorProjection.calculateGroundResolution(latitude, zoom);
        return (float)((double)meters * (1.0 / groundResolution));
    }

    @Override
    public Point toPixels(GeoPoint in, Point out) {
        if (this.mapView.getWidth() <= 0 || this.mapView.getHeight() <= 0) {
            return null;
        }
        MapPosition mapPosition = this.mapView.getMapPosition().getMapPosition();
        GeoPoint geoPoint = mapPosition.geoPoint;
        double pixelX = MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), mapPosition.zoomLevel);
        double pixelY = MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), mapPosition.zoomLevel);
        pixelX -= (double)(this.mapView.getWidth() >> 1);
        pixelY -= (double)(this.mapView.getHeight() >> 1);
        if (out == null) {
            return new Point((int)(MercatorProjection.longitudeToPixelX(in.getLongitude(), mapPosition.zoomLevel) - pixelX), (int)(MercatorProjection.latitudeToPixelY(in.getLatitude(), mapPosition.zoomLevel) - pixelY));
        }
        out.x = (int)(MercatorProjection.longitudeToPixelX(in.getLongitude(), mapPosition.zoomLevel) - pixelX);
        out.y = (int)(MercatorProjection.latitudeToPixelY(in.getLatitude(), mapPosition.zoomLevel) - pixelY);
        return out;
    }

    @Override
    public Point toPoint(GeoPoint in, Point out, byte zoom) {
        if (out == null) {
            return new Point((int)MercatorProjection.longitudeToPixelX(in.getLongitude(), zoom), (int)MercatorProjection.latitudeToPixelY(in.getLatitude(), zoom));
        }
        out.x = (int)MercatorProjection.longitudeToPixelX(in.getLongitude(), zoom);
        out.y = (int)MercatorProjection.latitudeToPixelY(in.getLatitude(), zoom);
        return out;
    }
}

