/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ZoomControls;
import org.mapsforge.v3.android.maps.MapView;

public class MapZoomControls {
    private static final int DEFAULT_ZOOM_CONTROLS_GRAVITY = 85;
    private static final byte DEFAULT_ZOOM_LEVEL_MAX = 22;
    private static final byte DEFAULT_ZOOM_LEVEL_MIN = 0;
    private static final int MSG_ZOOM_CONTROLS_HIDE = 0;
    private static final int ZOOM_CONTROLS_HORIZONTAL_PADDING = 5;
    private static final long ZOOM_CONTROLS_TIMEOUT = ViewConfiguration.getZoomControlsTimeout();
    private boolean gravityChanged;
    private boolean showMapZoomControls;
    private final ZoomControls zoomControls;
    private int zoomControlsGravity;
    private final Handler zoomControlsHideHandler;
    private byte zoomLevelMax;
    private byte zoomLevelMin;

    MapZoomControls(Context context, MapView mapView) {
        this.zoomControls = new ZoomControls(context);
        this.showMapZoomControls = true;
        this.zoomLevelMax = (byte)22;
        this.zoomLevelMin = 0;
        this.zoomControls.setVisibility(8);
        this.zoomControlsGravity = 85;
        this.zoomControls.setOnZoomInClickListener((View.OnClickListener)new ZoomInClickListener(mapView));
        this.zoomControls.setOnZoomOutClickListener((View.OnClickListener)new ZoomOutClickListener(mapView));
        this.zoomControlsHideHandler = new ZoomControlsHideHandler(this.zoomControls);
        int wrapContent = -2;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(wrapContent, wrapContent);
        mapView.addView((View)this.zoomControls, (ViewGroup.LayoutParams)layoutParams);
    }

    public int getZoomControlsGravity() {
        return this.zoomControlsGravity;
    }

    public byte getZoomLevelMax() {
        return this.zoomLevelMax;
    }

    public byte getZoomLevelMin() {
        return this.zoomLevelMin;
    }

    public boolean isShowMapZoomControls() {
        return this.showMapZoomControls;
    }

    public void setShowMapZoomControls(boolean showMapZoomControls) {
        this.showMapZoomControls = showMapZoomControls;
    }

    public void setZoomControlsGravity(int zoomControlsGravity) {
        if (this.zoomControlsGravity != zoomControlsGravity) {
            this.zoomControlsGravity = zoomControlsGravity;
            this.gravityChanged = true;
        }
    }

    public void setZoomLevelMax(byte zoomLevelMax) {
        if (zoomLevelMax < this.zoomLevelMin) {
            throw new IllegalArgumentException();
        }
        this.zoomLevelMax = zoomLevelMax;
    }

    public void setZoomLevelMin(byte zoomLevelMin) {
        if (zoomLevelMin > this.zoomLevelMax) {
            throw new IllegalArgumentException();
        }
        this.zoomLevelMin = zoomLevelMin;
    }

    private int calculatePositionLeft(int left, int right, int zoomControlsWidth) {
        int gravity = this.zoomControlsGravity & 7;
        switch (gravity) {
            case 3: {
                return 5;
            }
            case 1: {
                return (right - left - zoomControlsWidth) / 2;
            }
            case 5: {
                return right - left - zoomControlsWidth - 5;
            }
        }
        throw new IllegalArgumentException("unknown horizontal gravity: " + gravity);
    }

    private int calculatePositionTop(int top, int bottom, int zoomControlsHeight) {
        int gravity = this.zoomControlsGravity & 0x70;
        switch (gravity) {
            case 48: {
                return 0;
            }
            case 16: {
                return (bottom - top - zoomControlsHeight) / 2;
            }
            case 80: {
                return bottom - top - zoomControlsHeight;
            }
        }
        throw new IllegalArgumentException("unknown vertical gravity: " + gravity);
    }

    private void showZoomControls() {
        this.zoomControlsHideHandler.removeMessages(0);
        if (this.zoomControls.getVisibility() != 0) {
            this.zoomControls.show();
        }
    }

    private void showZoomControlsWithTimeout() {
        this.showZoomControls();
        this.zoomControlsHideHandler.sendEmptyMessageDelayed(0, ZOOM_CONTROLS_TIMEOUT);
    }

    int getMeasuredHeight() {
        return this.zoomControls.getMeasuredHeight();
    }

    int getMeasuredWidth() {
        return this.zoomControls.getMeasuredWidth();
    }

    void measure(int widthMeasureSpec, int heightMeasureSpec) {
        this.zoomControls.measure(widthMeasureSpec, heightMeasureSpec);
    }

    void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed && !this.gravityChanged) {
            return;
        }
        int zoomControlsWidth = this.zoomControls.getMeasuredWidth();
        int zoomControlsHeight = this.zoomControls.getMeasuredHeight();
        int positionLeft = this.calculatePositionLeft(left, right, zoomControlsWidth);
        int positionTop = this.calculatePositionTop(top, bottom, zoomControlsHeight);
        int positionRight = positionLeft + zoomControlsWidth;
        int positionBottom = positionTop + zoomControlsHeight;
        this.zoomControls.layout(positionLeft, positionTop, positionRight, positionBottom);
        this.gravityChanged = false;
    }

    void onMapViewTouchEvent(int action) {
        if (this.showMapZoomControls) {
            switch (action) {
                case 0: {
                    this.showZoomControls();
                    break;
                }
                case 3: {
                    this.showZoomControlsWithTimeout();
                    break;
                }
                case 1: {
                    this.showZoomControlsWithTimeout();
                }
            }
        }
    }

    void onZoomLevelChange(int zoomLevel) {
        boolean zoomInEnabled = zoomLevel < this.zoomLevelMax;
        boolean zoomOutEnabled = zoomLevel > this.zoomLevelMin;
        this.zoomControls.setIsZoomInEnabled(zoomInEnabled);
        this.zoomControls.setIsZoomOutEnabled(zoomOutEnabled);
    }

    private static class ZoomOutClickListener
    implements View.OnClickListener {
        private final MapView mapView;

        ZoomOutClickListener(MapView mapView) {
            this.mapView = mapView;
        }

        public void onClick(View view) {
            this.mapView.zoom((byte)-1, 1.0f);
        }
    }

    private static class ZoomInClickListener
    implements View.OnClickListener {
        private final MapView mapView;

        ZoomInClickListener(MapView mapView) {
            this.mapView = mapView;
        }

        public void onClick(View view) {
            this.mapView.zoom((byte)1, 1.0f);
        }
    }

    private static class ZoomControlsHideHandler
    extends Handler {
        private final ZoomControls zoomControls;

        ZoomControlsHideHandler(ZoomControls zoomControls) {
            this.zoomControls = zoomControls;
        }

        public void handleMessage(Message message) {
            this.zoomControls.hide();
        }
    }
}

