/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.os.SystemClock;
import org.mapsforge.v3.android.maps.inputhandling.TouchEventHandler;

class LongPressDetector
extends Thread {
    private static final String THREAD_NAME = "LongPressDetector";
    private boolean eventHandled;
    private long pressStartTime;
    private final TouchEventHandler touchEventHandler;

    LongPressDetector(TouchEventHandler touchEventHandler) {
        this.touchEventHandler = touchEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName(THREAD_NAME);
        while (!this.isInterrupted()) {
            LongPressDetector longPressDetector = this;
            synchronized (longPressDetector) {
                while (!this.isInterrupted() && this.pressStartTime == 0L) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
            if (this.isInterrupted()) break;
            longPressDetector = this;
            synchronized (longPressDetector) {
                long timeElapsed = SystemClock.uptimeMillis() - this.pressStartTime;
                while (!this.isInterrupted() && this.pressStartTime > 0L && timeElapsed < (long)this.touchEventHandler.longPressTimeout) {
                    try {
                        this.wait((long)this.touchEventHandler.longPressTimeout - timeElapsed);
                        timeElapsed = SystemClock.uptimeMillis() - this.pressStartTime;
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
            if (this.isInterrupted()) break;
            if (this.pressStartTime <= 0L) continue;
            this.eventHandled = this.touchEventHandler.forwardLongPressEvent();
            this.pressStop();
        }
    }

    boolean isEventHandled() {
        return this.eventHandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pressStart() {
        if (this.pressStartTime == 0L) {
            this.eventHandled = false;
            this.pressStartTime = SystemClock.uptimeMillis();
            LongPressDetector longPressDetector = this;
            synchronized (longPressDetector) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pressStop() {
        if (this.pressStartTime > 0L) {
            this.pressStartTime = 0L;
            LongPressDetector longPressDetector = this;
            synchronized (longPressDetector) {
                this.notify();
            }
        }
    }
}

