/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.PausableThread;

public class MapMover
extends PausableThread
implements KeyEvent.Callback {
    private static final int DEFAULT_MOVE_SPEED_FACTOR = 10;
    private static final int FRAME_LENGTH_IN_MS = 15;
    private static final float MOVE_SPEED = 0.2f;
    private static final String THREAD_NAME = "MapMover";
    private static final float TRACKBALL_MOVE_SPEED_FACTOR = 40.0f;
    private final MapView mapView;
    private float moveSpeedFactor;
    private float moveX;
    private float moveY;
    private long timePrevious;

    public MapMover(MapView mapView) {
        this.mapView = mapView;
        this.moveSpeedFactor = 10.0f;
    }

    public float getMoveSpeedFactor() {
        return this.moveSpeedFactor;
    }

    public boolean onKeyDown(int keyCode, KeyEvent keyEvent) {
        if (!this.mapView.isClickable()) {
            return false;
        }
        if (keyCode == 21) {
            this.moveLeft();
            return true;
        }
        if (keyCode == 22) {
            this.moveRight();
            return true;
        }
        if (keyCode == 19) {
            this.moveUp();
            return true;
        }
        if (keyCode == 20) {
            this.moveDown();
            return true;
        }
        return false;
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent keyEvent) {
        return false;
    }

    public boolean onKeyMultiple(int keyCode, int count, KeyEvent keyEvent) {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent keyEvent) {
        if (!this.mapView.isClickable()) {
            return false;
        }
        if (keyCode == 21 || keyCode == 22) {
            this.moveX = 0.0f;
            return true;
        }
        if (keyCode == 19 || keyCode == 20) {
            this.moveY = 0.0f;
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (!this.mapView.isClickable()) {
            return false;
        }
        if (motionEvent.getAction() == 2) {
            float mapMoveX = motionEvent.getX() * 40.0f * this.getMoveSpeedFactor();
            float mapMoveY = motionEvent.getY() * 40.0f * this.getMoveSpeedFactor();
            this.mapView.getFrameBuffer().matrixPostTranslate(mapMoveX, mapMoveY);
            this.mapView.getMapPosition().moveMap(mapMoveX, mapMoveY);
            this.mapView.redrawTiles();
            return true;
        }
        return false;
    }

    public void setMoveSpeedFactor(float moveSpeedFactor) {
        if (moveSpeedFactor < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.moveSpeedFactor = moveSpeedFactor;
    }

    public void stopMove() {
        this.moveX = 0.0f;
        this.moveY = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDown() {
        if (this.moveY > 0.0f) {
            this.moveY = 0.0f;
        } else if (this.moveY == 0.0f) {
            this.moveY = -0.2f * this.moveSpeedFactor;
            this.timePrevious = SystemClock.uptimeMillis();
            MapMover mapMover = this;
            synchronized (mapMover) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveLeft() {
        if (this.moveX < 0.0f) {
            this.moveX = 0.0f;
        } else if (this.moveX == 0.0f) {
            this.moveX = 0.2f * this.moveSpeedFactor;
            this.timePrevious = SystemClock.uptimeMillis();
            MapMover mapMover = this;
            synchronized (mapMover) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRight() {
        if (this.moveX > 0.0f) {
            this.moveX = 0.0f;
        } else if (this.moveX == 0.0f) {
            this.moveX = -0.2f * this.moveSpeedFactor;
            this.timePrevious = SystemClock.uptimeMillis();
            MapMover mapMover = this;
            synchronized (mapMover) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUp() {
        if (this.moveY < 0.0f) {
            this.moveY = 0.0f;
        } else if (this.moveY == 0.0f) {
            this.moveY = 0.2f * this.moveSpeedFactor;
            this.timePrevious = SystemClock.uptimeMillis();
            MapMover mapMover = this;
            synchronized (mapMover) {
                this.notify();
            }
        }
    }

    @Override
    protected void afterPause() {
        this.timePrevious = SystemClock.uptimeMillis();
    }

    @Override
    protected void doWork() throws InterruptedException {
        long timeCurrent = SystemClock.uptimeMillis();
        long timeElapsed = timeCurrent - this.timePrevious;
        this.timePrevious = timeCurrent;
        this.mapView.getFrameBuffer().matrixPostTranslate((float)timeElapsed * this.moveX, (float)timeElapsed * this.moveY);
        this.mapView.getMapPosition().moveMap((float)timeElapsed * this.moveX, (float)timeElapsed * this.moveY);
        this.mapView.redrawTiles();
        MapMover.sleep(15L);
    }

    @Override
    protected String getThreadName() {
        return THREAD_NAME;
    }

    @Override
    protected boolean hasWork() {
        return this.moveX != 0.0f || this.moveY != 0.0f;
    }
}

