/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.inputhandling.ScaleListener;
import org.mapsforge.v3.android.maps.inputhandling.TouchEventHandler;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.core.GeoPoint;

public class MultiTouchHandler
extends TouchEventHandler {
    private static final int INVALID_POINTER_ID = -1;
    private int activePointerId = -1;
    private long multiTouchDownTime;
    private final ScaleGestureDetector scaleGestureDetector;

    MultiTouchHandler(Context context, MapView mapView) {
        super(context, mapView);
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener(this.mapView));
    }

    @Override
    public int getAction(MotionEvent motionEvent) {
        return motionEvent.getAction() & 0xFF;
    }

    private boolean onActionCancel() {
        this.longPressDetector.pressStop();
        this.activePointerId = -1;
        return true;
    }

    private boolean onActionDown(MotionEvent motionEvent) {
        this.longPressDetector.pressStart();
        this.previousPositionX = motionEvent.getX();
        this.previousPositionY = motionEvent.getY();
        this.moveThresholdReached = false;
        this.activePointerId = motionEvent.getPointerId(0);
        return true;
    }

    private boolean onActionMove(MotionEvent motionEvent) {
        int pointerIndex = motionEvent.findPointerIndex(this.activePointerId);
        if (this.scaleGestureDetector.isInProgress()) {
            return true;
        }
        float moveX = motionEvent.getX(pointerIndex) - this.previousPositionX;
        float moveY = motionEvent.getY(pointerIndex) - this.previousPositionY;
        if (!this.moveThresholdReached) {
            if (Math.abs(moveX) > this.mapMoveDelta || Math.abs(moveY) > this.mapMoveDelta) {
                this.longPressDetector.pressStop();
                this.moveThresholdReached = true;
                this.previousPositionX = motionEvent.getX(pointerIndex);
                this.previousPositionY = motionEvent.getY(pointerIndex);
            }
            return true;
        }
        this.previousPositionX = motionEvent.getX(pointerIndex);
        this.previousPositionY = motionEvent.getY(pointerIndex);
        this.mapView.getFrameBuffer().matrixPostTranslate(moveX, moveY);
        this.mapView.getMapPosition().moveMap(moveX, moveY);
        this.mapView.redrawTiles();
        return true;
    }

    private boolean onActionPointerDown(MotionEvent motionEvent) {
        this.longPressDetector.pressStop();
        this.multiTouchDownTime = motionEvent.getEventTime();
        return true;
    }

    private boolean onActionPointerUp(MotionEvent motionEvent) {
        long multiTouchTime;
        this.longPressDetector.pressStop();
        int pointerIndex = (motionEvent.getAction() & 0xFF00) >> 8;
        if (motionEvent.getPointerId(pointerIndex) == this.activePointerId) {
            pointerIndex = pointerIndex == 0 ? 1 : 0;
            this.previousPositionX = motionEvent.getX(pointerIndex);
            this.previousPositionY = motionEvent.getY(pointerIndex);
            this.activePointerId = motionEvent.getPointerId(pointerIndex);
        }
        if ((multiTouchTime = motionEvent.getEventTime() - this.multiTouchDownTime) < (long)this.doubleTapTimeout) {
            this.previousEventTap = false;
            this.mapView.zoom((byte)-1, 1.0f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onActionUp(MotionEvent motionEvent) {
        this.longPressDetector.pressStop();
        int pointerIndex = motionEvent.findPointerIndex(this.activePointerId);
        this.activePointerId = -1;
        if (this.moveThresholdReached || this.longPressDetector.isEventHandled()) {
            this.previousEventTap = false;
        } else {
            if (this.previousEventTap) {
                float tapDiffX = Math.abs(motionEvent.getX(pointerIndex) - this.previousTapX);
                float tapDiffY = Math.abs(motionEvent.getY(pointerIndex) - this.previousTapY);
                long tapDiffTime = motionEvent.getEventTime() - this.previousTapTime;
                if (tapDiffX < this.doubleTapDelta && tapDiffY < this.doubleTapDelta && tapDiffTime < (long)this.doubleTapTimeout) {
                    this.previousEventTap = false;
                    this.mapView.setCenter(this.mapView.getProjection().fromPixels((int)motionEvent.getX(), (int)motionEvent.getY()));
                    this.mapView.zoom((byte)1, 1.0f);
                    return true;
                }
            } else {
                this.previousEventTap = true;
            }
            this.previousTapX = motionEvent.getX(pointerIndex);
            this.previousTapY = motionEvent.getY(pointerIndex);
            this.previousTapTime = motionEvent.getEventTime();
            GeoPoint tapPoint = this.mapView.getProjection().fromPixels((int)motionEvent.getX(pointerIndex), (int)motionEvent.getY(pointerIndex));
            List<Overlay> list = this.mapView.getOverlays();
            synchronized (list) {
                for (int i = this.mapView.getOverlays().size() - 1; i >= 0 && !this.mapView.getOverlays().get(i).onTap(tapPoint, this.mapView); --i) {
                }
            }
        }
        return true;
    }

    @Override
    boolean handleMotionEvent(MotionEvent motionEvent) {
        int action;
        if (motionEvent.getAction() != 2 || motionEvent.getPointerCount() > 1) {
            this.scaleGestureDetector.onTouchEvent(motionEvent);
        }
        if ((action = this.getAction(motionEvent)) == 0) {
            return this.onActionDown(motionEvent);
        }
        if (action == 2) {
            return this.onActionMove(motionEvent);
        }
        if (action == 1) {
            return this.onActionUp(motionEvent);
        }
        if (action == 3) {
            return this.onActionCancel();
        }
        if (action == 5) {
            return this.onActionPointerDown(motionEvent);
        }
        if (action == 6) {
            return this.onActionPointerUp(motionEvent);
        }
        return false;
    }
}

