/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.view.ScaleGestureDetector;
import org.mapsforge.v3.android.maps.MapView;

class ScaleListener
implements ScaleGestureDetector.OnScaleGestureListener {
    private float focusX;
    private float focusY;
    private final MapView mapView;
    private float scaleFactorApplied;

    ScaleListener(MapView mapView) {
        this.mapView = mapView;
    }

    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        float scaleFactor = scaleGestureDetector.getScaleFactor();
        this.scaleFactorApplied *= scaleFactor;
        this.mapView.getFrameBuffer().matrixPostScale(scaleFactor, scaleFactor, this.focusX, this.focusY);
        this.mapView.invalidateOnUiThread();
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        this.scaleFactorApplied = 1.0f;
        this.focusX = this.mapView.getWidth() >> 1;
        this.focusY = this.mapView.getHeight() >> 1;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        byte zoomLevelDiff = (byte)Math.round(Math.log(this.scaleFactorApplied) / Math.log(2.0));
        this.mapView.zoom(zoomLevelDiff, this.scaleFactorApplied);
    }
}

