/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.content.Context;
import android.view.MotionEvent;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.inputhandling.TouchEventHandler;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.core.GeoPoint;

public class SingleTouchHandler
extends TouchEventHandler {
    SingleTouchHandler(Context context, MapView mapView) {
        super(context, mapView);
    }

    @Override
    public int getAction(MotionEvent motionEvent) {
        return motionEvent.getAction();
    }

    private boolean onActionCancel() {
        this.longPressDetector.pressStop();
        return true;
    }

    private boolean onActionDown(MotionEvent motionEvent) {
        this.longPressDetector.pressStart();
        this.previousPositionX = motionEvent.getX();
        this.previousPositionY = motionEvent.getY();
        this.moveThresholdReached = false;
        return true;
    }

    private boolean onActionMove(MotionEvent motionEvent) {
        float moveX = motionEvent.getX() - this.previousPositionX;
        float moveY = motionEvent.getY() - this.previousPositionY;
        if (!this.moveThresholdReached) {
            if (Math.abs(moveX) > this.mapMoveDelta || Math.abs(moveY) > this.mapMoveDelta) {
                this.longPressDetector.pressStop();
                this.moveThresholdReached = true;
                this.previousPositionX = motionEvent.getX();
                this.previousPositionY = motionEvent.getY();
            }
            return true;
        }
        this.previousPositionX = motionEvent.getX();
        this.previousPositionY = motionEvent.getY();
        this.mapView.getFrameBuffer().matrixPostTranslate(moveX, moveY);
        this.mapView.getMapPosition().moveMap(moveX, moveY);
        this.mapView.redrawTiles();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onActionUp(MotionEvent motionEvent) {
        this.longPressDetector.pressStop();
        if (this.moveThresholdReached || this.longPressDetector.isEventHandled()) {
            this.previousEventTap = false;
        } else {
            if (this.previousEventTap) {
                float tapDiffX = Math.abs(motionEvent.getX() - this.previousTapX);
                float tapDiffY = Math.abs(motionEvent.getY() - this.previousTapY);
                long tapDiffTime = motionEvent.getEventTime() - this.previousTapTime;
                if (tapDiffX < this.doubleTapDelta && tapDiffY < this.doubleTapDelta && tapDiffTime < (long)this.doubleTapTimeout) {
                    this.previousEventTap = false;
                    this.mapView.setCenter(this.mapView.getProjection().fromPixels((int)motionEvent.getX(), (int)motionEvent.getY()));
                    this.mapView.zoom((byte)1, 1.0f);
                    return true;
                }
            } else {
                this.previousEventTap = true;
            }
            this.previousTapX = motionEvent.getX();
            this.previousTapY = motionEvent.getY();
            this.previousTapTime = motionEvent.getEventTime();
            GeoPoint tapPoint = this.mapView.getProjection().fromPixels((int)motionEvent.getX(), (int)motionEvent.getY());
            List<Overlay> list = this.mapView.getOverlays();
            synchronized (list) {
                for (int i = this.mapView.getOverlays().size() - 1; i >= 0 && !this.mapView.getOverlays().get(i).onTap(tapPoint, this.mapView); --i) {
                }
            }
        }
        return true;
    }

    @Override
    boolean handleMotionEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            return this.onActionDown(motionEvent);
        }
        if (motionEvent.getAction() == 2) {
            return this.onActionMove(motionEvent);
        }
        if (motionEvent.getAction() == 1) {
            return this.onActionUp(motionEvent);
        }
        if (motionEvent.getAction() == 3) {
            return this.onActionCancel();
        }
        return false;
    }
}

