/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.inputhandling.LongPressDetector;
import org.mapsforge.v3.android.maps.inputhandling.MultiTouchHandler;
import org.mapsforge.v3.android.maps.inputhandling.SingleTouchHandler;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.core.GeoPoint;

public abstract class TouchEventHandler {
    final float doubleTapDelta;
    final int doubleTapTimeout;
    final LongPressDetector longPressDetector;
    final int longPressTimeout;
    final float mapMoveDelta;
    final MapView mapView;
    boolean moveThresholdReached;
    boolean previousEventTap;
    float previousPositionX;
    float previousPositionY;
    long previousTapTime;
    float previousTapX;
    float previousTapY;

    public static TouchEventHandler getInstance(Context context, MapView mapView) {
        if (Integer.parseInt(Build.VERSION.SDK) < 8) {
            return new SingleTouchHandler(context, mapView);
        }
        return new MultiTouchHandler(context, mapView);
    }

    TouchEventHandler(Context context, MapView mapView) {
        this.mapView = mapView;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mapMoveDelta = viewConfiguration.getScaledTouchSlop();
        this.doubleTapDelta = viewConfiguration.getScaledDoubleTapSlop();
        this.doubleTapTimeout = ViewConfiguration.getDoubleTapTimeout();
        this.longPressTimeout = ViewConfiguration.getLongPressTimeout();
        this.longPressDetector = new LongPressDetector(this);
        this.longPressDetector.start();
    }

    public final void destroy() {
        this.longPressDetector.interrupt();
    }

    public abstract int getAction(MotionEvent var1);

    public final boolean handleTouchEvent(MotionEvent motionEvent) {
        if (!this.mapView.isClickable()) {
            return true;
        }
        motionEvent.setLocation((float)((int)motionEvent.getX()), (float)((int)motionEvent.getY()));
        return this.handleMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean forwardLongPressEvent() {
        GeoPoint longPressPoint = this.mapView.getProjection().fromPixels((int)this.previousPositionX, (int)this.previousPositionY);
        if (longPressPoint != null) {
            List<Overlay> list = this.mapView.getOverlays();
            synchronized (list) {
                for (int i = this.mapView.getOverlays().size() - 1; i >= 0; --i) {
                    if (!this.mapView.getOverlays().get(i).onLongPress(longPressPoint, this.mapView)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    abstract boolean handleMotionEvent(MotionEvent var1);
}

