/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.inputhandling;

import android.os.SystemClock;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.PausableThread;

public class ZoomAnimator
extends PausableThread {
    private static final int DEFAULT_DURATION = 250;
    private static final int FRAME_LENGTH_IN_MS = 15;
    private static final String THREAD_NAME = "ZoomAnimator";
    private boolean executeAnimation;
    private final MapView mapView;
    private float pivotX;
    private float pivotY;
    private float scaleFactorApplied;
    private long timeStart;
    private float zoomDifference;
    private float zoomEnd;
    private float zoomStart;

    public ZoomAnimator(MapView mapView) {
        this.mapView = mapView;
    }

    public boolean isExecuting() {
        return this.executeAnimation;
    }

    public void setParameters(float zoomStart, float zoomEnd, float pivotX, float pivotY) {
        this.zoomStart = zoomStart;
        this.zoomEnd = zoomEnd;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation() {
        this.zoomDifference = this.zoomEnd - this.zoomStart;
        this.scaleFactorApplied = this.zoomStart;
        this.executeAnimation = true;
        this.timeStart = SystemClock.uptimeMillis();
        ZoomAnimator zoomAnimator = this;
        synchronized (zoomAnimator) {
            this.notify();
        }
    }

    @Override
    protected void doWork() throws InterruptedException {
        long timeElapsed = SystemClock.uptimeMillis() - this.timeStart;
        float timeElapsedPercent = Math.min(1.0f, (float)timeElapsed / 250.0f);
        float currentZoom = this.zoomStart + timeElapsedPercent * this.zoomDifference;
        float scaleFactor = currentZoom / this.scaleFactorApplied;
        this.scaleFactorApplied *= scaleFactor;
        this.mapView.getFrameBuffer().matrixPostScale(scaleFactor, scaleFactor, this.pivotX, this.pivotY);
        if (timeElapsed >= 250L) {
            this.executeAnimation = false;
            this.mapView.redrawTiles();
        } else {
            this.mapView.postInvalidate();
            ZoomAnimator.sleep(15L);
        }
    }

    @Override
    protected String getThreadName() {
        return THREAD_NAME;
    }

    @Override
    protected boolean hasWork() {
        return this.executeAnimation;
    }
}

