/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import android.graphics.Bitmap;
import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.v3.android.AndroidUtils;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.android.maps.mapgenerator.TileCache;
import org.mapsforge.v3.core.IOUtils;

public class FileSystemTileCache
implements TileCache {
    private static final String CACHE_DIRECTORY = "/Android/data/org.mapsforge.android.maps/cache/";
    private static final String IMAGE_FILE_NAME_EXTENSION = ".tile";
    private static final float LOAD_FACTOR = 0.6f;
    private static final Logger LOG = Logger.getLogger(FileSystemTileCache.class.getName());
    private static final String SERIALIZATION_FILE_NAME = "cache.ser";
    private final Bitmap bitmapGet;
    private final ByteBuffer byteBuffer;
    private File cacheDirectory;
    private long cacheId;
    private int mapViewId;
    private int capacity;
    private Map<MapGeneratorJob, File> map;
    private boolean persistent;

    private static Map<MapGeneratorJob, File> createMap(final int mapCapacity) {
        int initialCapacity = (int)((float)mapCapacity / 0.6f) + 2;
        return new LinkedHashMap<MapGeneratorJob, File>(initialCapacity, 0.6f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<MapGeneratorJob, File> eldestEntry) {
                if (this.size() > mapCapacity) {
                    this.remove(eldestEntry.getKey());
                    if (!eldestEntry.getValue().delete()) {
                        eldestEntry.getValue().deleteOnExit();
                    }
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<MapGeneratorJob, File> deserializeMap(File directory) {
        Map map;
        File serializedMapFile = new File(directory, SERIALIZATION_FILE_NAME);
        if (!(serializedMapFile.exists() && serializedMapFile.isFile() && serializedMapFile.canRead())) {
            return null;
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(serializedMapFile);
            objectInputStream = new ObjectInputStream(fileInputStream);
            Map map2 = (Map)objectInputStream.readObject();
            if (!serializedMapFile.delete()) {
                serializedMapFile.deleteOnExit();
            }
            map = map2;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
            Map<MapGeneratorJob, File> map3 = null;
            IOUtils.closeQuietly(objectInputStream);
            IOUtils.closeQuietly(fileInputStream);
            return map3;
        }
        catch (ClassNotFoundException e2) {
            LOG.log(Level.SEVERE, null, e2);
            Map<MapGeneratorJob, File> map4 = null;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(objectInputStream);
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(objectInputStream);
            IOUtils.closeQuietly(fileInputStream);
            return map4;
        }
        IOUtils.closeQuietly(objectInputStream);
        IOUtils.closeQuietly(fileInputStream);
        return map;
    }

    private File createCacheDirectory() {
        String externalStorageDirectory = Environment.getExternalStorageDirectory().getAbsolutePath();
        String cacheDirectoryPath = externalStorageDirectory + CACHE_DIRECTORY + this.mapViewId;
        File file = new File(cacheDirectoryPath);
        if (!file.exists() && !file.mkdirs()) {
            LOG.log(Level.SEVERE, "could not create directory: ", file);
            file = null;
        } else if (!file.isDirectory()) {
            LOG.log(Level.SEVERE, "not a directory", file);
            file = null;
        } else if (!file.canRead()) {
            LOG.log(Level.SEVERE, "cannot read directory", file);
            file = null;
        } else if (!file.canWrite()) {
            LOG.log(Level.SEVERE, "cannot writedirectory", file);
            file = null;
        }
        return file;
    }

    private int checkCapacity(int requestedCapacity) {
        if (requestedCapacity < 0) {
            throw new IllegalArgumentException("capacity must not be negative: " + requestedCapacity);
        }
        if (AndroidUtils.applicationRunsOnAndroidEmulator()) {
            return 0;
        }
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            return 0;
        }
        this.cacheDirectory = this.createCacheDirectory();
        if (this.cacheDirectory == null) {
            return 0;
        }
        return requestedCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean serializeMap(File directory, Map<MapGeneratorJob, File> map) {
        boolean bl;
        File serializedMapFile = new File(directory, SERIALIZATION_FILE_NAME);
        if (serializedMapFile.exists() && !serializedMapFile.delete()) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(serializedMapFile);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(map);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LOG.log(Level.SEVERE, null, e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objectOutputStream);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(objectOutputStream);
            IOUtils.closeQuietly(fileOutputStream);
            return bl2;
        }
        IOUtils.closeQuietly(objectOutputStream);
        IOUtils.closeQuietly(fileOutputStream);
        return bl;
    }

    public FileSystemTileCache(int capacity, int mapViewId) {
        this.mapViewId = mapViewId;
        this.capacity = this.checkCapacity(capacity);
        if (this.capacity > 0 && this.cacheDirectory != null) {
            Map<MapGeneratorJob, File> deserializedMap = FileSystemTileCache.deserializeMap(this.cacheDirectory);
            this.map = deserializedMap == null ? FileSystemTileCache.createMap(this.capacity) : deserializedMap;
            this.byteBuffer = ByteBuffer.allocate(131072);
            this.bitmapGet = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.RGB_565);
        } else {
            this.byteBuffer = null;
            this.bitmapGet = null;
            this.map = FileSystemTileCache.createMap(0);
        }
    }

    @Override
    public synchronized boolean containsKey(MapGeneratorJob mapGeneratorJob) {
        return this.map.containsKey(mapGeneratorJob);
    }

    @Override
    public synchronized void destroy() {
        if (!this.persistent || !FileSystemTileCache.serializeMap(this.cacheDirectory, this.map)) {
            for (File file : this.map.values()) {
                if (file.delete()) continue;
                file.deleteOnExit();
            }
            this.map.clear();
            if (this.cacheDirectory != null) {
                File[] filesToDelete = this.cacheDirectory.listFiles(ImageFileNameFilter.INSTANCE);
                if (filesToDelete != null) {
                    for (File file : filesToDelete) {
                        if (file.delete()) continue;
                        file.deleteOnExit();
                    }
                }
                if (!this.cacheDirectory.delete()) {
                    this.cacheDirectory.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Bitmap get(MapGeneratorJob mapGeneratorJob) {
        Bitmap bitmap;
        if (this.capacity == 0) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            File inputFile = this.map.get(mapGeneratorJob);
            fileInputStream = new FileInputStream(inputFile);
            byte[] array = this.byteBuffer.array();
            int bytesRead = fileInputStream.read(array);
            if (bytesRead == array.length) {
                this.byteBuffer.rewind();
                this.bitmapGet.copyPixelsFromBuffer((Buffer)this.byteBuffer);
                Bitmap bitmap2 = this.bitmapGet;
                return bitmap2;
            }
            Bitmap bitmap3 = null;
            return bitmap3;
        }
        catch (FileNotFoundException e) {
            this.map.remove(mapGeneratorJob);
            bitmap = null;
            return bitmap;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
            bitmap = null;
            return bitmap;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, null, e);
            }
        }
    }

    @Override
    public synchronized int getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized boolean isPersistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(MapGeneratorJob mapGeneratorJob, Bitmap bitmap) {
        if (this.capacity == 0) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            File outputFile;
            do {
                ++this.cacheId;
            } while ((outputFile = new File(this.cacheDirectory, this.cacheId + IMAGE_FILE_NAME_EXTENSION)).exists());
            this.byteBuffer.rewind();
            bitmap.copyPixelsToBuffer((Buffer)this.byteBuffer);
            byte[] array = this.byteBuffer.array();
            fileOutputStream = new FileOutputStream(outputFile);
            fileOutputStream.write(array, 0, array.length);
            this.map.put(mapGeneratorJob, outputFile);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "external storage appears full", e);
            this.capacity = 0;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, null, e);
            }
        }
    }

    @Override
    public synchronized void setCapacity(int capacity) {
        if (this.capacity == capacity) {
            return;
        }
        this.capacity = this.checkCapacity(capacity);
        if (this.capacity != 0) {
            Map<MapGeneratorJob, File> newMap = FileSystemTileCache.createMap(this.capacity);
            if (this.map != null) {
                newMap.putAll(this.map);
            }
            this.map = newMap;
        }
    }

    @Override
    public synchronized void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    private static final class ImageFileNameFilter
    implements FilenameFilter {
        static final FilenameFilter INSTANCE = new ImageFileNameFilter();

        private ImageFileNameFilter() {
        }

        @Override
        public boolean accept(File directory, String fileName) {
            return fileName.endsWith(FileSystemTileCache.IMAGE_FILE_NAME_EXTENSION);
        }
    }
}

