/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import android.graphics.Bitmap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.android.maps.mapgenerator.TileCache;

public class InMemoryTileCache
implements TileCache {
    private static final float LOAD_FACTOR = 0.6f;
    private final List<Bitmap> bitmapPool;
    private final ByteBuffer byteBuffer;
    private final int capacity;
    private final Map<MapGeneratorJob, Bitmap> map;

    private static List<Bitmap> createBitmapPool(int poolSize) {
        ArrayList<Bitmap> bitmaps = new ArrayList<Bitmap>();
        for (int i = 0; i < poolSize; ++i) {
            Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.RGB_565);
            bitmaps.add(bitmap);
        }
        return bitmaps;
    }

    private static Map<MapGeneratorJob, Bitmap> createMap(final int mapCapacity, final List<Bitmap> bitmapPool) {
        int initialCapacity = (int)((float)mapCapacity / 0.6f) + 2;
        return new LinkedHashMap<MapGeneratorJob, Bitmap>(initialCapacity, 0.6f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<MapGeneratorJob, Bitmap> eldestEntry) {
                if (this.size() > mapCapacity) {
                    this.remove(eldestEntry.getKey());
                    bitmapPool.add(eldestEntry.getValue());
                }
                return false;
            }
        };
    }

    private static int getCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must not be negative: " + capacity);
        }
        return capacity;
    }

    public InMemoryTileCache(int capacity) {
        this.capacity = InMemoryTileCache.getCapacity(capacity);
        this.bitmapPool = InMemoryTileCache.createBitmapPool(this.capacity + 1);
        this.map = InMemoryTileCache.createMap(this.capacity, this.bitmapPool);
        this.byteBuffer = ByteBuffer.allocate(131072);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(MapGeneratorJob mapGeneratorJob) {
        Map<MapGeneratorJob, Bitmap> map = this.map;
        synchronized (map) {
            return this.map.containsKey(mapGeneratorJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<MapGeneratorJob, Bitmap> map = this.map;
        synchronized (map) {
            for (Bitmap bitmap : this.map.values()) {
                bitmap.recycle();
            }
            this.map.clear();
            for (Bitmap bitmap : this.bitmapPool) {
                bitmap.recycle();
            }
            this.bitmapPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap get(MapGeneratorJob mapGeneratorJob) {
        Map<MapGeneratorJob, Bitmap> map = this.map;
        synchronized (map) {
            return this.map.get(mapGeneratorJob);
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(MapGeneratorJob mapGeneratorJob, Bitmap bitmap) {
        if (this.capacity == 0) {
            return;
        }
        Map<MapGeneratorJob, Bitmap> map = this.map;
        synchronized (map) {
            if (this.bitmapPool.isEmpty()) {
                return;
            }
            Bitmap pooledBitmap = this.bitmapPool.remove(this.bitmapPool.size() - 1);
            this.byteBuffer.rewind();
            bitmap.copyPixelsToBuffer((Buffer)this.byteBuffer);
            this.byteBuffer.rewind();
            pooledBitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
            this.map.put(mapGeneratorJob, pooledBitmap);
        }
    }

    @Override
    public void setCapacity(int capacity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPersistent(boolean persistent) {
        throw new UnsupportedOperationException();
    }
}

