/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import java.util.PriorityQueue;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.android.maps.mapgenerator.TileScheduler;

public class JobQueue {
    private static final int INITIAL_CAPACITY = 128;
    private final MapView mapView;
    private PriorityQueue<MapGeneratorJob> priorityQueue;
    private boolean scheduleNeeded;

    public JobQueue(MapView mapView) {
        this.mapView = mapView;
        this.priorityQueue = new PriorityQueue(128);
    }

    public synchronized void addJob(MapGeneratorJob mapGeneratorJob) {
        if (!this.priorityQueue.contains(mapGeneratorJob)) {
            this.priorityQueue.offer(mapGeneratorJob);
        }
    }

    public synchronized void clear() {
        this.priorityQueue.clear();
    }

    public synchronized boolean isEmpty() {
        return this.priorityQueue.isEmpty();
    }

    public synchronized MapGeneratorJob poll() {
        if (this.scheduleNeeded) {
            this.scheduleNeeded = false;
            this.schedule();
        }
        return this.priorityQueue.poll();
    }

    public synchronized void requestSchedule() {
        this.scheduleNeeded = true;
    }

    private void schedule() {
        PriorityQueue<MapGeneratorJob> tempJobQueue = new PriorityQueue<MapGeneratorJob>(128);
        while (!this.priorityQueue.isEmpty()) {
            MapGeneratorJob mapGeneratorJob = this.priorityQueue.poll();
            double priority = TileScheduler.getPriority(mapGeneratorJob.tile, this.mapView);
            mapGeneratorJob.setPriority(priority);
            tempJobQueue.offer(mapGeneratorJob);
        }
        this.priorityQueue = tempJobQueue;
    }
}

