/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import android.util.AttributeSet;
import org.mapsforge.v3.android.maps.mapgenerator.MapGenerator;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorInternal;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.DatabaseRenderer;
import org.mapsforge.v3.android.maps.mapgenerator.tiledownloader.MapnikTileDownloader;
import org.mapsforge.v3.android.maps.mapgenerator.tiledownloader.OpenCycleMapTileDownloader;
import org.mapsforge.v3.android.maps.mapgenerator.tiledownloader.ThunderforestTileDownloader;

public final class MapGeneratorFactory {
    private static final String MAP_GENERATOR_ATTRIBUTE_NAME = "mapGenerator";

    public static MapGenerator createMapGenerator(AttributeSet attributeSet) {
        String mapGeneratorName = attributeSet.getAttributeValue(null, MAP_GENERATOR_ATTRIBUTE_NAME);
        if (mapGeneratorName == null) {
            return new DatabaseRenderer();
        }
        MapGeneratorInternal mapGeneratorInternal = MapGeneratorInternal.valueOf(mapGeneratorName);
        return MapGeneratorFactory.createMapGenerator(mapGeneratorInternal);
    }

    public static MapGenerator createMapGenerator(MapGeneratorInternal mapGeneratorInternal) {
        switch (mapGeneratorInternal) {
            case DATABASE_RENDERER: {
                return new DatabaseRenderer();
            }
            case MAPNIK: {
                return new MapnikTileDownloader();
            }
            case OPENCYCLEMAP: {
                return new OpenCycleMapTileDownloader();
            }
            case THUNDERFOREST: {
                return new ThunderforestTileDownloader();
            }
        }
        throw new IllegalArgumentException("unknown enum value: " + (Object)((Object)mapGeneratorInternal));
    }

    private MapGeneratorFactory() {
        throw new IllegalStateException();
    }
}

