/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.mapsforge.v3.android.maps.DebugSettings;
import org.mapsforge.v3.android.maps.mapgenerator.JobParameters;
import org.mapsforge.v3.core.Tile;

public class MapGeneratorJob
implements Comparable<MapGeneratorJob>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final DebugSettings debugSettings;
    public final JobParameters jobParameters;
    public final Tile tile;
    private transient int hashCodeValue;
    private final Object mapGeneratorId;
    private transient double priority;

    public MapGeneratorJob(Tile tile, Object mapGeneratorId, JobParameters jobParameters, DebugSettings debugSettings) {
        this.tile = tile;
        this.mapGeneratorId = mapGeneratorId;
        this.jobParameters = jobParameters;
        this.debugSettings = debugSettings;
        this.calculateTransientValues();
    }

    @Override
    public int compareTo(MapGeneratorJob otherMapGeneratorJob) {
        if (this.priority < otherMapGeneratorJob.priority) {
            return -1;
        }
        if (this.priority > otherMapGeneratorJob.priority) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapGeneratorJob)) {
            return false;
        }
        MapGeneratorJob other = (MapGeneratorJob)obj;
        if (this.debugSettings == null ? other.debugSettings != null : !this.debugSettings.equals(other.debugSettings)) {
            return false;
        }
        if (this.jobParameters == null ? other.jobParameters != null : !this.jobParameters.equals(other.jobParameters)) {
            return false;
        }
        if (this.mapGeneratorId == null ? other.mapGeneratorId != null : !this.mapGeneratorId.equals(other.mapGeneratorId)) {
            return false;
        }
        return !(this.tile == null ? other.tile != null : !this.tile.equals(other.tile));
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    private int calculateHashCode() {
        int result = 1;
        result = 31 * result + (this.debugSettings == null ? 0 : this.debugSettings.hashCode());
        result = 31 * result + (this.jobParameters == null ? 0 : this.jobParameters.hashCode());
        result = 31 * result + (this.mapGeneratorId == null ? 0 : this.mapGeneratorId.hashCode());
        result = 31 * result + (this.tile == null ? 0 : this.tile.hashCode());
        return result;
    }

    private void calculateTransientValues() {
        this.hashCodeValue = this.calculateHashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.calculateTransientValues();
    }

    void setPriority(double priority) {
        this.priority = priority;
    }
}

