/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import android.graphics.Bitmap;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.PausableThread;
import org.mapsforge.v3.android.maps.mapgenerator.JobQueue;
import org.mapsforge.v3.android.maps.mapgenerator.MapGenerator;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.android.maps.mapgenerator.TileCache;

public class MapWorker
extends PausableThread {
    private static final String THREAD_NAME = "MapWorker";
    private final TileCache fileSystemTileCache;
    private final TileCache inMemoryTileCache;
    private final JobQueue jobQueue;
    private MapGenerator mapGenerator;
    private final MapView mapView;
    private final Bitmap tileBitmap;

    public MapWorker(MapView mapView) {
        this.mapView = mapView;
        this.jobQueue = mapView.getJobQueue();
        this.inMemoryTileCache = mapView.getInMemoryTileCache();
        this.fileSystemTileCache = mapView.getFileSystemTileCache();
        this.tileBitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    public void setMapGenerator(MapGenerator mapGenerator) {
        this.mapGenerator = mapGenerator;
    }

    @Override
    protected void afterRun() {
        this.tileBitmap.recycle();
    }

    @Override
    protected void doWork() {
        MapGeneratorJob mapGeneratorJob = this.jobQueue.poll();
        if (this.inMemoryTileCache.containsKey(mapGeneratorJob)) {
            return;
        }
        if (this.fileSystemTileCache.containsKey(mapGeneratorJob)) {
            return;
        }
        boolean success = this.mapGenerator.executeJob(mapGeneratorJob, this.tileBitmap);
        if (!this.isInterrupted() && success) {
            if (this.mapView.getFrameBuffer().drawBitmap(mapGeneratorJob.tile, this.tileBitmap)) {
                this.inMemoryTileCache.put(mapGeneratorJob, this.tileBitmap);
            }
            this.mapView.postInvalidate();
            this.fileSystemTileCache.put(mapGeneratorJob, this.tileBitmap);
        }
    }

    @Override
    protected String getThreadName() {
        return THREAD_NAME;
    }

    @Override
    protected int getThreadPriority() {
        return 3;
    }

    @Override
    protected boolean hasWork() {
        return !this.jobQueue.isEmpty();
    }
}

