/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator;

import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MapPosition;
import org.mapsforge.v3.core.MercatorProjection;
import org.mapsforge.v3.core.Tile;

final class TileScheduler {
    private static final int ZOOM_LEVEL_PENALTY = 5;

    static double getPriority(Tile tile, MapView mapView) {
        byte tileZoomLevel = tile.zoomLevel;
        long tileCenterPixelX = tile.getPixelX() + 128L;
        long tileCenterPixelY = tile.getPixelY() + 128L;
        double tileCenterLongitude = MercatorProjection.pixelXToLongitude(tileCenterPixelX, tileZoomLevel);
        double tileCenterLatitude = MercatorProjection.pixelYToLatitude(tileCenterPixelY, tileZoomLevel);
        MapPosition mapPosition = mapView.getMapPosition().getMapPosition();
        GeoPoint geoPoint = mapPosition.geoPoint;
        double longitudeDiff = geoPoint.getLongitude() - tileCenterLongitude;
        double latitudeDiff = geoPoint.getLatitude() - tileCenterLatitude;
        double euclidianDistance = Math.sqrt(longitudeDiff * longitudeDiff + latitudeDiff * latitudeDiff);
        if (mapPosition.zoomLevel == tileZoomLevel) {
            return euclidianDistance;
        }
        int zoomLevelDiff = Math.abs(mapPosition.zoomLevel - tileZoomLevel);
        double scaleFactor = Math.pow(2.0, zoomLevelDiff);
        double scaledEuclidianDistance = mapPosition.zoomLevel < tileZoomLevel ? euclidianDistance * scaleFactor : euclidianDistance / scaleFactor;
        double zoomLevelPenalty = zoomLevelDiff * 5;
        return scaledEuclidianDistance * zoomLevelPenalty;
    }

    private TileScheduler() {
        throw new IllegalStateException();
    }
}

