/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Typeface;
import java.util.List;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.CircleContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.PointTextContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.ShapePaintContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.SymbolContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.WayContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.WayTextContainer;
import org.mapsforge.v3.core.Tile;

class CanvasRasterer {
    private static final Paint PAINT_BITMAP_FILTER = new Paint(2);
    private static final Paint PAINT_TILE_COORDINATES = new Paint(1);
    private static final Paint PAINT_TILE_COORDINATES_STROKE = new Paint(1);
    private static final Paint PAINT_TILE_FRAME = new Paint(1);
    private static final float[] TILE_FRAME = new float[]{0.0f, 0.0f, 0.0f, 256.0f, 0.0f, 256.0f, 256.0f, 256.0f, 256.0f, 256.0f, 256.0f, 0.0f};
    private final Canvas canvas = new Canvas();
    private final Path path;
    private final Matrix symbolMatrix = new Matrix();

    private static void configurePaints() {
        PAINT_TILE_COORDINATES.setTypeface(Typeface.defaultFromStyle((int)1));
        PAINT_TILE_COORDINATES.setTextSize(20.0f);
        PAINT_TILE_COORDINATES_STROKE.setTypeface(Typeface.defaultFromStyle((int)1));
        PAINT_TILE_COORDINATES_STROKE.setStyle(Paint.Style.STROKE);
        PAINT_TILE_COORDINATES_STROKE.setStrokeWidth(5.0f);
        PAINT_TILE_COORDINATES_STROKE.setTextSize(20.0f);
        PAINT_TILE_COORDINATES_STROKE.setColor(-1);
    }

    CanvasRasterer() {
        this.path = new Path();
        this.path.setFillType(Path.FillType.EVEN_ODD);
        CanvasRasterer.configurePaints();
    }

    private void drawTileCoordinate(String string, int offsetY) {
        this.canvas.drawText(string, 20.0f, (float)offsetY, PAINT_TILE_COORDINATES_STROKE);
        this.canvas.drawText(string, 20.0f, (float)offsetY, PAINT_TILE_COORDINATES);
    }

    void drawNodes(List<PointTextContainer> pointTextContainers) {
        for (int index = pointTextContainers.size() - 1; index >= 0; --index) {
            PointTextContainer pointTextContainer = pointTextContainers.get(index);
            if (pointTextContainer.paintBack != null) {
                this.canvas.drawText(pointTextContainer.text, pointTextContainer.x, pointTextContainer.y, pointTextContainer.paintBack);
            }
            this.canvas.drawText(pointTextContainer.text, pointTextContainer.x, pointTextContainer.y, pointTextContainer.paintFront);
        }
    }

    void drawSymbols(List<SymbolContainer> symbolContainers) {
        for (int index = symbolContainers.size() - 1; index >= 0; --index) {
            SymbolContainer symbolContainer = symbolContainers.get(index);
            if (symbolContainer.alignCenter) {
                int pivotX = symbolContainer.symbol.getWidth() >> 1;
                int pivotY = symbolContainer.symbol.getHeight() >> 1;
                this.symbolMatrix.setRotate(symbolContainer.rotation, (float)pivotX, (float)pivotY);
                this.symbolMatrix.postTranslate(symbolContainer.x - (float)pivotX, symbolContainer.y - (float)pivotY);
            } else {
                this.symbolMatrix.setRotate(symbolContainer.rotation);
                this.symbolMatrix.postTranslate(symbolContainer.x, symbolContainer.y);
            }
            this.canvas.drawBitmap(symbolContainer.symbol, this.symbolMatrix, PAINT_BITMAP_FILTER);
        }
    }

    void drawTileCoordinates(Tile tile) {
        this.drawTileCoordinate("X: " + tile.tileX, 30);
        this.drawTileCoordinate("Y: " + tile.tileY, 60);
        this.drawTileCoordinate("Z: " + tile.zoomLevel, 90);
    }

    void drawTileFrame() {
        this.canvas.drawLines(TILE_FRAME, PAINT_TILE_FRAME);
    }

    void drawWayNames(List<WayTextContainer> wayTextContainers) {
        for (int index = wayTextContainers.size() - 1; index >= 0; --index) {
            WayTextContainer wayTextContainer = wayTextContainers.get(index);
            this.path.rewind();
            float[] textCoordinates = wayTextContainer.coordinates;
            this.path.moveTo(textCoordinates[0], textCoordinates[1]);
            for (int i = 2; i < textCoordinates.length; i += 2) {
                this.path.lineTo(textCoordinates[i], textCoordinates[i + 1]);
            }
            this.canvas.drawTextOnPath(wayTextContainer.text, this.path, 0.0f, 3.0f, wayTextContainer.paint);
        }
    }

    void drawWays(List<List<List<ShapePaintContainer>>> drawWays) {
        int levelsPerLayer = drawWays.get(0).size();
        int layers = drawWays.size();
        for (int layer = 0; layer < layers; ++layer) {
            List<List<ShapePaintContainer>> shapePaintContainers = drawWays.get(layer);
            for (int level = 0; level < levelsPerLayer; ++level) {
                List<ShapePaintContainer> wayList = shapePaintContainers.get(level);
                for (int index = wayList.size() - 1; index >= 0; --index) {
                    ShapePaintContainer shapePaintContainer = wayList.get(index);
                    this.path.rewind();
                    switch (shapePaintContainer.shapeContainer.getShapeType()) {
                        case CIRCLE: {
                            CircleContainer circleContainer = (CircleContainer)shapePaintContainer.shapeContainer;
                            this.path.addCircle(circleContainer.x, circleContainer.y, circleContainer.radius, Path.Direction.CCW);
                            break;
                        }
                        case WAY: {
                            WayContainer wayContainer = (WayContainer)shapePaintContainer.shapeContainer;
                            float[][] coordinates = wayContainer.coordinates;
                            for (int j = 0; j < coordinates.length; ++j) {
                                if (coordinates[j].length <= 2) continue;
                                this.path.moveTo(coordinates[j][0], coordinates[j][1]);
                                for (int i = 2; i < coordinates[j].length; i += 2) {
                                    this.path.lineTo(coordinates[j][i], coordinates[j][i + 1]);
                                }
                            }
                            break;
                        }
                    }
                    this.canvas.drawPath(this.path, shapePaintContainer.paint);
                }
            }
        }
    }

    void fill(int color) {
        this.canvas.drawColor(color);
    }

    void setCanvasBitmap(Bitmap bitmap) {
        this.canvas.setBitmap(bitmap);
    }
}

