/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

import android.graphics.Bitmap;
import android.graphics.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.mapsforge.v3.android.maps.mapgenerator.JobTheme;
import org.mapsforge.v3.android.maps.mapgenerator.MapGenerator;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.CanvasRasterer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.CircleContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.GeometryUtils;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.LabelPlacement;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.PointTextContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.ShapeContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.ShapePaintContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.SymbolContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.WayContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.WayDecorator;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.WayTextContainer;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderTheme;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.MercatorProjection;
import org.mapsforge.v3.core.Tag;
import org.mapsforge.v3.core.Tile;
import org.mapsforge.v3.map.reader.MapDatabase;
import org.mapsforge.v3.map.reader.MapDatabaseCallback;
import org.mapsforge.v3.map.reader.header.MapFileInfo;
import org.xml.sax.SAXException;

public class DatabaseRenderer
implements MapGenerator,
RenderCallback,
MapDatabaseCallback {
    private static final Byte DEFAULT_START_ZOOM_LEVEL = 12;
    private static final byte LAYERS = 11;
    private static final Logger LOG = Logger.getLogger(DatabaseRenderer.class.getName());
    private static final Paint PAINT_WATER_TILE_HIGHTLIGHT = new Paint(1);
    private static final double STROKE_INCREASE = 1.5;
    private static final byte STROKE_MIN_ZOOM_LEVEL = 12;
    private static final Tag TAG_NATURAL_WATER = new Tag("natural", "water");
    private static final float[][] WATER_TILE_COORDINATES = new float[][]{{0.0f, 0.0f, 256.0f, 0.0f, 256.0f, 256.0f, 0.0f, 256.0f, 0.0f, 0.0f}};
    private static final byte ZOOM_MAX = 22;
    private final List<PointTextContainer> areaLabels;
    private final CanvasRasterer canvasRasterer = new CanvasRasterer();
    private float[][] coordinates;
    private Tile currentTile;
    private List<List<ShapePaintContainer>> drawingLayer;
    private final LabelPlacement labelPlacement = new LabelPlacement();
    private MapDatabase mapDatabase;
    private List<PointTextContainer> nodes;
    private final List<SymbolContainer> pointSymbols;
    private float poiX;
    private float poiY;
    private JobTheme previousJobTheme;
    private float previousTextScale;
    private byte previousZoomLevel;
    private RenderTheme renderTheme;
    private ShapeContainer shapeContainer;
    private final List<Tag> tagList;
    private final List<WayTextContainer> wayNames;
    private final List<List<List<ShapePaintContainer>>> ways = new ArrayList<List<List<ShapePaintContainer>>>(11);
    private final List<SymbolContainer> waySymbols;

    private static RenderTheme getRenderTheme(JobTheme jobTheme) {
        try {
            return RenderThemeHandler.getRenderTheme(jobTheme);
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.SEVERE, null, e);
        }
        catch (SAXException e) {
            LOG.log(Level.SEVERE, null, e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
        }
        return null;
    }

    private static byte getValidLayer(byte layer) {
        if (layer < 0) {
            return 0;
        }
        if (layer >= 11) {
            return 10;
        }
        return layer;
    }

    public DatabaseRenderer() {
        this.wayNames = new ArrayList<WayTextContainer>(64);
        this.nodes = new ArrayList<PointTextContainer>(64);
        this.areaLabels = new ArrayList<PointTextContainer>(64);
        this.waySymbols = new ArrayList<SymbolContainer>(64);
        this.pointSymbols = new ArrayList<SymbolContainer>(64);
        this.tagList = new ArrayList<Tag>(2);
        PAINT_WATER_TILE_HIGHTLIGHT.setStyle(Paint.Style.FILL);
        PAINT_WATER_TILE_HIGHTLIGHT.setColor(-16711681);
    }

    @Override
    public void cleanup() {
        if (this.renderTheme != null) {
            this.renderTheme.destroy();
        }
    }

    @Override
    public boolean executeJob(MapGeneratorJob mapGeneratorJob, Bitmap bitmap) {
        float textScale;
        byte zoomLevel;
        this.currentTile = mapGeneratorJob.tile;
        JobTheme jobTheme = mapGeneratorJob.jobParameters.jobTheme;
        if (!jobTheme.equals(this.previousJobTheme)) {
            this.renderTheme = DatabaseRenderer.getRenderTheme(jobTheme);
            if (this.renderTheme == null) {
                this.previousJobTheme = null;
                return false;
            }
            this.createWayLists();
            this.previousJobTheme = jobTheme;
            this.previousZoomLevel = (byte)-128;
        }
        if ((zoomLevel = this.currentTile.zoomLevel) != this.previousZoomLevel) {
            this.setScaleStrokeWidth(zoomLevel);
            this.previousZoomLevel = zoomLevel;
        }
        if (Float.compare(textScale = mapGeneratorJob.jobParameters.textScale, this.previousTextScale) != 0) {
            this.renderTheme.scaleTextSize(textScale);
            this.previousTextScale = textScale;
        }
        if (this.mapDatabase != null) {
            this.mapDatabase.executeQuery(this.currentTile, this);
        }
        this.nodes = this.labelPlacement.placeLabels(this.nodes, this.pointSymbols, this.areaLabels, this.currentTile);
        this.canvasRasterer.setCanvasBitmap(bitmap);
        this.canvasRasterer.fill(this.renderTheme.getMapBackground());
        this.canvasRasterer.drawWays(this.ways);
        this.canvasRasterer.drawSymbols(this.waySymbols);
        this.canvasRasterer.drawSymbols(this.pointSymbols);
        this.canvasRasterer.drawWayNames(this.wayNames);
        this.canvasRasterer.drawNodes(this.nodes);
        this.canvasRasterer.drawNodes(this.areaLabels);
        if (mapGeneratorJob.debugSettings.drawTileFrames) {
            this.canvasRasterer.drawTileFrame();
        }
        if (mapGeneratorJob.debugSettings.drawTileCoordinates) {
            this.canvasRasterer.drawTileCoordinates(this.currentTile);
        }
        this.clearLists();
        return true;
    }

    @Override
    public GeoPoint getStartPoint() {
        if (this.mapDatabase != null && this.mapDatabase.hasOpenFile()) {
            MapFileInfo mapFileInfo = this.mapDatabase.getMapFileInfo();
            if (mapFileInfo.startPosition != null) {
                return mapFileInfo.startPosition;
            }
            if (mapFileInfo.mapCenter != null) {
                return mapFileInfo.mapCenter;
            }
        }
        return null;
    }

    @Override
    public Byte getStartZoomLevel() {
        if (this.mapDatabase != null && this.mapDatabase.hasOpenFile()) {
            MapFileInfo mapFileInfo = this.mapDatabase.getMapFileInfo();
            if (mapFileInfo.startZoomLevel != null) {
                return mapFileInfo.startZoomLevel;
            }
        }
        return DEFAULT_START_ZOOM_LEVEL;
    }

    @Override
    public byte getZoomLevelMax() {
        return 22;
    }

    @Override
    public void renderArea(Paint paint, int level) {
        this.drawingLayer.get(level).add(new ShapePaintContainer(this.shapeContainer, paint));
    }

    @Override
    public void renderAreaCaption(String caption, float verticalOffset, Paint paint, Paint stroke) {
        float[] centerPosition = GeometryUtils.calculateCenterOfBoundingBox(this.coordinates[0]);
        this.areaLabels.add(new PointTextContainer(caption, centerPosition[0], centerPosition[1], paint, stroke));
    }

    @Override
    public void renderAreaSymbol(Bitmap symbol) {
        float[] centerPosition = GeometryUtils.calculateCenterOfBoundingBox(this.coordinates[0]);
        this.pointSymbols.add(new SymbolContainer(symbol, centerPosition[0] - (float)(symbol.getWidth() >> 1), centerPosition[1] - (float)(symbol.getHeight() >> 1)));
    }

    @Override
    public void renderPointOfInterest(byte layer, int latitude, int longitude, List<Tag> tags) {
        this.drawingLayer = this.ways.get(DatabaseRenderer.getValidLayer(layer));
        this.poiX = this.scaleLongitude(longitude);
        this.poiY = this.scaleLatitude(latitude);
        this.renderTheme.matchNode(this, tags, this.currentTile.zoomLevel);
    }

    @Override
    public void renderPointOfInterestCaption(String caption, float verticalOffset, Paint paint, Paint stroke) {
        this.nodes.add(new PointTextContainer(caption, this.poiX, this.poiY + verticalOffset, paint, stroke));
    }

    @Override
    public void renderPointOfInterestCircle(float radius, Paint outline, int level) {
        this.drawingLayer.get(level).add(new ShapePaintContainer(new CircleContainer(this.poiX, this.poiY, radius), outline));
    }

    @Override
    public void renderPointOfInterestSymbol(Bitmap symbol) {
        this.pointSymbols.add(new SymbolContainer(symbol, this.poiX - (float)(symbol.getWidth() >> 1), this.poiY - (float)(symbol.getHeight() >> 1)));
    }

    @Override
    public void renderWaterBackground() {
        this.tagList.clear();
        this.tagList.add(TAG_NATURAL_WATER);
        this.coordinates = WATER_TILE_COORDINATES;
        this.renderTheme.matchClosedWay(this, this.tagList, this.currentTile.zoomLevel);
    }

    @Override
    public void renderWay(byte layer, float[] labelPosition, List<Tag> tags, float[][] wayNodes) {
        this.drawingLayer = this.ways.get(DatabaseRenderer.getValidLayer(layer));
        this.coordinates = wayNodes;
        for (int i = 0; i < this.coordinates.length; ++i) {
            for (int j = 0; j < this.coordinates[i].length; j += 2) {
                this.coordinates[i][j] = this.scaleLongitude(this.coordinates[i][j]);
                this.coordinates[i][j + 1] = this.scaleLatitude(this.coordinates[i][j + 1]);
            }
        }
        this.shapeContainer = new WayContainer(this.coordinates);
        if (GeometryUtils.isClosedWay(this.coordinates[0])) {
            this.renderTheme.matchClosedWay(this, tags, this.currentTile.zoomLevel);
        } else {
            this.renderTheme.matchLinearWay(this, tags, this.currentTile.zoomLevel);
        }
    }

    @Override
    public void renderWay(Paint paint, int level) {
        this.drawingLayer.get(level).add(new ShapePaintContainer(this.shapeContainer, paint));
    }

    @Override
    public void renderWaySymbol(Bitmap symbolBitmap, boolean alignCenter, boolean repeatSymbol) {
        WayDecorator.renderSymbol(symbolBitmap, alignCenter, repeatSymbol, this.coordinates, this.waySymbols);
    }

    @Override
    public void renderWayText(String textKey, Paint paint, Paint outline) {
        WayDecorator.renderText(textKey, paint, outline, this.coordinates, this.wayNames);
    }

    @Override
    public boolean requiresInternetConnection() {
        return false;
    }

    public void setMapDatabase(MapDatabase mapDatabase) {
        this.mapDatabase = mapDatabase;
    }

    private void clearLists() {
        for (int i = this.ways.size() - 1; i >= 0; --i) {
            List<List<ShapePaintContainer>> innerWayList = this.ways.get(i);
            for (int j = innerWayList.size() - 1; j >= 0; --j) {
                innerWayList.get(j).clear();
            }
        }
        this.areaLabels.clear();
        this.nodes.clear();
        this.pointSymbols.clear();
        this.wayNames.clear();
        this.waySymbols.clear();
    }

    private void createWayLists() {
        int levels = this.renderTheme.getLevels();
        this.ways.clear();
        for (int i = 10; i >= 0; i = (int)((byte)(i - 1))) {
            ArrayList innerWayList = new ArrayList(levels);
            for (int j = levels - 1; j >= 0; --j) {
                innerWayList.add(new ArrayList(0));
            }
            this.ways.add(innerWayList);
        }
    }

    private float scaleLatitude(float latitude) {
        return (float)(MercatorProjection.latitudeToPixelY((double)latitude / 1000000.0, this.currentTile.zoomLevel) - (double)this.currentTile.getPixelY());
    }

    private float scaleLongitude(float longitude) {
        return (float)(MercatorProjection.longitudeToPixelX((double)longitude / 1000000.0, this.currentTile.zoomLevel) - (double)this.currentTile.getPixelX());
    }

    private void setScaleStrokeWidth(byte zoomLevel) {
        int zoomLevelDiff = Math.max(zoomLevel - 12, 0);
        this.renderTheme.scaleStrokeWidth((float)Math.pow(1.5, zoomLevelDiff));
    }
}

