/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Rect;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.ImmutablePoint;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.LabelPlacement;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.PointTextContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.SymbolContainer;
import org.mapsforge.v3.core.Tile;

class DependencyCache {
    private DependencyOnTile currentDependencyOnTile;
    private Tile currentTile;
    final Map<Tile, DependencyOnTile> dependencyTable = new Hashtable<Tile, DependencyOnTile>(60);
    Dependency<DependencyText> depLabel;
    Rect rect1;
    Rect rect2;
    SymbolContainer smb;
    DependencyOnTile tmp;

    DependencyCache() {
    }

    private void addLabelsFromDependencyOnTile(List<PointTextContainer> labels) {
        for (int i = 0; i < this.currentDependencyOnTile.labels.size(); ++i) {
            this.depLabel = this.currentDependencyOnTile.labels.get(i);
            if (((DependencyText)this.depLabel.value).paintBack != null) {
                labels.add(new PointTextContainer(((DependencyText)this.depLabel.value).text, this.depLabel.point.pointX, this.depLabel.point.pointY, ((DependencyText)this.depLabel.value).paintFront, ((DependencyText)this.depLabel.value).paintBack));
                continue;
            }
            labels.add(new PointTextContainer(((DependencyText)this.depLabel.value).text, this.depLabel.point.pointX, this.depLabel.point.pointY, ((DependencyText)this.depLabel.value).paintFront));
        }
    }

    private void addSymbolsFromDependencyOnTile(List<SymbolContainer> symbols) {
        for (Dependency<DependencySymbol> depSmb : this.currentDependencyOnTile.symbols) {
            symbols.add(new SymbolContainer(((DependencySymbol)depSmb.value).symbol, depSmb.point.pointX, depSmb.point.pointY));
        }
    }

    private void fillDependencyLabels(List<PointTextContainer> pTC) {
        Tile left = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile right = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile up = new Tile(this.currentTile.tileX, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile down = new Tile(this.currentTile.tileX, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        Tile leftup = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile leftdown = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        Tile rightup = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile rightdown = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        for (int i = 0; i < pTC.size(); ++i) {
            DependencyOnTile linkedDep;
            PointTextContainer label = pTC.get(i);
            DependencyText toAdd = null;
            if (label.y - (float)label.boundary.height() < 0.0f && !this.dependencyTable.get((Object)up).drawn) {
                linkedDep = this.dependencyTable.get(up);
                toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y + 256.0f)));
                toAdd.addTile(up);
                if (label.x < 0.0f && !this.dependencyTable.get((Object)leftup).drawn) {
                    linkedDep = this.dependencyTable.get(leftup);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x + 256.0f, label.y + 256.0f)));
                    toAdd.addTile(leftup);
                }
                if (label.x + (float)label.boundary.width() > 256.0f && !this.dependencyTable.get((Object)rightup).drawn) {
                    linkedDep = this.dependencyTable.get(rightup);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x - 256.0f, label.y + 256.0f)));
                    toAdd.addTile(rightup);
                }
            }
            if (label.y > 256.0f && !this.dependencyTable.get((Object)down).drawn) {
                linkedDep = this.dependencyTable.get(down);
                if (toAdd == null) {
                    toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                    this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                }
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y - 256.0f)));
                toAdd.addTile(down);
                if (label.x < 0.0f && !this.dependencyTable.get((Object)leftdown).drawn) {
                    linkedDep = this.dependencyTable.get(leftdown);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x + 256.0f, label.y - 256.0f)));
                    toAdd.addTile(leftdown);
                }
                if (label.x + (float)label.boundary.width() > 256.0f && !this.dependencyTable.get((Object)rightdown).drawn) {
                    linkedDep = this.dependencyTable.get(rightdown);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x - 256.0f, label.y - 256.0f)));
                    toAdd.addTile(rightdown);
                }
            }
            if (label.x < 0.0f && !this.dependencyTable.get((Object)left).drawn) {
                linkedDep = this.dependencyTable.get(left);
                if (toAdd == null) {
                    toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                    this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                }
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x + 256.0f, label.y)));
                toAdd.addTile(left);
            }
            if (label.x + (float)label.boundary.width() > 256.0f && !this.dependencyTable.get((Object)right).drawn) {
                linkedDep = this.dependencyTable.get(right);
                if (toAdd == null) {
                    toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                    this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                }
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x - 256.0f, label.y)));
                toAdd.addTile(right);
            }
            if (label.symbol == null || toAdd != null) continue;
            if (label.symbol.y <= 0.0f && !this.dependencyTable.get((Object)up).drawn) {
                linkedDep = this.dependencyTable.get(up);
                toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y + 256.0f)));
                toAdd.addTile(up);
                if (label.symbol.x < 0.0f && !this.dependencyTable.get((Object)leftup).drawn) {
                    linkedDep = this.dependencyTable.get(leftup);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x + 256.0f, label.y + 256.0f)));
                    toAdd.addTile(leftup);
                }
                if (label.symbol.x + (float)label.symbol.symbol.getWidth() > 256.0f && !this.dependencyTable.get((Object)rightup).drawn) {
                    linkedDep = this.dependencyTable.get(rightup);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x - 256.0f, label.y + 256.0f)));
                    toAdd.addTile(rightup);
                }
            }
            if (label.symbol.y + (float)label.symbol.symbol.getHeight() >= 256.0f && !this.dependencyTable.get((Object)down).drawn) {
                linkedDep = this.dependencyTable.get(down);
                if (toAdd == null) {
                    toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                    this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                }
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y + 256.0f)));
                toAdd.addTile(up);
                if (label.symbol.x < 0.0f && !this.dependencyTable.get((Object)leftdown).drawn) {
                    linkedDep = this.dependencyTable.get(leftdown);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x + 256.0f, label.y - 256.0f)));
                    toAdd.addTile(leftdown);
                }
                if (label.symbol.x + (float)label.symbol.symbol.getWidth() > 256.0f && !this.dependencyTable.get((Object)rightdown).drawn) {
                    linkedDep = this.dependencyTable.get(rightdown);
                    linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x - 256.0f, label.y - 256.0f)));
                    toAdd.addTile(rightdown);
                }
            }
            if (label.symbol.x <= 0.0f && !this.dependencyTable.get((Object)left).drawn) {
                linkedDep = this.dependencyTable.get(left);
                if (toAdd == null) {
                    toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                    this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
                }
                linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x - 256.0f, label.y)));
                toAdd.addTile(left);
            }
            if (!(label.symbol.x + (float)label.symbol.symbol.getWidth() >= 256.0f) || this.dependencyTable.get((Object)right).drawn) continue;
            linkedDep = this.dependencyTable.get(right);
            if (toAdd == null) {
                toAdd = new DependencyText(label.paintFront, label.paintBack, label.text, label.boundary, this.currentTile);
                this.currentDependencyOnTile.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x, label.y)));
            }
            linkedDep.addText(new Dependency<DependencyText>(toAdd, new ImmutablePoint(label.x + 256.0f, label.y)));
            toAdd.addTile(right);
        }
    }

    private void fillDependencyOnTile2(List<PointTextContainer> labels, List<SymbolContainer> symbols, List<PointTextContainer> areaLabels) {
        Tile left = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile right = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile up = new Tile(this.currentTile.tileX, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile down = new Tile(this.currentTile.tileX, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        Tile leftup = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile leftdown = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        Tile rightup = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile rightdown = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        if (this.dependencyTable.get(up) == null) {
            this.dependencyTable.put(up, new DependencyOnTile());
        }
        if (this.dependencyTable.get(down) == null) {
            this.dependencyTable.put(down, new DependencyOnTile());
        }
        if (this.dependencyTable.get(left) == null) {
            this.dependencyTable.put(left, new DependencyOnTile());
        }
        if (this.dependencyTable.get(right) == null) {
            this.dependencyTable.put(right, new DependencyOnTile());
        }
        if (this.dependencyTable.get(leftdown) == null) {
            this.dependencyTable.put(leftdown, new DependencyOnTile());
        }
        if (this.dependencyTable.get(rightup) == null) {
            this.dependencyTable.put(rightup, new DependencyOnTile());
        }
        if (this.dependencyTable.get(leftup) == null) {
            this.dependencyTable.put(leftup, new DependencyOnTile());
        }
        if (this.dependencyTable.get(rightdown) == null) {
            this.dependencyTable.put(rightdown, new DependencyOnTile());
        }
        this.fillDependencyLabels(labels);
        this.fillDependencyLabels(areaLabels);
        for (SymbolContainer symbol : symbols) {
            DependencyOnTile linkedDep;
            DependencySymbol addSmb = null;
            if (symbol.y < 0.0f && !this.dependencyTable.get((Object)up).drawn) {
                linkedDep = this.dependencyTable.get(up);
                addSmb = new DependencySymbol(symbol.symbol, this.currentTile);
                this.currentDependencyOnTile.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x, symbol.y)));
                linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x, symbol.y + 256.0f)));
                addSmb.addTile(up);
                if (symbol.x < 0.0f && !this.dependencyTable.get((Object)leftup).drawn) {
                    linkedDep = this.dependencyTable.get(leftup);
                    linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x + 256.0f, symbol.y + 256.0f)));
                    addSmb.addTile(leftup);
                }
                if (symbol.x + (float)symbol.symbol.getWidth() > 256.0f && !this.dependencyTable.get((Object)rightup).drawn) {
                    linkedDep = this.dependencyTable.get(rightup);
                    linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x - 256.0f, symbol.y + 256.0f)));
                    addSmb.addTile(rightup);
                }
            }
            if (symbol.y + (float)symbol.symbol.getHeight() > 256.0f && !this.dependencyTable.get((Object)down).drawn) {
                linkedDep = this.dependencyTable.get(down);
                if (addSmb == null) {
                    addSmb = new DependencySymbol(symbol.symbol, this.currentTile);
                    this.currentDependencyOnTile.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x, symbol.y)));
                }
                linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x, symbol.y - 256.0f)));
                addSmb.addTile(down);
                if (symbol.x < 0.0f && !this.dependencyTable.get((Object)leftdown).drawn) {
                    linkedDep = this.dependencyTable.get(leftdown);
                    linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x + 256.0f, symbol.y - 256.0f)));
                    addSmb.addTile(leftdown);
                }
                if (symbol.x + (float)symbol.symbol.getWidth() > 256.0f && !this.dependencyTable.get((Object)rightdown).drawn) {
                    linkedDep = this.dependencyTable.get(rightdown);
                    linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x - 256.0f, symbol.y - 256.0f)));
                    addSmb.addTile(rightdown);
                }
            }
            if (symbol.x < 0.0f && !this.dependencyTable.get((Object)left).drawn) {
                linkedDep = this.dependencyTable.get(left);
                if (addSmb == null) {
                    addSmb = new DependencySymbol(symbol.symbol, this.currentTile);
                    this.currentDependencyOnTile.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x, symbol.y)));
                }
                linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x + 256.0f, symbol.y)));
                addSmb.addTile(left);
            }
            if (!(symbol.x + (float)symbol.symbol.getWidth() > 256.0f) || this.dependencyTable.get((Object)right).drawn) continue;
            linkedDep = this.dependencyTable.get(right);
            if (addSmb == null) {
                addSmb = new DependencySymbol(symbol.symbol, this.currentTile);
                this.currentDependencyOnTile.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x, symbol.y)));
            }
            linkedDep.addSymbol(new Dependency<DependencySymbol>(addSmb, new ImmutablePoint(symbol.x - 256.0f, symbol.y)));
            addSmb.addTile(right);
        }
    }

    private void removeOverlappingAreaLabelsWithDependencyLabels(List<PointTextContainer> areaLabels) {
        for (int i = 0; i < this.currentDependencyOnTile.labels.size(); ++i) {
            this.depLabel = this.currentDependencyOnTile.labels.get(i);
            this.rect1 = new Rect((int)this.depLabel.point.pointX, (int)(this.depLabel.point.pointY - (float)((DependencyText)this.depLabel.value).boundary.height()), (int)(this.depLabel.point.pointX + (float)((DependencyText)this.depLabel.value).boundary.width()), (int)this.depLabel.point.pointY);
            for (int x = 0; x < areaLabels.size(); ++x) {
                PointTextContainer pTC = areaLabels.get(x);
                this.rect2 = new Rect((int)pTC.x, (int)pTC.y - pTC.boundary.height(), (int)pTC.x + pTC.boundary.width(), (int)pTC.y);
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                areaLabels.remove(x);
                --x;
            }
        }
    }

    private void removeOverlappingAreaLabelsWithDependencySymbols(List<PointTextContainer> areaLabels) {
        for (Dependency<DependencySymbol> depSmb : this.currentDependencyOnTile.symbols) {
            this.rect1 = new Rect((int)depSmb.point.pointX, (int)depSmb.point.pointY, (int)depSmb.point.pointX + ((DependencySymbol)depSmb.value).symbol.getWidth(), (int)depSmb.point.pointY + ((DependencySymbol)depSmb.value).symbol.getHeight());
            for (int x = 0; x < areaLabels.size(); ++x) {
                PointTextContainer label = areaLabels.get(x);
                this.rect2 = new Rect((int)label.x, (int)(label.y - (float)label.boundary.height()), (int)(label.x + (float)label.boundary.width()), (int)label.y);
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                areaLabels.remove(x);
                --x;
            }
        }
    }

    private void removeOverlappingLabelsWithDependencyLabels(List<PointTextContainer> labels) {
        block0: for (int i = 0; i < this.currentDependencyOnTile.labels.size(); ++i) {
            for (int x = 0; x < labels.size(); ++x) {
                if (!labels.get((int)x).text.equals(((DependencyText)this.currentDependencyOnTile.labels.get((int)i).value).text) || !labels.get((int)x).paintFront.equals(((DependencyText)this.currentDependencyOnTile.labels.get((int)i).value).paintFront) || !labels.get((int)x).paintBack.equals(((DependencyText)this.currentDependencyOnTile.labels.get((int)i).value).paintBack)) continue;
                labels.remove(x);
                --i;
                continue block0;
            }
        }
    }

    private void removeOverlappingSymbolsWithDepencySymbols(List<SymbolContainer> symbols, int dis) {
        for (int x = 0; x < this.currentDependencyOnTile.symbols.size(); ++x) {
            Dependency<DependencySymbol> sym2 = this.currentDependencyOnTile.symbols.get(x);
            this.rect1 = new Rect((int)sym2.point.pointX - dis, (int)sym2.point.pointY - dis, (int)sym2.point.pointX + ((DependencySymbol)sym2.value).symbol.getWidth() + dis, (int)sym2.point.pointY + ((DependencySymbol)sym2.value).symbol.getHeight() + dis);
            for (int y = 0; y < symbols.size(); ++y) {
                SymbolContainer sym = symbols.get(y);
                this.rect2 = new Rect((int)sym.x, (int)sym.y, (int)sym.x + sym.symbol.getWidth(), (int)sym.y + sym.symbol.getHeight());
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                symbols.remove(y);
                --y;
            }
        }
    }

    private void removeOverlappingSymbolsWithDependencyLabels(List<SymbolContainer> symbols) {
        for (int i = 0; i < this.currentDependencyOnTile.labels.size(); ++i) {
            this.depLabel = this.currentDependencyOnTile.labels.get(i);
            this.rect1 = new Rect((int)this.depLabel.point.pointX, (int)(this.depLabel.point.pointY - (float)((DependencyText)this.depLabel.value).boundary.height()), (int)(this.depLabel.point.pointX + (float)((DependencyText)this.depLabel.value).boundary.width()), (int)this.depLabel.point.pointY);
            for (int x = 0; x < symbols.size(); ++x) {
                this.smb = symbols.get(x);
                this.rect2 = new Rect((int)this.smb.x, (int)this.smb.y, (int)this.smb.x + this.smb.symbol.getWidth(), (int)this.smb.y + this.smb.symbol.getHeight());
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                symbols.remove(x);
                --x;
            }
        }
    }

    void fillDependencyOnTile(List<PointTextContainer> labels, List<SymbolContainer> symbols, List<PointTextContainer> areaLabels) {
        this.currentDependencyOnTile.drawn = true;
        if (!(labels.isEmpty() && symbols.isEmpty() && areaLabels.isEmpty())) {
            this.fillDependencyOnTile2(labels, symbols, areaLabels);
        }
        if (this.currentDependencyOnTile.labels != null) {
            this.addLabelsFromDependencyOnTile(labels);
        }
        if (this.currentDependencyOnTile.symbols != null) {
            this.addSymbolsFromDependencyOnTile(symbols);
        }
    }

    void generateTileAndDependencyOnTile(Tile tile) {
        this.currentTile = new Tile(tile.tileX, tile.tileY, tile.zoomLevel);
        this.currentDependencyOnTile = this.dependencyTable.get(this.currentTile);
        if (this.currentDependencyOnTile == null) {
            this.dependencyTable.put(this.currentTile, new DependencyOnTile());
            this.currentDependencyOnTile = this.dependencyTable.get(this.currentTile);
        }
    }

    void removeAreaLabelsInAlreadyDrawnAreas(List<PointTextContainer> areaLabels) {
        Tile lefttmp = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile righttmp = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile uptmp = new Tile(this.currentTile.tileX, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile downtmp = new Tile(this.currentTile.tileX, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        this.tmp = this.dependencyTable.get(lefttmp);
        boolean left = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(righttmp);
        boolean right = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(uptmp);
        boolean up = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(downtmp);
        boolean down = this.tmp == null ? false : this.tmp.drawn;
        for (int i = 0; i < areaLabels.size(); ++i) {
            PointTextContainer label = areaLabels.get(i);
            if (up && label.y - (float)label.boundary.height() < 0.0f) {
                areaLabels.remove(i);
                --i;
                continue;
            }
            if (down && label.y > 256.0f) {
                areaLabels.remove(i);
                --i;
                continue;
            }
            if (left && label.x < 0.0f) {
                areaLabels.remove(i);
                --i;
                continue;
            }
            if (!right || !(label.x + (float)label.boundary.width() > 256.0f)) continue;
            areaLabels.remove(i);
            --i;
        }
    }

    void removeOverlappingObjectsWithDependencyOnTile(List<PointTextContainer> labels, List<PointTextContainer> areaLabels, List<SymbolContainer> symbols) {
        if (this.currentDependencyOnTile.labels != null && this.currentDependencyOnTile.labels.size() != 0) {
            this.removeOverlappingLabelsWithDependencyLabels(labels);
            this.removeOverlappingSymbolsWithDependencyLabels(symbols);
            this.removeOverlappingAreaLabelsWithDependencyLabels(areaLabels);
        }
        if (this.currentDependencyOnTile.symbols != null && this.currentDependencyOnTile.symbols.size() != 0) {
            this.removeOverlappingSymbolsWithDepencySymbols(symbols, 2);
            this.removeOverlappingAreaLabelsWithDependencySymbols(areaLabels);
        }
    }

    void removeReferencePointsFromDependencyCache(LabelPlacement.ReferencePosition[] refPos) {
        Tile lefttmp = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile righttmp = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile uptmp = new Tile(this.currentTile.tileX, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile downtmp = new Tile(this.currentTile.tileX, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        this.tmp = this.dependencyTable.get(lefttmp);
        boolean left = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(righttmp);
        boolean right = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(uptmp);
        boolean up = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(downtmp);
        boolean down = this.tmp == null ? false : this.tmp.drawn;
        for (int i = 0; i < refPos.length; ++i) {
            LabelPlacement.ReferencePosition ref = refPos[i];
            if (ref == null) continue;
            if (up && ref.y - ref.height < 0.0f) {
                refPos[i] = null;
                continue;
            }
            if (down && ref.y >= 256.0f) {
                refPos[i] = null;
                continue;
            }
            if (left && ref.x < 0.0f) {
                refPos[i] = null;
                continue;
            }
            if (!right || !(ref.x + ref.width > 256.0f)) continue;
            refPos[i] = null;
        }
        int dis = 2;
        if (this.currentDependencyOnTile != null) {
            if (this.currentDependencyOnTile.labels != null) {
                for (int i = 0; i < this.currentDependencyOnTile.labels.size(); ++i) {
                    this.depLabel = this.currentDependencyOnTile.labels.get(i);
                    this.rect1 = new Rect((int)this.depLabel.point.pointX - dis, (int)(this.depLabel.point.pointY - (float)((DependencyText)this.depLabel.value).boundary.height()) - dis, (int)(this.depLabel.point.pointX + (float)((DependencyText)this.depLabel.value).boundary.width() + (float)dis), (int)(this.depLabel.point.pointY + (float)dis));
                    for (int y = 0; y < refPos.length; ++y) {
                        if (refPos[y] == null) continue;
                        this.rect2 = new Rect((int)refPos[y].x, (int)(refPos[y].y - refPos[y].height), (int)(refPos[y].x + refPos[y].width), (int)refPos[y].y);
                        if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                        refPos[y] = null;
                    }
                }
            }
            if (this.currentDependencyOnTile.symbols != null) {
                for (Dependency<DependencySymbol> symbols2 : this.currentDependencyOnTile.symbols) {
                    this.rect1 = new Rect((int)symbols2.point.pointX, (int)symbols2.point.pointY, (int)(symbols2.point.pointX + (float)((DependencySymbol)symbols2.value).symbol.getWidth()), (int)(symbols2.point.pointY + (float)((DependencySymbol)symbols2.value).symbol.getHeight()));
                    for (int y = 0; y < refPos.length; ++y) {
                        if (refPos[y] == null) continue;
                        this.rect2 = new Rect((int)refPos[y].x, (int)(refPos[y].y - refPos[y].height), (int)(refPos[y].x + refPos[y].width), (int)refPos[y].y);
                        if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                        refPos[y] = null;
                    }
                }
            }
        }
    }

    void removeSymbolsFromDrawnAreas(List<SymbolContainer> symbols) {
        Tile lefttmp = new Tile(this.currentTile.tileX - 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile righttmp = new Tile(this.currentTile.tileX + 1L, this.currentTile.tileY, this.currentTile.zoomLevel);
        Tile uptmp = new Tile(this.currentTile.tileX, this.currentTile.tileY - 1L, this.currentTile.zoomLevel);
        Tile downtmp = new Tile(this.currentTile.tileX, this.currentTile.tileY + 1L, this.currentTile.zoomLevel);
        this.tmp = this.dependencyTable.get(lefttmp);
        boolean left = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(righttmp);
        boolean right = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(uptmp);
        boolean up = this.tmp == null ? false : this.tmp.drawn;
        this.tmp = this.dependencyTable.get(downtmp);
        boolean down = this.tmp == null ? false : this.tmp.drawn;
        for (int i = 0; i < symbols.size(); ++i) {
            SymbolContainer ref = symbols.get(i);
            if (up && ref.y < 0.0f) {
                symbols.remove(i);
                --i;
                continue;
            }
            if (down && ref.y + (float)ref.symbol.getHeight() > 256.0f) {
                symbols.remove(i);
                --i;
                continue;
            }
            if (left && ref.x < 0.0f) {
                symbols.remove(i);
                --i;
                continue;
            }
            if (!right || !(ref.x + (float)ref.symbol.getWidth() > 256.0f)) continue;
            symbols.remove(i);
            --i;
        }
    }

    private static class DependencyText {
        final Rect boundary;
        final Paint paintBack;
        final Paint paintFront;
        final String text;
        List<Tile> tiles;

        DependencyText(Paint paintFront, Paint paintBack, String text, Rect boundary, Tile tile) {
            this.paintFront = paintFront;
            this.paintBack = paintBack;
            this.text = text;
            this.tiles = new LinkedList<Tile>();
            this.tiles.add(tile);
            this.boundary = boundary;
        }

        void addTile(Tile tile) {
            this.tiles.add(tile);
        }
    }

    private static class DependencySymbol {
        private final List<Tile> tiles;
        Bitmap symbol;

        DependencySymbol(Bitmap symbol, Tile tile) {
            this.symbol = symbol;
            this.tiles = new LinkedList<Tile>();
            this.tiles.add(tile);
        }

        void addTile(Tile tile) {
            this.tiles.add(tile);
        }
    }

    private static class DependencyOnTile {
        boolean drawn = false;
        List<Dependency<DependencyText>> labels = null;
        List<Dependency<DependencySymbol>> symbols = null;

        DependencyOnTile() {
        }

        void addSymbol(Dependency<DependencySymbol> toAdd) {
            if (this.symbols == null) {
                this.symbols = new ArrayList<Dependency<DependencySymbol>>();
            }
            this.symbols.add(toAdd);
        }

        void addText(Dependency<DependencyText> toAdd) {
            if (this.labels == null) {
                this.labels = new ArrayList<Dependency<DependencyText>>();
            }
            this.labels.add(toAdd);
        }
    }

    private static class Dependency<Type> {
        ImmutablePoint point;
        final Type value;

        Dependency(Type value, ImmutablePoint point) {
            this.value = value;
            this.point = point;
        }
    }
}

