/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.mapsforge.v3.android.maps.mapgenerator.JobTheme;

public class ExternalRenderTheme
implements JobTheme {
    private static final long serialVersionUID = 1L;
    private final long fileModificationDate;
    private transient int hashCodeValue;
    private final File renderThemeFile;

    public ExternalRenderTheme(File renderThemeFile) throws FileNotFoundException {
        if (!renderThemeFile.exists()) {
            throw new FileNotFoundException("file does not exist: " + renderThemeFile);
        }
        if (!renderThemeFile.isFile()) {
            throw new FileNotFoundException("not a file: " + renderThemeFile);
        }
        if (!renderThemeFile.canRead()) {
            throw new FileNotFoundException("cannot read file: " + renderThemeFile);
        }
        this.fileModificationDate = renderThemeFile.lastModified();
        if (this.fileModificationDate == 0L) {
            throw new FileNotFoundException("cannot read last modification time");
        }
        this.renderThemeFile = renderThemeFile;
        this.calculateTransientValues();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalRenderTheme)) {
            return false;
        }
        ExternalRenderTheme other = (ExternalRenderTheme)obj;
        if (this.fileModificationDate != other.fileModificationDate) {
            return false;
        }
        if (this.renderThemeFile == null && other.renderThemeFile != null) {
            return false;
        }
        return this.renderThemeFile == null || this.renderThemeFile.equals(other.renderThemeFile);
    }

    @Override
    public String getRelativePathPrefix() {
        return this.renderThemeFile.getParent();
    }

    @Override
    public InputStream getRenderThemeAsStream() throws FileNotFoundException {
        return new FileInputStream(this.renderThemeFile);
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    private int calculateHashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fileModificationDate ^ this.fileModificationDate >>> 32);
        result = 31 * result + (this.renderThemeFile == null ? 0 : this.renderThemeFile.hashCode());
        return result;
    }

    private void calculateTransientValues() {
        this.hashCodeValue = this.calculateHashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.calculateTransientValues();
    }
}

