/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

final class GeometryUtils {
    static float[] calculateCenterOfBoundingBox(float[] coordinates) {
        float longitudeMin = coordinates[0];
        float longitudeMax = coordinates[0];
        float latitudeMax = coordinates[1];
        float latitudeMin = coordinates[1];
        for (int i = 2; i < coordinates.length; i += 2) {
            if (coordinates[i] < longitudeMin) {
                longitudeMin = coordinates[i];
            } else if (coordinates[i] > longitudeMax) {
                longitudeMax = coordinates[i];
            }
            if (coordinates[i + 1] < latitudeMin) {
                latitudeMin = coordinates[i + 1];
                continue;
            }
            if (!(coordinates[i + 1] > latitudeMax)) continue;
            latitudeMax = coordinates[i + 1];
        }
        return new float[]{(longitudeMin + longitudeMax) / 2.0f, (latitudeMax + latitudeMin) / 2.0f};
    }

    static boolean isClosedWay(float[] way) {
        return Float.compare(way[0], way[way.length - 2]) == 0 && Float.compare(way[1], way[way.length - 1]) == 0;
    }

    private GeometryUtils() {
        throw new IllegalStateException();
    }
}

