/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

class ImmutablePoint
implements Comparable<ImmutablePoint> {
    private final int hashCodeValue;
    final float pointX;
    final float pointY;

    static ImmutablePoint substract(ImmutablePoint minuend, ImmutablePoint subtrahend) {
        return new ImmutablePoint(minuend.pointX - subtrahend.pointX, minuend.pointY - subtrahend.pointY);
    }

    ImmutablePoint(float x, float y) {
        this.pointX = x;
        this.pointY = y;
        this.hashCodeValue = this.calculateHashCode();
    }

    @Override
    public int compareTo(ImmutablePoint point) {
        if (this.pointX > point.pointX) {
            return 1;
        }
        if (this.pointX < point.pointX) {
            return -1;
        }
        if (this.pointY > point.pointY) {
            return 1;
        }
        if (this.pointY < point.pointY) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutablePoint)) {
            return false;
        }
        ImmutablePoint other = (ImmutablePoint)obj;
        if (this.pointX != other.pointX) {
            return false;
        }
        return this.pointY == other.pointY;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ImmutablePoint [x=");
        stringBuilder.append(this.pointX);
        stringBuilder.append(", y=");
        stringBuilder.append(this.pointY);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + Float.floatToIntBits(this.pointX);
        result = 31 * result + Float.floatToIntBits(this.pointY);
        return result;
    }
}

