/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

import android.graphics.Rect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.DependencyCache;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.PointTextContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.SymbolContainer;
import org.mapsforge.v3.core.Tile;

class LabelPlacement {
    private static final int PLACEMENT_MODEL = 1;
    private int labelDistanceToLabel = 2;
    private int labelDistanceToSymbol = 2;
    private int startDistanceToSymbols = 4;
    private int symbolDistanceToSymbol = 2;
    final DependencyCache dependencyCache = new DependencyCache();
    PointTextContainer label;
    Rect rect1;
    Rect rect2;
    ReferencePosition referencePosition;
    SymbolContainer symbolContainer;

    LabelPlacement() {
    }

    private void centerLabels(List<PointTextContainer> labels) {
        for (int i = 0; i < labels.size(); ++i) {
            this.label = labels.get(i);
            this.label.x -= (float)(this.label.boundary.width() / 2);
        }
    }

    private void preprocessAreaLabels(List<PointTextContainer> areaLabels) {
        this.centerLabels(areaLabels);
        this.removeOutOfTileAreaLabels(areaLabels);
        this.removeOverlappingAreaLabels(areaLabels);
        if (!areaLabels.isEmpty()) {
            this.dependencyCache.removeAreaLabelsInAlreadyDrawnAreas(areaLabels);
        }
    }

    private void preprocessLabels(List<PointTextContainer> labels) {
        this.removeOutOfTileLabels(labels);
    }

    private void preprocessSymbols(List<SymbolContainer> symbols) {
        this.removeOutOfTileSymbols(symbols);
        this.removeOverlappingSymbols(symbols);
        this.dependencyCache.removeSymbolsFromDrawnAreas(symbols);
    }

    private List<PointTextContainer> processFourPointGreedy(List<PointTextContainer> labels, List<SymbolContainer> symbols, List<PointTextContainer> areaLabels) {
        ArrayList<PointTextContainer> resolutionSet = new ArrayList<PointTextContainer>();
        ReferencePosition[] refPos = new ReferencePosition[labels.size() * 4];
        PriorityQueue<ReferencePosition> priorUp = new PriorityQueue<ReferencePosition>(labels.size() * 4 * 2 + labels.size() / 10 * 2, ReferencePositionYComparator.INSTANCE);
        PriorityQueue<ReferencePosition> priorDown = new PriorityQueue<ReferencePosition>(labels.size() * 4 * 2 + labels.size() / 10 * 2, ReferencePositionHeightComparator.INSTANCE);
        int dis = this.startDistanceToSymbols;
        for (int z = 0; z < labels.size(); ++z) {
            if (labels.get(z) == null) continue;
            if (labels.get((int)z).symbol != null) {
                PointTextContainer tmp = labels.get(z);
                refPos[z * 4] = new ReferencePosition(tmp.x - (float)(tmp.boundary.width() / 2), tmp.y - (float)(tmp.symbol.symbol.getHeight() / 2) - (float)dis, z, tmp.boundary.width(), tmp.boundary.height(), tmp.symbol);
                refPos[z * 4 + 1] = new ReferencePosition(tmp.x - (float)(tmp.boundary.width() / 2), tmp.y + (float)(tmp.symbol.symbol.getHeight() / 2) + (float)tmp.boundary.height() + (float)dis, z, tmp.boundary.width(), tmp.boundary.height(), tmp.symbol);
                refPos[z * 4 + 2] = new ReferencePosition(tmp.x - (float)(tmp.symbol.symbol.getWidth() / 2) - (float)tmp.boundary.width() - (float)dis, tmp.y + (float)(tmp.boundary.height() / 2), z, tmp.boundary.width(), tmp.boundary.height(), tmp.symbol);
                refPos[z * 4 + 3] = new ReferencePosition(tmp.x + (float)(tmp.symbol.symbol.getWidth() / 2) + (float)dis, tmp.y + (float)(tmp.boundary.height() / 2) - 0.1f, z, tmp.boundary.width(), tmp.boundary.height(), tmp.symbol);
                continue;
            }
            refPos[z * 4] = new ReferencePosition(labels.get((int)z).x - (float)(labels.get((int)z).boundary.width() / 2), labels.get((int)z).y, z, labels.get((int)z).boundary.width(), labels.get((int)z).boundary.height(), null);
            refPos[z * 4 + 1] = null;
            refPos[z * 4 + 2] = null;
            refPos[z * 4 + 3] = null;
        }
        this.removeNonValidateReferencePosition(refPos, symbols, areaLabels);
        for (int i = 0; i < refPos.length; ++i) {
            this.referencePosition = refPos[i];
            if (this.referencePosition == null) continue;
            priorUp.add(this.referencePosition);
            priorDown.add(this.referencePosition);
        }
        while (priorUp.size() != 0) {
            this.referencePosition = (ReferencePosition)priorUp.remove();
            this.label = labels.get(this.referencePosition.nodeNumber);
            resolutionSet.add(new PointTextContainer(this.label.text, this.referencePosition.x, this.referencePosition.y, this.label.paintFront, this.label.paintBack, this.label.symbol));
            if (priorUp.size() == 0) {
                return resolutionSet;
            }
            priorUp.remove(refPos[this.referencePosition.nodeNumber * 4 + 0]);
            priorUp.remove(refPos[this.referencePosition.nodeNumber * 4 + 1]);
            priorUp.remove(refPos[this.referencePosition.nodeNumber * 4 + 2]);
            priorUp.remove(refPos[this.referencePosition.nodeNumber * 4 + 3]);
            priorDown.remove(refPos[this.referencePosition.nodeNumber * 4 + 0]);
            priorDown.remove(refPos[this.referencePosition.nodeNumber * 4 + 1]);
            priorDown.remove(refPos[this.referencePosition.nodeNumber * 4 + 2]);
            priorDown.remove(refPos[this.referencePosition.nodeNumber * 4 + 3]);
            LinkedList linkedRef = new LinkedList();
            while (priorDown.size() != 0 && priorDown.peek().x < this.referencePosition.x + this.referencePosition.width) {
                linkedRef.add(priorDown.remove());
            }
            for (int i = 0; i < linkedRef.size(); ++i) {
                if (!(((ReferencePosition)linkedRef.get((int)i)).x <= this.referencePosition.x + this.referencePosition.width) || !(((ReferencePosition)linkedRef.get((int)i)).y >= this.referencePosition.y - ((ReferencePosition)linkedRef.get((int)i)).height) || !(((ReferencePosition)linkedRef.get((int)i)).y <= this.referencePosition.y + ((ReferencePosition)linkedRef.get((int)i)).height)) continue;
                priorUp.remove(linkedRef.get(i));
                linkedRef.remove(i);
                --i;
            }
            priorDown.addAll(linkedRef);
        }
        return resolutionSet;
    }

    private List<PointTextContainer> processTwoPointGreedy(List<PointTextContainer> labels, List<SymbolContainer> symbols, List<PointTextContainer> areaLabels) {
        ArrayList<PointTextContainer> resolutionSet = new ArrayList<PointTextContainer>();
        ReferencePosition[] refPos = new ReferencePosition[labels.size() * 2];
        PriorityQueue<ReferencePosition> priorRight = new PriorityQueue<ReferencePosition>(labels.size() * 2 + labels.size() / 10 * 2, ReferencePositionWidthComparator.INSTANCE);
        PriorityQueue<ReferencePosition> priorLeft = new PriorityQueue<ReferencePosition>(labels.size() * 2 + labels.size() / 10 * 2, ReferencePositionXComparator.INSTANCE);
        for (int z = 0; z < labels.size(); ++z) {
            this.label = labels.get(z);
            if (this.label.symbol != null) {
                refPos[z * 2] = new ReferencePosition(this.label.x - (float)(this.label.boundary.width() / 2) - 0.1f, this.label.y - (float)this.label.boundary.height() - (float)this.startDistanceToSymbols, z, this.label.boundary.width(), this.label.boundary.height(), this.label.symbol);
                refPos[z * 2 + 1] = new ReferencePosition(this.label.x - (float)(this.label.boundary.width() / 2), this.label.y + (float)this.label.symbol.symbol.getHeight() + (float)this.startDistanceToSymbols, z, this.label.boundary.width(), this.label.boundary.height(), this.label.symbol);
                continue;
            }
            refPos[z * 2] = new ReferencePosition(this.label.x - (float)(this.label.boundary.width() / 2) - 0.1f, this.label.y, z, this.label.boundary.width(), this.label.boundary.height(), null);
            refPos[z * 2 + 1] = null;
        }
        this.removeNonValidateReferencePosition(refPos, symbols, areaLabels);
        for (int i = 0; i < refPos.length; ++i) {
            this.referencePosition = refPos[i];
            if (this.referencePosition == null) continue;
            priorLeft.add(this.referencePosition);
            priorRight.add(this.referencePosition);
        }
        while (priorRight.size() != 0) {
            this.referencePosition = (ReferencePosition)priorRight.remove();
            this.label = labels.get(this.referencePosition.nodeNumber);
            resolutionSet.add(new PointTextContainer(this.label.text, this.referencePosition.x, this.referencePosition.y, this.label.paintFront, this.label.paintBack, this.referencePosition.symbol));
            priorRight.remove(refPos[this.referencePosition.nodeNumber * 2 + 1]);
            if (priorRight.size() == 0) {
                return resolutionSet;
            }
            priorLeft.remove(this.referencePosition);
            priorLeft.remove(refPos[this.referencePosition.nodeNumber * 2 + 1]);
            LinkedList linkedRef = new LinkedList();
            while (priorLeft.size() != 0 && priorLeft.peek().x < this.referencePosition.x + this.referencePosition.width) {
                linkedRef.add(priorLeft.remove());
            }
            for (int i = 0; i < linkedRef.size(); ++i) {
                if (!(((ReferencePosition)linkedRef.get((int)i)).x <= this.referencePosition.x + this.referencePosition.width) || !(((ReferencePosition)linkedRef.get((int)i)).y >= this.referencePosition.y - ((ReferencePosition)linkedRef.get((int)i)).height) || !(((ReferencePosition)linkedRef.get((int)i)).y <= this.referencePosition.y + ((ReferencePosition)linkedRef.get((int)i)).height)) continue;
                priorRight.remove(linkedRef.get(i));
                linkedRef.remove(i);
                --i;
            }
            priorLeft.addAll(linkedRef);
        }
        return resolutionSet;
    }

    private void removeEmptySymbolReferences(List<PointTextContainer> nodes, List<SymbolContainer> symbols) {
        for (int i = 0; i < nodes.size(); ++i) {
            this.label = nodes.get(i);
            if (symbols.contains(this.label.symbol)) continue;
            this.label.symbol = null;
        }
    }

    private void removeNonValidateReferencePosition(ReferencePosition[] refPos, List<SymbolContainer> symbols, List<PointTextContainer> areaLabels) {
        int dis = this.labelDistanceToSymbol;
        for (int i = 0; i < symbols.size(); ++i) {
            this.symbolContainer = symbols.get(i);
            this.rect1 = new Rect((int)this.symbolContainer.x - dis, (int)this.symbolContainer.y - dis, (int)this.symbolContainer.x + this.symbolContainer.symbol.getWidth() + dis, (int)this.symbolContainer.y + this.symbolContainer.symbol.getHeight() + dis);
            for (int y = 0; y < refPos.length; ++y) {
                if (refPos[y] == null) continue;
                this.rect2 = new Rect((int)refPos[y].x, (int)(refPos[y].y - refPos[y].height), (int)(refPos[y].x + refPos[y].width), (int)refPos[y].y);
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                refPos[y] = null;
            }
        }
        dis = this.labelDistanceToLabel;
        for (PointTextContainer areaLabel : areaLabels) {
            this.rect1 = new Rect((int)areaLabel.x - dis, (int)areaLabel.y - areaLabel.boundary.height() - dis, (int)areaLabel.x + areaLabel.boundary.width() + dis, (int)areaLabel.y + dis);
            for (int y = 0; y < refPos.length; ++y) {
                if (refPos[y] == null) continue;
                this.rect2 = new Rect((int)refPos[y].x, (int)(refPos[y].y - refPos[y].height), (int)(refPos[y].x + refPos[y].width), (int)refPos[y].y);
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                refPos[y] = null;
            }
        }
        this.dependencyCache.removeReferencePointsFromDependencyCache(refPos);
    }

    private void removeOutOfTileAreaLabels(List<PointTextContainer> areaLabels) {
        for (int i = 0; i < areaLabels.size(); ++i) {
            this.label = areaLabels.get(i);
            if (this.label.x > 256.0f) {
                areaLabels.remove(i);
                --i;
                continue;
            }
            if (this.label.y - (float)this.label.boundary.height() > 256.0f) {
                areaLabels.remove(i);
                --i;
                continue;
            }
            if (this.label.x + (float)this.label.boundary.width() < 0.0f) {
                areaLabels.remove(i);
                --i;
                continue;
            }
            if (!(this.label.y + (float)this.label.boundary.height() < 0.0f)) continue;
            areaLabels.remove(i);
            --i;
        }
    }

    private void removeOutOfTileLabels(List<PointTextContainer> labels) {
        int i = 0;
        while (i < labels.size()) {
            this.label = labels.get(i);
            if (this.label.x - (float)(this.label.boundary.width() / 2) > 256.0f) {
                labels.remove(i);
                this.label = null;
                continue;
            }
            if (this.label.y - (float)this.label.boundary.height() > 256.0f) {
                labels.remove(i);
                this.label = null;
                continue;
            }
            if (this.label.x - (float)(this.label.boundary.width() / 2) + (float)this.label.boundary.width() < 0.0f) {
                labels.remove(i);
                this.label = null;
                continue;
            }
            if (this.label.y < 0.0f) {
                labels.remove(i);
                this.label = null;
                continue;
            }
            ++i;
        }
    }

    private void removeOutOfTileSymbols(List<SymbolContainer> symbols) {
        int i = 0;
        while (i < symbols.size()) {
            this.symbolContainer = symbols.get(i);
            if (this.symbolContainer.x > 256.0f) {
                symbols.remove(i);
                continue;
            }
            if (this.symbolContainer.y > 256.0f) {
                symbols.remove(i);
                continue;
            }
            if (this.symbolContainer.x + (float)this.symbolContainer.symbol.getWidth() < 0.0f) {
                symbols.remove(i);
                continue;
            }
            if (this.symbolContainer.y + (float)this.symbolContainer.symbol.getHeight() < 0.0f) {
                symbols.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void removeOverlappingAreaLabels(List<PointTextContainer> areaLabels) {
        int dis = this.labelDistanceToLabel;
        for (int x = 0; x < areaLabels.size(); ++x) {
            this.label = areaLabels.get(x);
            this.rect1 = new Rect((int)this.label.x - dis, (int)this.label.y - dis, (int)(this.label.x + (float)this.label.boundary.width()) + dis, (int)(this.label.y + (float)this.label.boundary.height() + (float)dis));
            for (int y = x + 1; y < areaLabels.size(); ++y) {
                if (y == x) continue;
                this.label = areaLabels.get(y);
                this.rect2 = new Rect((int)this.label.x, (int)this.label.y, (int)(this.label.x + (float)this.label.boundary.width()), (int)(this.label.y + (float)this.label.boundary.height()));
                if (!Rect.intersects((Rect)this.rect1, (Rect)this.rect2)) continue;
                areaLabels.remove(y);
                --y;
            }
        }
    }

    private void removeOverlappingSymbolsWithAreaLabels(List<SymbolContainer> symbols, List<PointTextContainer> pTC) {
        int dis = this.labelDistanceToSymbol;
        for (int x = 0; x < pTC.size(); ++x) {
            this.label = pTC.get(x);
            this.rect1 = new Rect((int)this.label.x - dis, (int)(this.label.y - (float)this.label.boundary.height()) - dis, (int)(this.label.x + (float)this.label.boundary.width() + (float)dis), (int)(this.label.y + (float)dis));
            for (int y = 0; y < symbols.size(); ++y) {
                this.symbolContainer = symbols.get(y);
                this.rect2 = new Rect((int)this.symbolContainer.x, (int)this.symbolContainer.y, (int)(this.symbolContainer.x + (float)this.symbolContainer.symbol.getWidth()), (int)(this.symbolContainer.y + (float)this.symbolContainer.symbol.getHeight()));
                if (!Rect.intersects((Rect)this.rect1, (Rect)this.rect2)) continue;
                symbols.remove(y);
                --y;
            }
        }
    }

    int getLabelDistanceToLabel() {
        return this.labelDistanceToLabel;
    }

    int getLabelDistanceToSymbol() {
        return this.labelDistanceToSymbol;
    }

    int getPlacementOption() {
        return 1;
    }

    int getStartDistanceToSymbols() {
        return this.startDistanceToSymbols;
    }

    int getSymbolDistanceToSymbol() {
        return this.symbolDistanceToSymbol;
    }

    List<PointTextContainer> placeLabels(List<PointTextContainer> labels, List<SymbolContainer> symbols, List<PointTextContainer> areaLabels, Tile cT) {
        List<PointTextContainer> returnLabels = labels;
        this.dependencyCache.generateTileAndDependencyOnTile(cT);
        this.preprocessAreaLabels(areaLabels);
        this.preprocessLabels(returnLabels);
        this.preprocessSymbols(symbols);
        this.removeEmptySymbolReferences(returnLabels, symbols);
        this.removeOverlappingSymbolsWithAreaLabels(symbols, areaLabels);
        this.dependencyCache.removeOverlappingObjectsWithDependencyOnTile(returnLabels, areaLabels, symbols);
        if (!returnLabels.isEmpty()) {
            switch (1) {
                case 0: {
                    returnLabels = this.processTwoPointGreedy(returnLabels, symbols, areaLabels);
                    break;
                }
                case 1: {
                    returnLabels = this.processFourPointGreedy(returnLabels, symbols, areaLabels);
                    break;
                }
            }
        }
        this.dependencyCache.fillDependencyOnTile(returnLabels, symbols, areaLabels);
        return returnLabels;
    }

    void removeOverlappingSymbols(List<SymbolContainer> symbols) {
        int dis = this.symbolDistanceToSymbol;
        for (int x = 0; x < symbols.size(); ++x) {
            this.symbolContainer = symbols.get(x);
            this.rect1 = new Rect((int)this.symbolContainer.x - dis, (int)this.symbolContainer.y - dis, (int)this.symbolContainer.x + this.symbolContainer.symbol.getWidth() + dis, (int)this.symbolContainer.y + this.symbolContainer.symbol.getHeight() + dis);
            for (int y = x + 1; y < symbols.size(); ++y) {
                if (y == x) continue;
                this.symbolContainer = symbols.get(y);
                this.rect2 = new Rect((int)this.symbolContainer.x, (int)this.symbolContainer.y, (int)this.symbolContainer.x + this.symbolContainer.symbol.getWidth(), (int)this.symbolContainer.y + this.symbolContainer.symbol.getHeight());
                if (!Rect.intersects((Rect)this.rect2, (Rect)this.rect1)) continue;
                symbols.remove(y);
                --y;
            }
        }
    }

    void setLabelDistanceToLabel(int labelDistanceToLabel) {
        this.labelDistanceToLabel = labelDistanceToLabel;
    }

    void setLabelDistanceToSymbol(int labelDistanceToSymbol) {
        this.labelDistanceToSymbol = labelDistanceToSymbol;
    }

    void setStartDistanceToSymbols(int startDistanceToSymbols) {
        this.startDistanceToSymbols = startDistanceToSymbols;
    }

    void setSymbolDistanceToSymbol(int symbolDistanceToSymbol) {
        this.symbolDistanceToSymbol = symbolDistanceToSymbol;
    }

    static final class ReferencePositionYComparator
    implements Comparator<ReferencePosition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final ReferencePositionYComparator INSTANCE = new ReferencePositionYComparator();

        private ReferencePositionYComparator() {
        }

        @Override
        public int compare(ReferencePosition x, ReferencePosition y) {
            if (x.y < y.y) {
                return -1;
            }
            if (x.y > y.y) {
                return 1;
            }
            return 0;
        }
    }

    static final class ReferencePositionXComparator
    implements Comparator<ReferencePosition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final ReferencePositionXComparator INSTANCE = new ReferencePositionXComparator();

        private ReferencePositionXComparator() {
        }

        @Override
        public int compare(ReferencePosition x, ReferencePosition y) {
            if (x.x < y.x) {
                return -1;
            }
            if (x.x > y.x) {
                return 1;
            }
            return 0;
        }
    }

    static final class ReferencePositionWidthComparator
    implements Comparator<ReferencePosition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final ReferencePositionWidthComparator INSTANCE = new ReferencePositionWidthComparator();

        private ReferencePositionWidthComparator() {
        }

        @Override
        public int compare(ReferencePosition x, ReferencePosition y) {
            if (x.x + x.width < y.x + y.width) {
                return -1;
            }
            if (x.x + x.width > y.x + y.width) {
                return 1;
            }
            return 0;
        }
    }

    static final class ReferencePositionHeightComparator
    implements Comparator<ReferencePosition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final ReferencePositionHeightComparator INSTANCE = new ReferencePositionHeightComparator();

        private ReferencePositionHeightComparator() {
        }

        @Override
        public int compare(ReferencePosition x, ReferencePosition y) {
            if (x.y - x.height < y.y - y.height) {
                return -1;
            }
            if (x.y - x.height > y.y - y.height) {
                return 1;
            }
            return 0;
        }
    }

    static class ReferencePosition {
        final float height;
        final int nodeNumber;
        SymbolContainer symbol;
        final float width;
        final float x;
        final float y;

        ReferencePosition(float x, float y, int nodeNumber, float width, float height, SymbolContainer symbol) {
            this.x = x;
            this.y = y;
            this.nodeNumber = nodeNumber;
            this.width = width;
            this.height = height;
            this.symbol = symbol;
        }
    }
}

