/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.databaserenderer;

import android.graphics.Bitmap;
import android.graphics.Paint;
import java.util.List;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.SymbolContainer;
import org.mapsforge.v3.android.maps.mapgenerator.databaserenderer.WayTextContainer;

final class WayDecorator {
    private static final int DISTANCE_BETWEEN_SYMBOLS = 200;
    private static final int DISTANCE_BETWEEN_WAY_NAMES = 500;
    private static final int SEGMENT_SAFETY_DISTANCE = 30;

    static void renderSymbol(Bitmap symbolBitmap, boolean alignCenter, boolean repeatSymbol, float[][] coordinates, List<SymbolContainer> waySymbols) {
        int skipPixels = 30;
        float previousX = coordinates[0][0];
        float previousY = coordinates[0][1];
        for (int i = 2; i < coordinates[0].length; i += 2) {
            float currentX = coordinates[0][i];
            float currentY = coordinates[0][i + 1];
            float diffX = currentX - previousX;
            float diffY = currentY - previousY;
            double segmentLengthInPixel = Math.sqrt(diffX * diffX + diffY * diffY);
            float segmentLengthRemaining = (float)segmentLengthInPixel;
            while (segmentLengthRemaining - (float)skipPixels > 30.0f) {
                float segmentSkipPercentage = (float)skipPixels / segmentLengthRemaining;
                float symbolAngle = (float)Math.toDegrees(Math.atan2(currentY - (previousY += diffY * segmentSkipPercentage), currentX - (previousX += diffX * segmentSkipPercentage)));
                waySymbols.add(new SymbolContainer(symbolBitmap, previousX, previousY, alignCenter, symbolAngle));
                if (!repeatSymbol) {
                    return;
                }
                diffX = currentX - previousX;
                diffY = currentY - previousY;
                segmentLengthRemaining -= (float)skipPixels;
                skipPixels = 200;
            }
            if ((skipPixels = (int)((float)skipPixels - segmentLengthRemaining)) < 30) {
                skipPixels = 30;
            }
            previousX = currentX;
            previousY = currentY;
        }
    }

    static void renderText(String textKey, Paint paint, Paint outline, float[][] coordinates, List<WayTextContainer> wayNames) {
        float wayNameWidth = paint.measureText(textKey) + 10.0f;
        int skipPixels = 0;
        float previousX = coordinates[0][0];
        float previousY = coordinates[0][1];
        for (int i = 2; i < coordinates[0].length; i += 2) {
            float currentX = coordinates[0][i];
            float currentY = coordinates[0][i + 1];
            float diffX = currentX - previousX;
            float diffY = currentY - previousY;
            double segmentLengthInPixel = Math.sqrt(diffX * diffX + diffY * diffY);
            if (skipPixels > 0) {
                skipPixels = (int)((double)skipPixels - segmentLengthInPixel);
            } else if (segmentLengthInPixel > (double)wayNameWidth) {
                float[] wayNamePath = new float[4];
                if (previousX <= currentX) {
                    wayNamePath[0] = previousX;
                    wayNamePath[1] = previousY;
                    wayNamePath[2] = currentX;
                    wayNamePath[3] = currentY;
                } else {
                    wayNamePath[0] = currentX;
                    wayNamePath[1] = currentY;
                    wayNamePath[2] = previousX;
                    wayNamePath[3] = previousY;
                }
                wayNames.add(new WayTextContainer(wayNamePath, textKey, paint));
                if (outline != null) {
                    wayNames.add(new WayTextContainer(wayNamePath, textKey, outline));
                }
                skipPixels = 500;
            }
            previousX = currentX;
            previousY = currentY;
        }
    }

    private WayDecorator() {
        throw new IllegalStateException();
    }
}

