/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.tiledownloader;

import org.mapsforge.v3.android.maps.mapgenerator.tiledownloader.TileDownloader;
import org.mapsforge.v3.core.Tile;

public class ThunderforestTileDownloader
extends TileDownloader {
    private static final String HOST_NAME = "tile.thunderforest.com";
    private static final String PROTOCOL = "https";
    private static final byte ZOOM_MAX = 22;
    private String apiKey = null;
    private final StringBuilder stringBuilder = new StringBuilder();

    @Override
    public String getHostName() {
        return HOST_NAME;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public String getTilePath(Tile tile) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("/cycle/");
        this.stringBuilder.append(tile.zoomLevel);
        this.stringBuilder.append('/');
        this.stringBuilder.append(tile.tileX);
        this.stringBuilder.append('/');
        this.stringBuilder.append(tile.tileY);
        this.stringBuilder.append(".png");
        if (this.apiKey != null && this.apiKey.length() > 0) {
            this.stringBuilder.append("?apikey=");
            this.stringBuilder.append(this.apiKey);
        }
        return this.stringBuilder.toString();
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public byte getZoomLevelMax() {
        return 22;
    }
}

