/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.mapgenerator.tiledownloader;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.v3.android.maps.mapgenerator.MapGenerator;
import org.mapsforge.v3.android.maps.mapgenerator.MapGeneratorJob;
import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.core.Tile;

public abstract class TileDownloader
implements MapGenerator {
    private static final Logger LOG = Logger.getLogger(TileDownloader.class.getName());
    private static final GeoPoint START_POINT = new GeoPoint(51.33, 10.45);
    private static final Byte START_ZOOM_LEVEL = 5;
    private final int[] pixels = new int[65536];

    protected TileDownloader() {
    }

    @Override
    public final void cleanup() {
    }

    @Override
    public final boolean executeJob(MapGeneratorJob mapGeneratorJob, Bitmap bitmap) {
        try {
            Tile tile = mapGeneratorJob.tile;
            URL url = new URL(this.getProtocol(), this.getHostName(), this.getTilePath(tile));
            InputStream inputStream = url.openStream();
            Bitmap decodedBitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            if (decodedBitmap == null) {
                return false;
            }
            decodedBitmap.getPixels(this.pixels, 0, 256, 0, 0, 256, 256);
            decodedBitmap.recycle();
            bitmap.setPixels(this.pixels, 0, 256, 0, 0, 256, 256);
            return true;
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, null, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
            return false;
        }
    }

    public abstract String getHostName();

    public abstract String getProtocol();

    @Override
    public final GeoPoint getStartPoint() {
        return START_POINT;
    }

    @Override
    public final Byte getStartZoomLevel() {
        return START_ZOOM_LEVEL;
    }

    public abstract String getTilePath(Tile var1);

    @Override
    public final boolean requiresInternetConnection() {
        return true;
    }
}

