/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapsforge.v3.android.maps.overlay.CircleOverlay;
import org.mapsforge.v3.android.maps.overlay.OverlayCircle;

public class ArrayCircleOverlay
extends CircleOverlay<OverlayCircle> {
    private static final int INITIAL_CAPACITY = 8;
    private static final String THREAD_NAME = "ArrayCircleOverlay";
    private final List<OverlayCircle> overlayCircles = new ArrayList<OverlayCircle>(8);

    public ArrayCircleOverlay(Paint defaultPaintFill, Paint defaultPaintOutline) {
        super(defaultPaintFill, defaultPaintOutline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCircle(OverlayCircle overlayCircle) {
        List<OverlayCircle> list = this.overlayCircles;
        synchronized (list) {
            this.overlayCircles.add(overlayCircle);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCircles(Collection<? extends OverlayCircle> c) {
        List<OverlayCircle> list = this.overlayCircles;
        synchronized (list) {
            this.overlayCircles.addAll(c);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<OverlayCircle> list = this.overlayCircles;
        synchronized (list) {
            this.overlayCircles.clear();
        }
        this.populate();
    }

    @Override
    public String getThreadName() {
        return THREAD_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCircle(OverlayCircle overlayCircle) {
        List<OverlayCircle> list = this.overlayCircles;
        synchronized (list) {
            this.overlayCircles.remove(overlayCircle);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<OverlayCircle> list = this.overlayCircles;
        synchronized (list) {
            return this.overlayCircles.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OverlayCircle createCircle(int index) {
        List<OverlayCircle> list = this.overlayCircles;
        synchronized (list) {
            if (index >= this.overlayCircles.size()) {
                return null;
            }
            return this.overlayCircles.get(index);
        }
    }
}

