/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapsforge.v3.android.maps.overlay.ItemizedOverlay;
import org.mapsforge.v3.android.maps.overlay.OverlayItem;

public class ArrayItemizedOverlay
extends ItemizedOverlay<OverlayItem> {
    private static final int INITIAL_CAPACITY = 8;
    private static final String THREAD_NAME = "ArrayItemizedOverlay";
    private final List<OverlayItem> overlayItems = new ArrayList<OverlayItem>(8);

    public ArrayItemizedOverlay(Drawable defaultMarker) {
        this(defaultMarker, true);
    }

    public ArrayItemizedOverlay(Drawable defaultMarker, boolean alignMarker) {
        super(defaultMarker != null && alignMarker ? ItemizedOverlay.boundCenterBottom(defaultMarker) : defaultMarker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(OverlayItem overlayItem) {
        List<OverlayItem> list = this.overlayItems;
        synchronized (list) {
            this.overlayItems.add(overlayItem);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItems(Collection<? extends OverlayItem> c) {
        List<OverlayItem> list = this.overlayItems;
        synchronized (list) {
            this.overlayItems.addAll(c);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<OverlayItem> list = this.overlayItems;
        synchronized (list) {
            this.overlayItems.clear();
        }
        this.populate();
    }

    @Override
    public String getThreadName() {
        return THREAD_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(OverlayItem overlayItem) {
        List<OverlayItem> list = this.overlayItems;
        synchronized (list) {
            this.overlayItems.remove(overlayItem);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<OverlayItem> list = this.overlayItems;
        synchronized (list) {
            return this.overlayItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OverlayItem createItem(int index) {
        List<OverlayItem> list = this.overlayItems;
        synchronized (list) {
            if (index >= this.overlayItems.size()) {
                return null;
            }
            return this.overlayItems.get(index);
        }
    }
}

