/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapsforge.v3.android.maps.overlay.OverlayWay;
import org.mapsforge.v3.android.maps.overlay.WayOverlay;

public class ArrayWayOverlay
extends WayOverlay<OverlayWay> {
    private static final int INITIAL_CAPACITY = 8;
    private static final String THREAD_NAME = "ArrayWayOverlay";
    private final List<OverlayWay> overlayWays = new ArrayList<OverlayWay>(8);

    public ArrayWayOverlay(Paint defaultPaintFill, Paint defaultPaintOutline) {
        super(defaultPaintFill, defaultPaintOutline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWay(OverlayWay overlayWay) {
        List<OverlayWay> list = this.overlayWays;
        synchronized (list) {
            this.overlayWays.add(overlayWay);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWays(Collection<? extends OverlayWay> c) {
        List<OverlayWay> list = this.overlayWays;
        synchronized (list) {
            this.overlayWays.addAll(c);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<OverlayWay> list = this.overlayWays;
        synchronized (list) {
            this.overlayWays.clear();
        }
        this.populate();
    }

    @Override
    public String getThreadName() {
        return THREAD_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWay(OverlayWay overlayWay) {
        List<OverlayWay> list = this.overlayWays;
        synchronized (list) {
            this.overlayWays.remove(overlayWay);
        }
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<OverlayWay> list = this.overlayWays;
        synchronized (list) {
            return this.overlayWays.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OverlayWay createWay(int index) {
        List<OverlayWay> list = this.overlayWays;
        synchronized (list) {
            if (index >= this.overlayWays.size()) {
                return null;
            }
            return this.overlayWays.get(index);
        }
    }
}

