/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import java.util.ArrayList;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.Projection;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.android.maps.overlay.OverlayCircle;
import org.mapsforge.v3.core.GeoPoint;

public abstract class CircleOverlay<Circle extends OverlayCircle>
extends Overlay {
    private static final int INITIAL_CAPACITY = 8;
    private static final String THREAD_NAME = "CircleOverlay";
    private final Point circlePosition;
    private final Paint defaultPaintFill;
    private final Paint defaultPaintOutline;
    private final boolean hasDefaultPaint;
    private final Path path;
    private List<Integer> visibleCircles;
    private List<Integer> visibleCirclesRedraw;

    public CircleOverlay(Paint defaultPaintFill, Paint defaultPaintOutline) {
        this.defaultPaintFill = defaultPaintFill;
        this.defaultPaintOutline = defaultPaintOutline;
        this.hasDefaultPaint = defaultPaintFill != null || defaultPaintOutline != null;
        this.circlePosition = new Point();
        this.visibleCircles = new ArrayList<Integer>(8);
        this.visibleCirclesRedraw = new ArrayList<Integer>(8);
        this.path = new Path();
    }

    @Override
    public boolean onLongPress(GeoPoint geoPoint, MapView mapView) {
        return this.checkItemHit(geoPoint, mapView, Overlay.EventType.LONG_PRESS);
    }

    @Override
    public boolean onTap(GeoPoint geoPoint, MapView mapView) {
        return this.checkItemHit(geoPoint, mapView, Overlay.EventType.TAP);
    }

    public abstract int size();

    private void drawPathOnCanvas(Canvas canvas, Circle overlayCircle) {
        if (((OverlayCircle)overlayCircle).hasPaint) {
            if (((OverlayCircle)overlayCircle).paintOutline != null) {
                canvas.drawPath(this.path, ((OverlayCircle)overlayCircle).paintOutline);
            }
            if (((OverlayCircle)overlayCircle).paintFill != null) {
                canvas.drawPath(this.path, ((OverlayCircle)overlayCircle).paintFill);
            }
        } else if (this.hasDefaultPaint) {
            if (this.defaultPaintOutline != null) {
                canvas.drawPath(this.path, this.defaultPaintOutline);
            }
            if (this.defaultPaintFill != null) {
                canvas.drawPath(this.path, this.defaultPaintFill);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkItemHit(GeoPoint geoPoint, MapView mapView, Overlay.EventType eventType) {
        Projection projection = mapView.getProjection();
        Point eventPosition = projection.toPixels(geoPoint, null);
        if (eventPosition == null) {
            return false;
        }
        Point checkCirclePoint = new Point();
        List<Integer> list = this.visibleCircles;
        synchronized (list) {
            for (int i = this.visibleCircles.size() - 1; i >= 0; --i) {
                Integer circleIndex = this.visibleCircles.get(i);
                Circle checkOverlayCircle = this.createCircle(circleIndex);
                if (checkOverlayCircle == null) continue;
                Circle Circle2 = checkOverlayCircle;
                synchronized (Circle2) {
                    if (((OverlayCircle)checkOverlayCircle).center == null || ((OverlayCircle)checkOverlayCircle).radius < 0.0f) {
                        continue;
                    }
                    if ((checkCirclePoint = projection.toPixels(((OverlayCircle)checkOverlayCircle).center, checkCirclePoint)) == null) {
                        continue;
                    }
                    float diffX = checkCirclePoint.x - eventPosition.x;
                    float diffY = checkCirclePoint.y - eventPosition.y;
                    double distance = Math.sqrt(diffX * diffX + diffY * diffY);
                    if (distance <= (double)((OverlayCircle)checkOverlayCircle).cachedRadius) {
                        switch (eventType) {
                            case LONG_PRESS: {
                                if (!this.onLongPress(circleIndex)) break;
                                return true;
                            }
                            case TAP: {
                                if (!this.onTap(circleIndex)) break;
                                return true;
                            }
                        }
                    }
                    continue;
                }
            }
        }
        return false;
    }

    protected abstract Circle createCircle(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawOverlayBitmap(Canvas canvas, Point drawPosition, Projection projection, byte drawZoomLevel) {
        this.visibleCirclesRedraw.clear();
        int numberOfCircles = this.size();
        for (int circleIndex = 0; circleIndex < numberOfCircles; ++circleIndex) {
            if (this.isInterrupted() || this.sizeHasChanged()) {
                return;
            }
            Circle overlayCircle = this.createCircle(circleIndex);
            if (overlayCircle == null) continue;
            Circle Circle2 = overlayCircle;
            synchronized (Circle2) {
                if (((OverlayCircle)overlayCircle).center == null || ((OverlayCircle)overlayCircle).radius < 0.0f) {
                    continue;
                }
                if (drawZoomLevel != ((OverlayCircle)overlayCircle).cachedZoomLevel) {
                    ((OverlayCircle)overlayCircle).cachedCenterPosition = projection.toPoint(((OverlayCircle)overlayCircle).center, ((OverlayCircle)overlayCircle).cachedCenterPosition, drawZoomLevel);
                    ((OverlayCircle)overlayCircle).cachedZoomLevel = drawZoomLevel;
                    ((OverlayCircle)overlayCircle).cachedRadius = projection.metersToPixels(((OverlayCircle)overlayCircle).radius, drawZoomLevel);
                }
                this.circlePosition.x = ((OverlayCircle)overlayCircle).cachedCenterPosition.x - drawPosition.x;
                this.circlePosition.y = ((OverlayCircle)overlayCircle).cachedCenterPosition.y - drawPosition.y;
                float circleRadius = ((OverlayCircle)overlayCircle).cachedRadius;
                if ((float)this.circlePosition.x + circleRadius >= 0.0f && (float)this.circlePosition.x - circleRadius <= (float)canvas.getWidth() && (float)this.circlePosition.y + circleRadius >= 0.0f && (float)this.circlePosition.y - circleRadius <= (float)canvas.getHeight()) {
                    this.path.reset();
                    this.path.addCircle((float)this.circlePosition.x, (float)this.circlePosition.y, circleRadius, Path.Direction.CCW);
                    if (((OverlayCircle)overlayCircle).hasPaint || this.hasDefaultPaint) {
                        this.drawPathOnCanvas(canvas, overlayCircle);
                        this.visibleCirclesRedraw.add(circleIndex);
                    }
                }
                continue;
            }
        }
        List<Integer> list = this.visibleCircles;
        synchronized (list) {
            List<Integer> visibleCirclesTemp = this.visibleCircles;
            this.visibleCircles = this.visibleCirclesRedraw;
            this.visibleCirclesRedraw = visibleCirclesTemp;
        }
    }

    @Override
    protected String getThreadName() {
        return THREAD_NAME;
    }

    protected boolean onLongPress(int index) {
        return false;
    }

    protected boolean onTap(int index) {
        return false;
    }

    protected final void populate() {
        super.requestRedraw();
    }
}

