/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.List;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.Projection;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.android.maps.overlay.OverlayItem;
import org.mapsforge.v3.core.GeoPoint;

public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay {
    private static final int INITIAL_CAPACITY = 8;
    private static final String THREAD_NAME = "ItemizedOverlay";
    private int bottom;
    private final Drawable defaultMarker;
    private Drawable itemMarker;
    private final Point itemPosition;
    private int left;
    private int right;
    private int top;
    private List<Integer> visibleItems;
    private List<Integer> visibleItemsRedraw;

    public static Drawable boundCenter(Drawable balloon) {
        balloon.setBounds(balloon.getIntrinsicWidth() / -2, balloon.getIntrinsicHeight() / -2, balloon.getIntrinsicWidth() / 2, balloon.getIntrinsicHeight() / 2);
        return balloon;
    }

    public static Drawable boundCenterBottom(Drawable balloon) {
        balloon.setBounds(balloon.getIntrinsicWidth() / -2, -balloon.getIntrinsicHeight(), balloon.getIntrinsicWidth() / 2, 0);
        return balloon;
    }

    public ItemizedOverlay(Drawable defaultMarker) {
        this.defaultMarker = defaultMarker;
        this.itemPosition = new Point();
        this.visibleItems = new ArrayList<Integer>(8);
        this.visibleItemsRedraw = new ArrayList<Integer>(8);
    }

    @Override
    public boolean onLongPress(GeoPoint geoPoint, MapView mapView) {
        return this.checkItemHit(geoPoint, mapView, Overlay.EventType.LONG_PRESS);
    }

    @Override
    public boolean onTap(GeoPoint geoPoint, MapView mapView) {
        return this.checkItemHit(geoPoint, mapView, Overlay.EventType.TAP);
    }

    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkItemHit(GeoPoint geoPoint, MapView mapView, Overlay.EventType eventType) {
        Projection projection = mapView.getProjection();
        Point eventPosition = projection.toPixels(geoPoint, null);
        if (eventPosition == null) {
            return false;
        }
        Point checkItemPoint = new Point();
        List<Integer> list = this.visibleItems;
        synchronized (list) {
            for (int i = this.visibleItems.size() - 1; i >= 0; --i) {
                Integer itemIndex = this.visibleItems.get(i);
                Item checkOverlayItem = this.createItem(itemIndex);
                if (checkOverlayItem == null) continue;
                Item Item = checkOverlayItem;
                synchronized (Item) {
                    Rect checkMarkerBounds;
                    if (((OverlayItem)checkOverlayItem).getPoint() == null) {
                        continue;
                    }
                    checkItemPoint = projection.toPixels(((OverlayItem)checkOverlayItem).getPoint(), checkItemPoint);
                    if (checkItemPoint == null) {
                        continue;
                    }
                    if (((OverlayItem)checkOverlayItem).getMarker() == null) {
                        if (this.defaultMarker == null) {
                            continue;
                        }
                        checkMarkerBounds = this.defaultMarker.getBounds();
                    } else {
                        checkMarkerBounds = ((OverlayItem)checkOverlayItem).getMarker().getBounds();
                    }
                    int checkLeft = checkItemPoint.x + checkMarkerBounds.left;
                    int checkRight = checkItemPoint.x + checkMarkerBounds.right;
                    int checkTop = checkItemPoint.y + checkMarkerBounds.top;
                    int checkBottom = checkItemPoint.y + checkMarkerBounds.bottom;
                    if (checkRight >= eventPosition.x && checkLeft <= eventPosition.x && checkBottom >= eventPosition.y && checkTop <= eventPosition.y) {
                        switch (eventType) {
                            case LONG_PRESS: {
                                if (!this.onLongPress(itemIndex)) break;
                                return true;
                            }
                            case TAP: {
                                if (!this.onTap(itemIndex)) break;
                                return true;
                            }
                        }
                    }
                    continue;
                }
            }
        }
        return false;
    }

    protected abstract Item createItem(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawOverlayBitmap(Canvas canvas, Point drawPosition, Projection projection, byte drawZoomLevel) {
        this.visibleItemsRedraw.clear();
        int numberOfItems = this.size();
        for (int itemIndex = 0; itemIndex < numberOfItems; ++itemIndex) {
            if (this.isInterrupted() || this.sizeHasChanged()) {
                return;
            }
            Item overlayItem = this.createItem(itemIndex);
            if (overlayItem == null) continue;
            Item Item = overlayItem;
            synchronized (Item) {
                if (((OverlayItem)overlayItem).getPoint() == null) {
                    continue;
                }
                if (drawZoomLevel != ((OverlayItem)overlayItem).cachedZoomLevel) {
                    ((OverlayItem)overlayItem).cachedMapPosition = projection.toPoint(((OverlayItem)overlayItem).getPoint(), ((OverlayItem)overlayItem).cachedMapPosition, drawZoomLevel);
                    ((OverlayItem)overlayItem).cachedZoomLevel = drawZoomLevel;
                }
                this.itemPosition.x = ((OverlayItem)overlayItem).cachedMapPosition.x - drawPosition.x;
                this.itemPosition.y = ((OverlayItem)overlayItem).cachedMapPosition.y - drawPosition.y;
                if (((OverlayItem)overlayItem).getMarker() == null) {
                    if (this.defaultMarker == null) {
                        continue;
                    }
                    this.itemMarker = this.defaultMarker;
                } else {
                    this.itemMarker = ((OverlayItem)overlayItem).getMarker();
                }
                Rect markerBounds = this.itemMarker.copyBounds();
                this.left = this.itemPosition.x + markerBounds.left;
                this.right = this.itemPosition.x + markerBounds.right;
                this.top = this.itemPosition.y + markerBounds.top;
                this.bottom = this.itemPosition.y + markerBounds.bottom;
                if (this.right >= 0 && this.left <= canvas.getWidth() && this.bottom >= 0 && this.top <= canvas.getHeight()) {
                    this.itemMarker.setBounds(this.left, this.top, this.right, this.bottom);
                    this.itemMarker.draw(canvas);
                    this.itemMarker.setBounds(markerBounds);
                    this.visibleItemsRedraw.add(itemIndex);
                }
                continue;
            }
        }
        List<Integer> list = this.visibleItems;
        synchronized (list) {
            List<Integer> visibleItemsTemp = this.visibleItems;
            this.visibleItems = this.visibleItemsRedraw;
            this.visibleItemsRedraw = visibleItemsTemp;
        }
    }

    @Override
    protected String getThreadName() {
        return THREAD_NAME;
    }

    protected boolean onLongPress(int index) {
        return false;
    }

    protected boolean onTap(int index) {
        return false;
    }

    protected final void populate() {
        super.requestRedraw();
    }
}

