/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import org.mapsforge.v3.android.maps.MapView;
import org.mapsforge.v3.android.maps.Projection;
import org.mapsforge.v3.core.GeoPoint;

public abstract class Overlay
extends Thread {
    private static final String THREAD_NAME = "Overlay";
    private boolean changedSize;
    private boolean hasValidDimensions;
    private final Matrix matrix;
    private float matrixScaleFactor;
    private Bitmap overlayBitmap1;
    private Bitmap overlayBitmap2;
    private final Canvas overlayCanvas = new Canvas();
    private final Point point;
    private Point positionAfterDraw;
    private Point positionBeforeDraw;
    private boolean redraw;
    protected MapView internalMapView;

    protected Overlay() {
        this.matrix = new Matrix();
        this.point = new Point();
        this.positionBeforeDraw = new Point();
        this.positionAfterDraw = new Point();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(Canvas canvas) {
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            if (this.overlayBitmap1 != null) {
                canvas.drawBitmap(this.overlayBitmap1, this.matrix, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void matrixPostScale(float scaleX, float scaleY, float pivotX, float pivotY) {
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            this.matrix.postScale(scaleX, scaleY, pivotX, pivotY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void matrixPostTranslate(float translateX, float translateY) {
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            this.matrix.postTranslate(translateX, translateY);
        }
    }

    public boolean onLongPress(GeoPoint geoPoint, MapView mapView) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSizeChanged() {
        Overlay overlay = this;
        synchronized (overlay) {
            this.changedSize = true;
            this.notify();
        }
    }

    public boolean onTap(GeoPoint geoPoint, MapView mapView) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestRedraw() {
        Overlay overlay = this;
        synchronized (overlay) {
            this.redraw = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.setName(this.getThreadName());
        while (!this.isInterrupted()) {
            Overlay overlay = this;
            synchronized (overlay) {
                while (!(this.isInterrupted() || this.changedSize || this.redraw)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
            if (this.isInterrupted()) break;
            if (this.changedSize) {
                this.changeSize();
            }
            if (!this.redraw) continue;
            this.redrawOverlay();
        }
        if (this.overlayBitmap1 != null) {
            this.overlayBitmap1.recycle();
        }
        if (this.overlayBitmap2 != null) {
            this.overlayBitmap2.recycle();
        }
    }

    public final void setupOverlay(MapView mapView) {
        if (this.isInterrupted() || !this.isAlive()) {
            throw new IllegalThreadStateException("overlay thread already destroyed");
        }
        this.internalMapView = mapView;
        this.onSizeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawOverlay() {
        byte zoomLevelAfterDraw;
        byte zoomLevelBeforeDraw;
        this.redraw = false;
        if (!this.hasValidDimensions) {
            return;
        }
        Projection mapViewProjection = this.internalMapView.getProjection();
        this.overlayBitmap2.eraseColor(0);
        this.overlayCanvas.setBitmap(this.overlayBitmap2);
        this.overlayCanvas.setMatrix(this.overlayCanvas.getMatrix());
        MapView mapView = this.internalMapView;
        synchronized (mapView) {
            zoomLevelBeforeDraw = this.internalMapView.getMapPosition().getZoomLevel();
            this.positionBeforeDraw = mapViewProjection.toPoint(this.internalMapView.getMapPosition().getMapCenter(), this.positionBeforeDraw, zoomLevelBeforeDraw);
        }
        this.point.x = this.positionBeforeDraw.x - (this.overlayCanvas.getWidth() >> 1);
        this.point.y = this.positionBeforeDraw.y - (this.overlayCanvas.getHeight() >> 1);
        if (this.isInterrupted() || this.sizeHasChanged()) {
            return;
        }
        this.drawOverlayBitmap(this.overlayCanvas, this.point, mapViewProjection, zoomLevelBeforeDraw);
        if (this.isInterrupted() || this.sizeHasChanged()) {
            return;
        }
        MapView mapView2 = this.internalMapView;
        synchronized (mapView2) {
            zoomLevelAfterDraw = this.internalMapView.getMapPosition().getZoomLevel();
            this.positionAfterDraw = mapViewProjection.toPoint(this.internalMapView.getMapPosition().getMapCenter(), this.positionAfterDraw, zoomLevelBeforeDraw);
        }
        if (this.internalMapView.isZoomAnimatorRunning()) {
            return;
        }
        mapView2 = this.matrix;
        synchronized (mapView2) {
            this.matrix.reset();
            this.matrix.postTranslate((float)(this.positionBeforeDraw.x - this.positionAfterDraw.x), (float)(this.positionBeforeDraw.y - this.positionAfterDraw.y));
            byte zoomLevelDiff = (byte)(zoomLevelAfterDraw - zoomLevelBeforeDraw);
            if (zoomLevelDiff > 0) {
                this.matrixScaleFactor = 1 << zoomLevelDiff;
                this.matrix.postScale(this.matrixScaleFactor, this.matrixScaleFactor, (float)(this.overlayCanvas.getWidth() >> 1), (float)(this.overlayCanvas.getHeight() >> 1));
            } else if (zoomLevelDiff < 0) {
                this.matrixScaleFactor = 1.0f / (float)(1 << -zoomLevelDiff);
                this.matrix.postScale(this.matrixScaleFactor, this.matrixScaleFactor, (float)(this.overlayCanvas.getWidth() >> 1), (float)(this.overlayCanvas.getHeight() >> 1));
            }
            Bitmap overlayBitmapSwap = this.overlayBitmap1;
            this.overlayBitmap1 = this.overlayBitmap2;
            this.overlayBitmap2 = overlayBitmapSwap;
        }
        if (this.isInterrupted() || this.sizeHasChanged()) {
            return;
        }
        this.internalMapView.postInvalidate();
    }

    protected abstract void drawOverlayBitmap(Canvas var1, Point var2, Projection var3, byte var4);

    protected String getThreadName() {
        return THREAD_NAME;
    }

    final void changeSize() {
        this.changedSize = false;
        if (this.overlayBitmap1 != null) {
            this.overlayBitmap1.recycle();
        }
        if (this.overlayBitmap2 != null) {
            this.overlayBitmap2.recycle();
        }
        if (this.internalMapView.getWidth() > 0 && this.internalMapView.getHeight() > 0) {
            this.overlayBitmap1 = Bitmap.createBitmap((int)this.internalMapView.getWidth(), (int)this.internalMapView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.overlayBitmap2 = Bitmap.createBitmap((int)this.internalMapView.getWidth(), (int)this.internalMapView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.redraw = true;
            this.hasValidDimensions = true;
        } else {
            this.hasValidDimensions = false;
        }
    }

    boolean sizeHasChanged() {
        return this.changedSize;
    }

    protected static enum EventType {
        LONG_PRESS,
        TAP;

    }
}

