/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Paint;
import android.graphics.Point;
import org.mapsforge.v3.core.GeoPoint;

public class OverlayCircle {
    protected GeoPoint center;
    protected Paint paintFill;
    protected Paint paintOutline;
    protected float radius;
    protected String title;
    Point cachedCenterPosition;
    float cachedRadius;
    byte cachedZoomLevel;
    boolean hasPaint;

    public OverlayCircle() {
        this(null, 0.0f, null, null, null);
    }

    public OverlayCircle(GeoPoint center, float radius, Paint paintFill, Paint paintOutline, String title) {
        this.title = title;
        this.cachedCenterPosition = new Point();
        this.cachedZoomLevel = (byte)-128;
        this.setCircleDataInternal(center, radius);
        this.setPaintInternal(paintFill, paintOutline);
    }

    public OverlayCircle(GeoPoint center, float radius, String title) {
        this(center, radius, null, null, title);
    }

    public OverlayCircle(Paint paintFill, Paint paintOutline) {
        this(null, 0.0f, paintFill, paintOutline, null);
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized void setCircleData(GeoPoint center, float radius) {
        this.setCircleDataInternal(center, radius);
    }

    public synchronized void setPaint(Paint paintFill, Paint paintOutline) {
        this.setPaintInternal(paintFill, paintOutline);
    }

    public synchronized void setTitle(String title) {
        this.title = title;
    }

    private void setCircleDataInternal(GeoPoint center, float radius) {
        this.center = center;
        this.radius = radius;
        this.cachedZoomLevel = (byte)-128;
    }

    private void setPaintInternal(Paint paintFill, Paint paintOutline) {
        this.paintFill = paintFill;
        this.paintOutline = paintOutline;
        this.hasPaint = paintFill != null || paintOutline != null;
    }
}

