/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Paint;
import android.graphics.Point;
import org.mapsforge.v3.core.GeoPoint;

public class OverlayWay {
    protected Paint paintFill;
    protected Paint paintOutline;
    protected GeoPoint[][] wayNodes;
    Point[][] cachedWayPositions = new Point[0][0];
    byte cachedZoomLevel = (byte)-128;
    boolean hasPaint;

    private static boolean arrayLengthsEqual(Object[][] array1, Object[][] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = array1.length - 1; i >= 0; --i) {
            if (array1[i].length == array2[i].length) continue;
            return false;
        }
        return true;
    }

    private static boolean containsNullElements(GeoPoint[][] wayNodes) {
        for (int i = wayNodes.length - 1; i >= 0; --i) {
            if (wayNodes[i] == null) {
                return true;
            }
            for (int j = wayNodes[i].length - 1; j >= 0; --j) {
                if (wayNodes[i][j] != null) continue;
                return true;
            }
        }
        return false;
    }

    public OverlayWay() {
        this(null, null, null);
    }

    public OverlayWay(GeoPoint[][] wayNodes) {
        this(wayNodes, null, null);
    }

    public OverlayWay(GeoPoint[][] wayNodes, Paint paintFill, Paint paintOutline) {
        this.setWayNodesInternal(wayNodes);
        this.setPaintInternal(paintFill, paintOutline);
    }

    public OverlayWay(Paint paintFill, Paint paintOutline) {
        this(null, paintFill, paintOutline);
    }

    public synchronized GeoPoint[][] getWayNodes() {
        return (GeoPoint[][])this.wayNodes.clone();
    }

    public synchronized void setPaint(Paint paintFill, Paint paintOutline) {
        this.setPaintInternal(paintFill, paintOutline);
    }

    public synchronized void setWayNodes(GeoPoint[][] wayNodes) {
        this.setWayNodesInternal(wayNodes);
    }

    private void setPaintInternal(Paint paintFill, Paint paintOutline) {
        this.paintFill = paintFill;
        this.paintOutline = paintOutline;
        this.hasPaint = paintFill != null || paintOutline != null;
    }

    private void setWayNodesInternal(GeoPoint[][] wayNodes) {
        if (wayNodes == null) {
            this.wayNodes = null;
        } else {
            if (OverlayWay.containsNullElements(wayNodes)) {
                throw new IllegalArgumentException("way nodes must not contain null elements");
            }
            this.wayNodes = (GeoPoint[][])wayNodes.clone();
        }
        if (this.wayNodes == null) {
            this.cachedWayPositions = new Point[0][0];
        } else if (!OverlayWay.arrayLengthsEqual(this.wayNodes, this.cachedWayPositions)) {
            this.cachedWayPositions = new Point[this.wayNodes.length][];
            for (int i = this.wayNodes.length - 1; i >= 0; --i) {
                this.cachedWayPositions[i] = new Point[this.wayNodes[i].length];
            }
        }
        this.cachedZoomLevel = (byte)-128;
    }
}

