/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import org.mapsforge.v3.android.maps.Projection;
import org.mapsforge.v3.android.maps.overlay.Overlay;
import org.mapsforge.v3.android.maps.overlay.OverlayWay;

public abstract class WayOverlay<Way extends OverlayWay>
extends Overlay {
    private static final String THREAD_NAME = "WayOverlay";
    private final Paint defaultPaintFill;
    private final Paint defaultPaintOutline;
    private final Path path;

    public WayOverlay(Paint defaultPaintFill, Paint defaultPaintOutline) {
        this.defaultPaintFill = defaultPaintFill;
        this.defaultPaintOutline = defaultPaintOutline;
        this.path = new Path();
        this.path.setFillType(Path.FillType.EVEN_ODD);
    }

    public abstract int size();

    private void assemblePath(Point drawPosition, Way overlayWay) {
        this.path.reset();
        for (int i = 0; i < ((OverlayWay)overlayWay).cachedWayPositions.length; ++i) {
            this.path.moveTo((float)(((OverlayWay)overlayWay).cachedWayPositions[i][0].x - drawPosition.x), (float)(((OverlayWay)overlayWay).cachedWayPositions[i][0].y - drawPosition.y));
            for (int j = 1; j < ((OverlayWay)overlayWay).cachedWayPositions[i].length; ++j) {
                this.path.lineTo((float)(((OverlayWay)overlayWay).cachedWayPositions[i][j].x - drawPosition.x), (float)(((OverlayWay)overlayWay).cachedWayPositions[i][j].y - drawPosition.y));
            }
        }
    }

    private void drawPathOnCanvas(Canvas canvas, Way overlayWay) {
        if (((OverlayWay)overlayWay).hasPaint) {
            if (((OverlayWay)overlayWay).paintOutline != null) {
                canvas.drawPath(this.path, ((OverlayWay)overlayWay).paintOutline);
            }
            if (((OverlayWay)overlayWay).paintFill != null) {
                canvas.drawPath(this.path, ((OverlayWay)overlayWay).paintFill);
            }
        } else {
            if (this.defaultPaintOutline != null) {
                canvas.drawPath(this.path, this.defaultPaintOutline);
            }
            if (this.defaultPaintFill != null) {
                canvas.drawPath(this.path, this.defaultPaintFill);
            }
        }
    }

    protected abstract Way createWay(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawOverlayBitmap(Canvas canvas, Point drawPosition, Projection projection, byte drawZoomLevel) {
        int numberOfWays = this.size();
        for (int wayIndex = 0; wayIndex < numberOfWays; ++wayIndex) {
            if (this.isInterrupted() || this.sizeHasChanged()) {
                return;
            }
            Way overlayWay = this.createWay(wayIndex);
            if (overlayWay == null) continue;
            Way Way = overlayWay;
            synchronized (Way) {
                if (((OverlayWay)overlayWay).wayNodes == null || ((OverlayWay)overlayWay).wayNodes.length == 0) {
                    continue;
                }
                if (drawZoomLevel != ((OverlayWay)overlayWay).cachedZoomLevel) {
                    for (int i = 0; i < ((OverlayWay)overlayWay).cachedWayPositions.length; ++i) {
                        for (int j = 0; j < ((OverlayWay)overlayWay).cachedWayPositions[i].length; ++j) {
                            ((OverlayWay)overlayWay).cachedWayPositions[i][j] = projection.toPoint(((OverlayWay)overlayWay).wayNodes[i][j], ((OverlayWay)overlayWay).cachedWayPositions[i][j], drawZoomLevel);
                        }
                    }
                    ((OverlayWay)overlayWay).cachedZoomLevel = drawZoomLevel;
                }
                this.assemblePath(drawPosition, overlayWay);
                this.drawPathOnCanvas(canvas, overlayWay);
                continue;
            }
        }
    }

    @Override
    protected String getThreadName() {
        return THREAD_NAME;
    }

    protected final void populate() {
        super.requestRedraw();
    }
}

